/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.base.IBaseProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0014H\u0004J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\rH\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/github/mikephil/charting/renderer/HorizontalBarChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarChartRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "initBuffers", "", "mBarShadowRectBuffer", "Landroid/graphics/RectF;", "drawDataSet", "canvas", "Landroid/graphics/Canvas;", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "index", "", "drawValues", "drawValue", "valueText", "", "x", "", "y", "color", "prepareBarHighlight", "y1", "y2", "barWidthHalf", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "setHighlightDrawPos", "high", "Lcom/github/mikephil/charting/highlight/Highlight;", "bar", "isDrawingValuesAllowed", "", "baseProvider", "Lcom/github/mikephil/charting/interfaces/dataprovider/base/IBaseProvider;", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nHorizontalBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalBarChartRenderer.kt\ncom/github/mikephil/charting/renderer/HorizontalBarChartRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,464:1\n1#2:465\n*E\n"})
public class HorizontalBarChartRenderer
extends BarChartRenderer {
    @NotNull
    private final RectF mBarShadowRectBuffer;

    public HorizontalBarChartRenderer(@NotNull BarDataProvider chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(chart, animator, viewPortHandler);
        this.mBarShadowRectBuffer = new RectF();
        this.getPaintValues().setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        block1: {
            BarData barData = this.dataProvider.getBarData();
            if (barData == null) break block1;
            BarData barData2 = barData;
            boolean bl = false;
            this.barBuffers = ArraysKt.toMutableList((Object[])new HorizontalBarBuffer[barData2.getDataSetCount()]);
            int n = ((Collection)this.barBuffers).size();
            for (int i = 0; i < n; ++i) {
                IBarDataSet it;
                IBarDataSet set = (IBarDataSet)barData2.getDataSetByIndex(i);
                if (set == null) continue;
                boolean bl2 = false;
                this.barBuffers.set(i, new HorizontalBarBuffer(it.getEntryCount() * 4 * (set.isStacked() ? set.getStackSize() : 1), barData2.getDataSetCount(), set.isStacked()));
            }
        }
    }

    @Override
    protected void drawDataSet(@NotNull Canvas canvas, @NotNull IBarDataSet dataSet, int index) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(UtilsKtKt.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.animator.getPhaseX();
        float phaseY = this.animator.getPhaseY();
        if (this.dataProvider.isDrawBarShadowEnabled()) {
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.dataProvider.getBarData();
            if (barData != null) {
                BarData barData2 = barData;
                boolean bl = false;
                float barWidth = barData2.getBarWidth();
                float barWidthHalf = barWidth / 2.0f;
                float x = 0.0f;
                int i = 0;
                int count = (int)Math.min((double)((int)Math.ceil((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
                while (i < count) {
                    BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(i);
                    if (barEntry != null) {
                        BarEntry it;
                        boolean bl2 = false;
                        x = it.getX();
                        this.mBarShadowRectBuffer.top = x - barWidthHalf;
                        this.mBarShadowRectBuffer.bottom = x + barWidthHalf;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.rectValueToPixel(this.mBarShadowRectBuffer);
                        if (!this.viewPortHandler.isInBoundsTop(this.mBarShadowRectBuffer.bottom)) {
                            ++i;
                            continue;
                        }
                        if (!this.viewPortHandler.isInBoundsBottom(this.mBarShadowRectBuffer.top)) break;
                        this.mBarShadowRectBuffer.left = this.viewPortHandler.contentLeft();
                        this.mBarShadowRectBuffer.right = this.viewPortHandler.contentRight();
                        canvas.drawRect(this.mBarShadowRectBuffer, this.shadowPaint);
                    }
                    ++i;
                }
            }
        }
        Object e = this.barBuffers.get(index);
        Intrinsics.checkNotNull(e);
        BarBuffer buffer = (BarBuffer)e;
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.dataProvider.isInverted(dataSet.getAxisDependency()));
        BarData barData = this.dataProvider.getBarData();
        if (barData != null) {
            BarData it = barData;
            boolean bl = false;
            buffer.setBarWidth(it.getBarWidth());
        }
        buffer.feed(dataSet);
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(buffer.buffer);
        boolean isCustomFill = !((Collection)dataSet.getFills()).isEmpty();
        boolean isSingleColor = dataSet.getColors().size() == 1;
        boolean isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
        if (isSingleColor) {
            this.getPaintRender().setColor(dataSet.getColor());
        }
        int j = 0;
        int pos = 0;
        while (j < buffer.size() && this.viewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) {
            if (!this.viewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                j += 4;
                ++pos;
                continue;
            }
            if (!isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColorByIndex(j / 4));
            }
            if (isCustomFill) {
                Fill fill = dataSet.getFill(pos);
                if (fill != null) {
                    fill.fillRect(canvas, this.getPaintRender(), buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], isInverted ? Fill.Direction.LEFT : Fill.Direction.RIGHT, 0.0f);
                }
            } else {
                canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
            }
            if (drawBorder) {
                canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.barBorderPaint);
            }
            j += 4;
            ++pos;
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block25: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block25;
            BarData barData = this.dataProvider.getBarData();
            List dataSets = barData != null ? barData.getDataSets() : null;
            float valueOffsetPlus = UtilsKtKt.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.dataProvider.isDrawValueAboveBarEnabled();
            BarData barData2 = this.dataProvider.getBarData();
            if (barData2 == null) break block25;
            BarData barData3 = barData2;
            boolean bl = false;
            int n = barData3.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                MPPointF iconsOffset;
                block24: {
                    float phaseY;
                    BarBuffer buffer;
                    IValueFormatter formatter;
                    float halfTextHeight;
                    boolean isInverted;
                    IBarDataSet dataSet;
                    block26: {
                        List list = dataSets;
                        Intrinsics.checkNotNull(list);
                        dataSet = (IBarDataSet)list.get(i);
                        if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                        isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
                        this.applyValueTextStyle(dataSet);
                        halfTextHeight = (float)Utils.INSTANCE.calcTextHeight(this.getPaintValues(), "10") / 2.0f;
                        formatter = dataSet.getValueFormatter();
                        Object e = this.barBuffers.get(i);
                        Intrinsics.checkNotNull(e);
                        buffer = (BarBuffer)e;
                        phaseY = this.animator.getPhaseY();
                        iconsOffset = MPPointF.Companion.getInstance(dataSet.getIconsOffset());
                        iconsOffset.setX(UtilsKtKt.convertDpToPixel(iconsOffset.getX()));
                        iconsOffset.setY(UtilsKtKt.convertDpToPixel(iconsOffset.getY()));
                        if (dataSet.isStacked()) break block26;
                        int j = 0;
                        while ((float)j < (float)buffer.buffer.length * this.animator.getPhaseX()) {
                            float y = (buffer.buffer[j + 1] + buffer.buffer[j + 3]) / 2.0f;
                            if (!this.viewPortHandler.isInBoundsTop(buffer.buffer[j + 1])) break block24;
                            if (!this.viewPortHandler.isInBoundsX(buffer.buffer[j])) {
                                j += 4;
                                continue;
                            }
                            if (!this.viewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                                j += 4;
                                continue;
                            }
                            BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            if (barEntry != null) {
                                boolean bl2 = false;
                                float valueY = barEntry.getY();
                                String formattedValue = formatter.getFormattedValue(valueY, barEntry, i, this.viewPortHandler);
                                float valueTextWidth = Utils.INSTANCE.calcTextWidth(this.getPaintValues(), formattedValue);
                                posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                negOffset = (drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus) - (buffer.buffer[j + 2] - buffer.buffer[j]);
                                if (isInverted) {
                                    posOffset = -posOffset - valueTextWidth;
                                    negOffset = -negOffset - valueTextWidth;
                                }
                                if (dataSet.isDrawValues()) {
                                    String string = formattedValue;
                                    Intrinsics.checkNotNull((Object)string);
                                    this.drawValue(canvas, string, buffer.buffer[j + 2] + (valueY >= 0.0f ? posOffset : negOffset), y + halfTextHeight, dataSet.getValueTextColor(j / 2));
                                }
                                if (barEntry.getIcon() != null && dataSet.isDrawIcons()) {
                                    Drawable icon = barEntry.getIcon();
                                    float px = 0.0f;
                                    px = buffer.buffer[j + 2] + (valueY >= 0.0f ? posOffset : negOffset);
                                    float py = 0.0f;
                                    py = y;
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon != null) {
                                        Drawable it;
                                        boolean bl3 = false;
                                        Utils.INSTANCE.drawImage(canvas, it, (int)px, (int)py);
                                    }
                                }
                            }
                            j += 4;
                        }
                        break block24;
                    }
                    Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.animator.getPhaseX()) {
                        block27: {
                            float[] vals;
                            block29: {
                                float y;
                                BarEntry it;
                                int color;
                                block28: {
                                    Drawable myIcon;
                                    BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(index);
                                    if (barEntry == null) break block27;
                                    boolean bl4 = false;
                                    color = dataSet.getValueTextColor(index);
                                    vals = it.getYVals();
                                    if (vals != null) break block28;
                                    if (!this.viewPortHandler.isInBoundsTop(buffer.buffer[bufferIndex + 1])) break block24;
                                    if (!this.viewPortHandler.isInBoundsX(buffer.buffer[bufferIndex]) || !this.viewPortHandler.isInBoundsBottom(buffer.buffer[bufferIndex + 1])) continue;
                                    String formattedValue = formatter.getFormattedValue(it.getY(), it, i, this.viewPortHandler);
                                    float valueTextWidth = Utils.INSTANCE.calcTextWidth(this.getPaintValues(), formattedValue);
                                    posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                    float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                    if (isInverted) {
                                        posOffset = -posOffset - valueTextWidth;
                                        negOffset = -negOffset - valueTextWidth;
                                    }
                                    if (dataSet.isDrawValues()) {
                                        String string = formattedValue;
                                        Intrinsics.checkNotNull((Object)string);
                                        this.drawValue(canvas, string, buffer.buffer[bufferIndex + 2] + (it.getY() >= 0.0f ? posOffset : negOffset), buffer.buffer[bufferIndex + 1] + halfTextHeight, color);
                                    }
                                    if (it.getIcon() == null || !dataSet.isDrawIcons()) break block29;
                                    Drawable icon = it.getIcon();
                                    float px = 0.0f;
                                    px = buffer.buffer[bufferIndex + 2] + (it.getY() >= 0.0f ? posOffset : negOffset);
                                    float py = 0.0f;
                                    py = buffer.buffer[bufferIndex + 1];
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon == null) break block29;
                                    boolean bl5 = false;
                                    Utils.INSTANCE.drawImage(canvas, myIcon, (int)px, (int)py);
                                    break block29;
                                }
                                float[] transformed = new float[vals.length * 2];
                                float posY = 0.0f;
                                float negY = 0.0f;
                                negY = -it.getNegativeSum();
                                HorizontalBarChartRenderer $this$drawValues_u24lambda_u240_u241_u241 = this;
                                boolean bl6 = false;
                                int k = 0;
                                int idx = 0;
                                while (k < transformed.length) {
                                    float value = vals[idx];
                                    y = 0.0f;
                                    if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                        y = value;
                                    } else if (value >= 0.0f) {
                                        y = posY += value;
                                    } else {
                                        y = negY;
                                        negY -= value;
                                    }
                                    transformed[k] = y * phaseY;
                                    k += 2;
                                    ++idx;
                                }
                                Transformer transformer = trans;
                                Intrinsics.checkNotNull((Object)transformer);
                                transformer.pointValuesToPixel(transformed);
                                int k2 = 0;
                                while (k2 < transformed.length) {
                                    float valueY = vals[k2 / 2];
                                    String formattedValue = formatter.getFormattedValue(valueY, it, i, this.viewPortHandler);
                                    float valueTextWidth = Utils.INSTANCE.calcTextWidth(this.getPaintValues(), formattedValue);
                                    posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                    float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                    if (isInverted) {
                                        posOffset = -posOffset - valueTextWidth;
                                        negOffset = -negOffset - valueTextWidth;
                                    }
                                    boolean drawBelow = valueY == 0.0f && negY == 0.0f && posY > 0.0f || valueY < 0.0f;
                                    float x = transformed[k2] + (drawBelow ? negOffset : posOffset);
                                    y = (buffer.buffer[bufferIndex + 1] + buffer.buffer[bufferIndex + 3]) / 2.0f;
                                    if (!this.viewPortHandler.isInBoundsTop(y)) break;
                                    if (!this.viewPortHandler.isInBoundsX(x)) {
                                        k2 += 2;
                                        continue;
                                    }
                                    if (!this.viewPortHandler.isInBoundsBottom(y)) {
                                        k2 += 2;
                                        continue;
                                    }
                                    if (dataSet.isDrawValues()) {
                                        String string = formattedValue;
                                        Intrinsics.checkNotNull((Object)string);
                                        this.drawValue(canvas, string, x, y + halfTextHeight, color);
                                    }
                                    if (it.getIcon() != null && dataSet.isDrawIcons()) {
                                        Drawable icon = it.getIcon();
                                        if (icon != null) {
                                            Drawable myIcon;
                                            boolean bl7 = false;
                                            Utils.INSTANCE.drawImage(canvas, myIcon, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                        }
                                    }
                                    k2 += 2;
                                }
                            }
                            bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        }
                        ++index;
                    }
                }
                MPPointF.Companion.recycleInstance(iconsOffset);
            }
        }
    }

    protected final void drawValue(@NotNull Canvas canvas, @NotNull String valueText, float x, float y, int color) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)valueText, (String)"valueText");
        this.getPaintValues().setColor(color);
        canvas.drawText(valueText, x, y, this.getPaintValues());
    }

    @Override
    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, @NotNull Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        float top = x - barWidthHalf;
        float bottom = x + barWidthHalf;
        this.barRect.set(y1, top, y2, bottom);
        trans.rectToPixelPhaseHorizontal(this.barRect, this.animator.getPhaseY());
    }

    @Override
    protected void setHighlightDrawPos(@NotNull Highlight high, @NotNull RectF bar) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        high.setDraw(bar.centerY(), bar.right);
    }

    @Override
    protected boolean isDrawingValuesAllowed(@NotNull IBaseProvider baseProvider) {
        Intrinsics.checkNotNullParameter((Object)baseProvider, (String)"baseProvider");
        ChartData<?> chartData = baseProvider.getData();
        Intrinsics.checkNotNull(chartData);
        return (float)chartData.getEntryCount() < (float)baseProvider.getMaxVisibleCount() * this.viewPortHandler.getScaleY();
    }
}

