/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/mikephil/charting/renderer/CandleStickChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineScatterCandleRadarRenderer;", "dataProvider", "Lcom/github/mikephil/charting/interfaces/dataprovider/CandleDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/CandleDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "shadowBuffers", "", "bodyBuffers", "rangeBuffers", "openBuffers", "closeBuffers", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/ICandleDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nCandleStickChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandleStickChartRenderer.kt\ncom/github/mikephil/charting/renderer/CandleStickChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1915#2,2:320\n*S KotlinDebug\n*F\n+ 1 CandleStickChartRenderer.kt\ncom/github/mikephil/charting/renderer/CandleStickChartRenderer\n*L\n31#1:320,2\n*E\n"})
public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    @JvmField
    @NotNull
    public CandleDataProvider dataProvider;
    @NotNull
    private final float[] shadowBuffers;
    @NotNull
    private final float[] bodyBuffers;
    @NotNull
    private final float[] rangeBuffers;
    @NotNull
    private final float[] openBuffers;
    @NotNull
    private final float[] closeBuffers;

    public CandleStickChartRenderer(@NotNull CandleDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.shadowBuffers = new float[8];
        this.bodyBuffers = new float[4];
        this.rangeBuffers = new float[4];
        this.openBuffers = new float[4];
        this.closeBuffers = new float[4];
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            CandleData candleData = this.dataProvider.getCandleData();
            Object object = candleData;
            if (object == null || (object = ((ChartData)object).getDataSets()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ICandleDataSet set = (ICandleDataSet)element$iv;
                boolean bl = false;
                if (!set.isVisible()) continue;
                this.drawDataSet(canvas, set);
            }
        }
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull ICandleDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        float barSpace = dataSet.getBarSpace();
        boolean showCandleBar = dataSet.getShowCandleBar();
        this.getXBounds();
        this.getXBounds().set(this.dataProvider, dataSet);
        this.getPaintRender().setStrokeWidth(dataSet.getShadowWidth());
        int j = this.getXBounds().getMin();
        int n = this.getXBounds().getRange() + this.getXBounds().getMin();
        if (j <= n) {
            while (true) {
                if ((CandleEntry)dataSet.getEntryForIndex(j) != null) {
                    CandleEntry e;
                    float xPos = e.getX();
                    float open = e.getOpen();
                    float close = e.getClose();
                    float high = e.getHigh();
                    float low = e.getLow();
                    if (showCandleBar) {
                        this.shadowBuffers[0] = xPos;
                        this.shadowBuffers[2] = xPos;
                        this.shadowBuffers[4] = xPos;
                        this.shadowBuffers[6] = xPos;
                        if (open > close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = close * phaseY;
                        } else if (open < close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = close * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = open * phaseY;
                        } else {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = this.shadowBuffers[3];
                        }
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.shadowBuffers);
                        if (dataSet.getShadowColorSameAsCandle()) {
                            if (open > close) {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getDecreasingColor());
                            } else if (open < close) {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getIncreasingColor());
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getNeutralColor());
                            }
                        } else {
                            this.getPaintRender().setColor(dataSet.getShadowColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getShadowColor());
                        }
                        this.getPaintRender().setStyle(Paint.Style.STROKE);
                        canvas.drawLines(this.shadowBuffers, this.getPaintRender());
                        this.bodyBuffers[0] = xPos - 0.5f + barSpace;
                        this.bodyBuffers[1] = close * phaseY;
                        this.bodyBuffers[2] = xPos + 0.5f - barSpace;
                        this.bodyBuffers[3] = open * phaseY;
                        trans.pointValuesToPixel(this.bodyBuffers);
                        if (open > close) {
                            if (dataSet.getDecreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getDecreasingPaintStyle());
                            canvas.drawRect(this.bodyBuffers[0], this.bodyBuffers[3], this.bodyBuffers[2], this.bodyBuffers[1], this.getPaintRender());
                        } else if (open < close) {
                            if (dataSet.getIncreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getIncreasingPaintStyle());
                            canvas.drawRect(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        } else {
                            if (dataSet.getNeutralColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor());
                            }
                            canvas.drawLine(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        }
                    } else {
                        this.rangeBuffers[0] = xPos;
                        this.rangeBuffers[1] = high * phaseY;
                        this.rangeBuffers[2] = xPos;
                        this.rangeBuffers[3] = low * phaseY;
                        this.openBuffers[0] = xPos - 0.5f + barSpace;
                        this.openBuffers[1] = open * phaseY;
                        this.openBuffers[2] = xPos;
                        this.openBuffers[3] = open * phaseY;
                        this.closeBuffers[0] = xPos + 0.5f - barSpace;
                        this.closeBuffers[1] = close * phaseY;
                        this.closeBuffers[2] = xPos;
                        this.closeBuffers[3] = close * phaseY;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.rangeBuffers);
                        trans.pointValuesToPixel(this.openBuffers);
                        trans.pointValuesToPixel(this.closeBuffers);
                        int barColor = open > close ? (dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getDecreasingColor()) : (open < close ? (dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getIncreasingColor()) : (dataSet.getNeutralColor() == 0x112233 ? dataSet.getColorByIndex(j) : dataSet.getNeutralColor()));
                        this.getPaintRender().setColor(barColor);
                        canvas.drawLine(this.rangeBuffers[0], this.rangeBuffers[1], this.rangeBuffers[2], this.rangeBuffers[3], this.getPaintRender());
                        canvas.drawLine(this.openBuffers[0], this.openBuffers[1], this.openBuffers[2], this.openBuffers[3], this.getPaintRender());
                        canvas.drawLine(this.closeBuffers[0], this.closeBuffers[1], this.closeBuffers[2], this.closeBuffers[3], this.getPaintRender());
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block8;
            CandleData candleData = this.dataProvider.getCandleData();
            if (candleData != null) {
                CandleData it = candleData;
                boolean bl = false;
                List list = it.getDataSets();
                if (list != null) {
                    List it1 = list;
                    boolean bl2 = false;
                    int n = ((Collection)it1).size();
                    for (int i = 0; i < n; ++i) {
                        List list2 = it.getDataSets();
                        Intrinsics.checkNotNull(list2);
                        ICandleDataSet dataSet = (ICandleDataSet)list2.get(i);
                        if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                        this.applyValueTextStyle(dataSet);
                        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                        this.getXBounds().set(this.dataProvider, dataSet);
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        float[] positions = transformer.generateTransformedValuesCandle(dataSet, this.animator.getPhaseX(), this.animator.getPhaseY(), this.getXBounds().getMin(), this.getXBounds().getMax());
                        float yOffset = UtilsKtKt.convertDpToPixel(5.0f);
                        MPPointF iconsOffset = MPPointF.Companion.getInstance(dataSet.getIconsOffset());
                        iconsOffset.setX(UtilsKtKt.convertDpToPixel(iconsOffset.getX()));
                        iconsOffset.setY(UtilsKtKt.convertDpToPixel(iconsOffset.getY()));
                        int j = 0;
                        while (j < positions.length) {
                            float x = positions[j];
                            float y = positions[j + 1];
                            if (!this.viewPortHandler.isInBoundsRight(x)) break;
                            if (!this.viewPortHandler.isInBoundsLeft(x) || !this.viewPortHandler.isInBoundsY(y)) {
                                j += 2;
                                continue;
                            }
                            Object t = dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin());
                            Intrinsics.checkNotNull(t);
                            CandleEntry entry = (CandleEntry)t;
                            if (dataSet.isDrawValues()) {
                                this.drawValue(canvas, dataSet.getValueFormatter(), entry.getHigh(), entry, i, x, y - yOffset, dataSet.getValueTextColor(j / 2));
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = entry.getIcon();
                                if (icon != null) {
                                    Drawable ico;
                                    boolean bl3 = false;
                                    Utils.INSTANCE.drawImage(canvas, ico, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                }
                            }
                            j += 2;
                        }
                        MPPointF.Companion.recycleInstance(iconsOffset);
                    }
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        CandleData candleData = this.dataProvider.getCandleData();
        for (Highlight high : indices) {
            CandleEntry it;
            ICandleDataSet set;
            CandleData candleData2 = candleData;
            ICandleDataSet iCandleDataSet = set = candleData2 != null ? (ICandleDataSet)candleData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            CandleEntry candleEntry = (CandleEntry)set.getEntryForXValue(high.getX(), high.getY());
            if (candleEntry == null) continue;
            boolean bl = false;
            if (!this.isInBoundsX((Entry)candleEntry, set)) continue;
            float lowValue = it.getLow() * this.animator.getPhaseY();
            float highValue = it.getHigh() * this.animator.getPhaseY();
            float y = (lowValue + highValue) / 2.0f;
            Transformer transformer = this.dataProvider.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pix = transformer.getPixelForValues(it.getX(), y);
            high.setDraw((float)pix.getX(), (float)pix.getY());
            this.drawHighlightLines(canvas, (float)pix.getX(), (float)pix.getY(), set);
        }
    }
}

