/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.base.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.Transformer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J(\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ%\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\tH\u0004\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0014\u00a8\u0006\u001d"}, d2={"Lcom/github/mikephil/charting/highlight/BarHighlighter;", "Lcom/github/mikephil/charting/highlight/ChartHighlighter;", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "barDataProvider", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;)V", "getHighlight", "Lcom/github/mikephil/charting/highlight/Highlight;", "x", "", "y", "getStackedHighlight", "high", "set", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "xVal", "yVal", "getClosestStackIndex", "", "ranges", "", "Lcom/github/mikephil/charting/highlight/Range;", "value", "([Lcom/github/mikephil/charting/highlight/Range;F)I", "getDistance", "x1", "y1", "x2", "y2", "MPChartLib_release"})
public class BarHighlighter
extends ChartHighlighter<BarDataProvider> {
    public BarHighlighter(@NotNull BarDataProvider barDataProvider) {
        Intrinsics.checkNotNullParameter((Object)barDataProvider, (String)"barDataProvider");
        super((BarLineScatterCandleBubbleDataProvider)barDataProvider);
    }

    @Override
    @Nullable
    public Highlight getHighlight(float x, float y) {
        Highlight highlight = super.getHighlight(x, y);
        if (highlight == null) {
            return null;
        }
        Highlight high = highlight;
        MPPointD pos = this.getValsForTouch(x, y);
        BarData barData = ((BarDataProvider)this.getProvider()).getBarData();
        if (barData != null) {
            BarData barData2 = barData;
            boolean bl = false;
            IBarDataSet iBarDataSet = (IBarDataSet)barData2.getDataSetByIndex(high.getDataSetIndex());
            if (iBarDataSet != null) {
                IBarDataSet set = iBarDataSet;
                boolean bl2 = false;
                if (set.isStacked()) {
                    return this.getStackedHighlight(high, set, (float)pos.getX(), (float)pos.getY());
                }
            }
        }
        MPPointD.Companion.recycleInstance(pos);
        return high;
    }

    @Nullable
    public final Highlight getStackedHighlight(@NotNull Highlight high, @NotNull IBarDataSet set, float xVal, float yVal) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        BarEntry barEntry = (BarEntry)set.getEntryForXValue(xVal, yVal);
        if (barEntry != null) {
            BarEntry entry = barEntry;
            boolean bl = false;
            if (entry.getYVals() == null) {
                return high;
            }
            Range[] ranges = entry.getRanges();
            if (!(ranges.length == 0)) {
                int stackIndex = this.getClosestStackIndex(ranges, yVal);
                Transformer transformer = ((BarDataProvider)this.getProvider()).getTransformer(set.getAxisDependency());
                Intrinsics.checkNotNull((Object)transformer);
                MPPointD pixels = transformer.getPixelForValues(high.getX(), ranges[stackIndex].getTo());
                Highlight stackedHigh = new Highlight(entry.getX(), entry.getY(), (float)pixels.getX(), (float)pixels.getY(), high.getDataSetIndex(), stackIndex, high.getAxis());
                MPPointD.Companion.recycleInstance(pixels);
                return stackedHigh;
            }
        }
        return null;
    }

    protected final int getClosestStackIndex(@Nullable Range[] ranges, float value) {
        if (ranges == null || ranges.length == 0) {
            return 0;
        }
        int stackIndex = 0;
        for (Range range : ranges) {
            if (range.contains(value)) {
                return stackIndex;
            }
            ++stackIndex;
        }
        int length = Math.max(ranges.length - 1, 0);
        return value > ranges[length].getTo() ? length : 0;
    }

    @Override
    protected float getDistance(float x1, float y1, float x2, float y2) {
        return Math.abs(x1 - x2);
    }
}

