/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J,\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0019\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\fJ\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0002R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/mikephil/charting/formatter/LargeValueFormatter;", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "Lcom/github/mikephil/charting/formatter/IAxisValueFormatter;", "<init>", "()V", "appendix", "", "(Ljava/lang/String;)V", "suffix", "", "[Ljava/lang/String;", "maxLength", "", "decimalFormat", "Ljava/text/DecimalFormat;", "text", "getFormattedValue", "value", "", "entry", "Lcom/github/mikephil/charting/data/Entry;", "dataSetIndex", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "axis", "Lcom/github/mikephil/charting/components/AxisBase;", "setAppendix", "", "setSuffix", "suffixArray", "([Ljava/lang/String;)V", "setMaxLength", "max", "makePretty", "number", "", "MPChartLib_release"})
public class LargeValueFormatter
implements IValueFormatter,
IAxisValueFormatter {
    @NotNull
    private String[] suffix;
    private int maxLength;
    @NotNull
    private final DecimalFormat decimalFormat;
    @NotNull
    private String text;

    public LargeValueFormatter() {
        String[] stringArray = new String[]{"", "k", "m", "b", "t"};
        this.suffix = stringArray;
        this.maxLength = 5;
        this.decimalFormat = new DecimalFormat("###E00");
        this.text = "";
    }

    public LargeValueFormatter(@NotNull String appendix) {
        Intrinsics.checkNotNullParameter((Object)appendix, (String)"appendix");
        this();
        this.text = appendix;
    }

    @Override
    @NotNull
    public String getFormattedValue(float value, @Nullable Entry entry, int dataSetIndex, @Nullable ViewPortHandler viewPortHandler) {
        return this.makePretty(value) + this.text;
    }

    @Override
    @NotNull
    public String getFormattedValue(float value, @Nullable AxisBase axis) {
        return this.makePretty(value) + this.text;
    }

    public final void setAppendix(@NotNull String appendix) {
        Intrinsics.checkNotNullParameter((Object)appendix, (String)"appendix");
        this.text = appendix;
    }

    public final void setSuffix(@NotNull String[] suffixArray) {
        Intrinsics.checkNotNullParameter((Object)suffixArray, (String)"suffixArray");
        this.suffix = suffixArray;
    }

    public final void setMaxLength(int max) {
        this.maxLength = max;
    }

    private final String makePretty(double number) {
        Object decimalFormat = this.decimalFormat.format(number);
        int numericValue1 = Character.getNumericValue(((String)decimalFormat).charAt(((String)decimalFormat).length() - 1));
        int numericValue2 = Character.getNumericValue(((String)decimalFormat).charAt(((String)decimalFormat).length() - 2));
        Integer combined = Integer.valueOf("" + numericValue2 + numericValue1);
        CharSequence charSequence = decimalFormat;
        Intrinsics.checkNotNull((Object)charSequence);
        charSequence = charSequence;
        Regex regex = new Regex("E[0-9][0-9]");
        String string = this.suffix[combined / 3];
        decimalFormat = regex.replace(charSequence, string);
        while (true) {
            if (((String)decimalFormat).length() <= this.maxLength) {
                charSequence = decimalFormat;
                Intrinsics.checkNotNull((Object)charSequence);
                charSequence = charSequence;
                if (!new Regex("[0-9]+\\.[a-z]").matches(charSequence)) break;
            }
            charSequence = decimalFormat;
            Intrinsics.checkNotNull((Object)charSequence);
            int n = 0;
            int n2 = ((String)decimalFormat).length() - 2;
            String string2 = ((String)charSequence).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            charSequence = decimalFormat;
            Intrinsics.checkNotNull((Object)charSequence);
            n = ((String)decimalFormat).length() - 1;
            String string3 = ((String)charSequence).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            decimalFormat = string2 + string3;
        }
        return decimalFormat;
    }
}

