/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.filter;

import android.annotation.TargetApi;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001f\u0010\t\u001a\u00020\u00052\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000b\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/github/mikephil/charting/data/filter/Approximator;", "", "<init>", "()V", "reduceWithDouglasPeucker", "", "points", "tolerance", "", "concat", "arrays", "", "([[F)[F", "Line", "MPChartLib_release"})
public final class Approximator {
    @TargetApi(value=9)
    @NotNull
    public final float[] reduceWithDouglasPeucker(@NotNull float[] points, float tolerance) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        int greatestIndex = 0;
        float greatestDistance = 0.0f;
        Line line = new Line(points[0], points[1], points[points.length - 2], points[points.length - 1]);
        for (int i = 2; i < points.length - 2; i += 2) {
            float distance = line.distance(points[i], points[i + 1]);
            if (!(distance > greatestDistance)) continue;
            greatestDistance = distance;
            greatestIndex = i;
        }
        if (greatestDistance > tolerance) {
            float[] reduced1 = this.reduceWithDouglasPeucker(ArraysKt.copyOfRange((float[])points, (int)0, (int)(greatestIndex + 2)), tolerance);
            float[] reduced2 = this.reduceWithDouglasPeucker(ArraysKt.copyOfRange((float[])points, (int)greatestIndex, (int)points.length), tolerance);
            float[] result2 = ArraysKt.copyOfRange((float[])reduced2, (int)2, (int)reduced2.length);
            float[][] fArrayArray = new float[][]{reduced1, result2};
            return this.concat(fArrayArray);
        }
        return line.getPoints();
    }

    @NotNull
    public final float[] concat(float[] ... arrays) {
        Intrinsics.checkNotNullParameter((Object)arrays, (String)"arrays");
        int length = 0;
        int n = ((Object[])arrays).length;
        for (int i = 0; i < n; ++i) {
            float[] array = arrays[i];
            length += array.length;
        }
        float[] result = new float[length];
        int pos = 0;
        int n2 = ((Object[])arrays).length;
        for (int i = 0; i < n2; ++i) {
            float[] array = arrays[i];
            int n3 = array.length;
            for (int j = 0; j < n3; ++j) {
                float element;
                result[pos] = element = array[j];
                ++pos;
            }
        }
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/mikephil/charting/data/filter/Approximator$Line;", "", "x1", "", "y1", "x2", "y2", "<init>", "(FFFF)V", "points", "", "getPoints", "()[F", "sxeY", "exsY", "dx", "dy", "length", "distance", "x", "y", "MPChartLib_release"})
    private static final class Line {
        @NotNull
        private final float[] points;
        private final float sxeY;
        private final float exsY;
        private final float dx;
        private final float dy;
        private final float length;

        public Line(float x1, float y1, float x2, float y2) {
            float[] fArray = new float[]{x1, y1, x2, y2};
            this.points = fArray;
            this.sxeY = x1 * y2;
            this.exsY = x2 * y1;
            this.dx = x1 - x2;
            this.dy = y1 - y2;
            this.length = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        }

        @NotNull
        public final float[] getPoints() {
            return this.points;
        }

        public final float distance(float x, float y) {
            return Math.abs(this.dy * x - this.dx * y + this.sxeY - this.exsY) / this.length;
        }
    }
}

