/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.utils;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.view.View;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0014\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b%\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u000fJ\u0006\u0010.\u001a\u00020/J&\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000fJ\u0006\u00101\u001a\u00020\u000fJ\u0006\u00103\u001a\u00020\u000fJ\u0006\u00102\u001a\u00020\u000fJ\u0006\u00104\u001a\u00020\u000fJ\u0006\u00105\u001a\u00020\u000fJ\u0006\u00106\u001a\u00020\u000fJ\u0006\u00107\u001a\u00020\u000fJ\u0006\u00108\u001a\u00020\u000fJ\u0006\u00109\u001a\u00020\u000fJ\u0006\u0010:\u001a\u00020\u000fJ\u0016\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ\u001e\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u0005J\u0016\u0010E\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ\u001e\u0010E\u001a\u00020+2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010F\u001a\u00020+2\u0006\u0010D\u001a\u00020\u0005J\u0016\u0010G\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fJ\u001e\u0010G\u001a\u00020+2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u0005J&\u0010G\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ.\u0010G\u001a\u00020+2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u0005J\u0016\u0010H\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fJ\u001e\u0010H\u001a\u00020+2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u0005J&\u0010H\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ\u0006\u0010O\u001a\u00020\u0005J\u000e\u0010O\u001a\u00020+2\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010P\u001a\u00020\u00052\u0006\u0010Q\u001a\u00020JJ\u0016\u0010P\u001a\u00020+2\u0006\u0010Q\u001a\u00020J2\u0006\u0010D\u001a\u00020\u0005J\u0016\u0010V\u001a\u00020+2\u0006\u0010Q\u001a\u00020J2\u0006\u0010W\u001a\u00020XJ\u001e\u0010[\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020X2\u0006\u0010^\u001a\u00020/J\u0018\u0010_\u001a\u00020+2\u0006\u0010`\u001a\u00020\u00052\b\u0010a\u001a\u0004\u0018\u00010\tJ\u000e\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u000fJ\u000e\u0010d\u001a\u00020+2\u0006\u0010c\u001a\u00020\u000fJ\u0016\u0010e\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010f\u001a\u00020+2\u0006\u0010g\u001a\u00020\u000fJ\u000e\u0010h\u001a\u00020+2\u0006\u0010g\u001a\u00020\u000fJ\u0016\u0010i\u001a\u00020+2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010j\u001a\u00020/2\u0006\u0010B\u001a\u00020\u000fJ\u000e\u0010k\u001a\u00020/2\u0006\u0010C\u001a\u00020\u000fJ\u0016\u0010l\u001a\u00020/2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020\u000fJ\u000e\u0010m\u001a\u00020/2\u0006\u0010B\u001a\u00020\u000fJ\u000e\u0010n\u001a\u00020/2\u0006\u0010B\u001a\u00020\u000fJ\u000e\u0010o\u001a\u00020/2\u0006\u0010C\u001a\u00020\u000fJ\u000e\u0010p\u001a\u00020/2\u0006\u0010C\u001a\u00020\u000fJ\u000e\u0010u\u001a\u00020+2\u0006\u0010v\u001a\u00020\u000fJ\u000e\u0010w\u001a\u00020+2\u0006\u0010v\u001a\u00020\u000fJ\u0006\u0010x\u001a\u00020/J\u0006\u0010y\u001a\u00020/J\u0006\u0010z\u001a\u00020/J\u0006\u0010{\u001a\u00020/J\u0006\u0010|\u001a\u00020/R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u001e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u001e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u001e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u001e\u0010 \u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0012R\u001e\u0010\"\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u001e\u0010$\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0012R\u001e\u0010&\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0012R\u000e\u0010(\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010;\u001a\u00020<8F\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0012R\u001a\u0010I\u001a\u00020JX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u001a\u0010R\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0007\"\u0004\bT\u0010UR\u0014\u0010Y\u001a\u00020JX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010LR\u0011\u0010q\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\bq\u0010rR\u0011\u0010s\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\bs\u0010rR\u0011\u0010t\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\bt\u0010r\u00a8\u0006}"}, d2={"Lcom/github/mikephil/charting/utils/ViewPortHandler;", "", "<init>", "()V", "matrixTouch", "Landroid/graphics/Matrix;", "getMatrixTouch", "()Landroid/graphics/Matrix;", "value", "Landroid/graphics/RectF;", "contentRect", "getContentRect", "()Landroid/graphics/RectF;", "setContentRect", "(Landroid/graphics/RectF;)V", "", "chartWidth", "getChartWidth", "()F", "setChartWidth", "(F)V", "chartHeight", "getChartHeight", "setChartHeight", "minScaleY", "getMinScaleY", "maxScaleY", "getMaxScaleY", "minScaleX", "getMinScaleX", "maxScaleX", "getMaxScaleX", "scaleX", "getScaleX", "scaleY", "getScaleY", "transX", "getTransX", "transY", "getTransY", "transOffsetX", "transOffsetY", "setChartDimens", "", "width", "height", "hasChartDimens", "", "restrainViewPort", "offsetLeft", "offsetTop", "offsetRight", "offsetBottom", "contentTop", "contentLeft", "contentRight", "contentBottom", "contentWidth", "contentHeight", "contentCenter", "Lcom/github/mikephil/charting/utils/MPPointF;", "getContentCenter", "()Lcom/github/mikephil/charting/utils/MPPointF;", "smallestContentExtension", "getSmallestContentExtension", "zoomIn", "x", "y", "outputMatrix", "zoomOut", "resetZoom", "zoom", "setZoom", "valsBufferForFitScreen", "", "getValsBufferForFitScreen", "()[F", "setValsBufferForFitScreen", "([F)V", "fitScreen", "translate", "transformedPts", "mCenterViewPortMatrixBuffer", "getMCenterViewPortMatrixBuffer", "setMCenterViewPortMatrixBuffer", "(Landroid/graphics/Matrix;)V", "centerViewPort", "view", "Landroid/view/View;", "matrixBuffer", "getMatrixBuffer", "refresh", "newMatrix", "chart", "invalidate", "limitTransAndScale", "matrix", "content", "setMinimumScaleX", "xScale", "setMaximumScaleX", "setMinMaxScaleX", "setMinimumScaleY", "yScale", "setMaximumScaleY", "setMinMaxScaleY", "isInBoundsX", "isInBoundsY", "isInBounds", "isInBoundsLeft", "isInBoundsRight", "isInBoundsTop", "isInBoundsBottom", "isFullyZoomedOut", "()Z", "isFullyZoomedOutY", "isFullyZoomedOutX", "setDragOffsetX", "offset", "setDragOffsetY", "hasNoDragOffset", "canZoomOutMoreX", "canZoomInMoreX", "canZoomOutMoreY", "canZoomInMoreY", "MPChartLib_release"})
public class ViewPortHandler {
    @NotNull
    private final Matrix matrixTouch = new Matrix();
    @NotNull
    private RectF contentRect = new RectF();
    private float chartWidth;
    private float chartHeight;
    private float minScaleY = 1.0f;
    private float maxScaleY = Float.MAX_VALUE;
    private float minScaleX = 1.0f;
    private float maxScaleX = Float.MAX_VALUE;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float transX;
    private float transY;
    private float transOffsetX;
    private float transOffsetY;
    @NotNull
    private float[] valsBufferForFitScreen = new float[9];
    @NotNull
    private Matrix mCenterViewPortMatrixBuffer = new Matrix();
    @NotNull
    private final float[] matrixBuffer = new float[9];

    @NotNull
    public final Matrix getMatrixTouch() {
        return this.matrixTouch;
    }

    @NotNull
    public final RectF getContentRect() {
        return this.contentRect;
    }

    protected final void setContentRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.contentRect = rectF;
    }

    public final float getChartWidth() {
        return this.chartWidth;
    }

    protected final void setChartWidth(float f) {
        this.chartWidth = f;
    }

    public final float getChartHeight() {
        return this.chartHeight;
    }

    protected final void setChartHeight(float f) {
        this.chartHeight = f;
    }

    public final float getMinScaleY() {
        return this.minScaleY;
    }

    public final float getMaxScaleY() {
        return this.maxScaleY;
    }

    public final float getMinScaleX() {
        return this.minScaleX;
    }

    public final float getMaxScaleX() {
        return this.maxScaleX;
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final float getTransX() {
        return this.transX;
    }

    public final float getTransY() {
        return this.transY;
    }

    public final void setChartDimens(float width, float height) {
        float offsetLeft = this.offsetLeft();
        float offsetTop = this.offsetTop();
        float offsetRight = this.offsetRight();
        float offsetBottom = this.offsetBottom();
        this.chartHeight = height;
        this.chartWidth = width;
        this.restrainViewPort(offsetLeft, offsetTop, offsetRight, offsetBottom);
    }

    public final boolean hasChartDimens() {
        return this.chartHeight > 0.0f && this.chartWidth > 0.0f;
    }

    public final void restrainViewPort(float offsetLeft, float offsetTop, float offsetRight, float offsetBottom) {
        this.contentRect.set(offsetLeft, offsetTop, this.chartWidth - offsetRight, this.chartHeight - offsetBottom);
    }

    public final float offsetLeft() {
        return this.contentRect.left;
    }

    public final float offsetRight() {
        return this.chartWidth - this.contentRect.right;
    }

    public final float offsetTop() {
        return this.contentRect.top;
    }

    public final float offsetBottom() {
        return this.chartHeight - this.contentRect.bottom;
    }

    public final float contentTop() {
        return this.contentRect.top;
    }

    public final float contentLeft() {
        return this.contentRect.left;
    }

    public final float contentRight() {
        return this.contentRect.right;
    }

    public final float contentBottom() {
        return this.contentRect.bottom;
    }

    public final float contentWidth() {
        return this.contentRect.width();
    }

    public final float contentHeight() {
        return this.contentRect.height();
    }

    @NotNull
    public final MPPointF getContentCenter() {
        MPPointF mPPointF = MPPointF.getInstance(this.contentRect.centerX(), this.contentRect.centerY());
        Intrinsics.checkNotNullExpressionValue((Object)mPPointF, (String)"getInstance(...)");
        return mPPointF;
    }

    public final float getSmallestContentExtension() {
        return (float)Math.min((double)this.contentRect.width(), (double)this.contentRect.height());
    }

    @NotNull
    public final Matrix zoomIn(float x, float y) {
        Matrix save = new Matrix();
        this.zoomIn(x, y, save);
        return save;
    }

    public final void zoomIn(float x, float y, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.postScale(1.4f, 1.4f, x, y);
    }

    @NotNull
    public final Matrix zoomOut(float x, float y) {
        Matrix save = new Matrix();
        this.zoomOut(x, y, save);
        return save;
    }

    public final void zoomOut(float x, float y, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.postScale(0.7f, 0.7f, x, y);
    }

    public final void resetZoom(@NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.postScale(1.0f, 1.0f, 0.0f, 0.0f);
    }

    @NotNull
    public final Matrix zoom(float scaleX, float scaleY) {
        Matrix save = new Matrix();
        this.zoom(scaleX, scaleY, save);
        return save;
    }

    public final void zoom(float scaleX, float scaleY, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.postScale(scaleX, scaleY);
    }

    @NotNull
    public final Matrix zoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = new Matrix();
        this.zoom(scaleX, scaleY, x, y, save);
        return save;
    }

    public final void zoom(float scaleX, float scaleY, float x, float y, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.postScale(scaleX, scaleY, x, y);
    }

    @NotNull
    public final Matrix setZoom(float scaleX, float scaleY) {
        Matrix save = new Matrix();
        this.setZoom(scaleX, scaleY, save);
        return save;
    }

    public final void setZoom(float scaleX, float scaleY, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        outputMatrix.setScale(scaleX, scaleY);
    }

    @NotNull
    public final Matrix setZoom(float scaleX, float scaleY, float x, float y) {
        Matrix save = new Matrix();
        save.set(this.matrixTouch);
        save.setScale(scaleX, scaleY, x, y);
        return save;
    }

    @NotNull
    protected final float[] getValsBufferForFitScreen() {
        return this.valsBufferForFitScreen;
    }

    protected final void setValsBufferForFitScreen(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valsBufferForFitScreen = fArray;
    }

    @NotNull
    public final Matrix fitScreen() {
        Matrix save = new Matrix();
        this.fitScreen(save);
        return save;
    }

    public final void fitScreen(@NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        this.minScaleX = 1.0f;
        this.minScaleY = 1.0f;
        outputMatrix.set(this.matrixTouch);
        float[] vals = this.valsBufferForFitScreen;
        for (int i = 0; i < 9; ++i) {
            vals[i] = 0.0f;
        }
        outputMatrix.getValues(vals);
        vals[2] = 0.0f;
        vals[5] = 0.0f;
        vals[0] = 1.0f;
        vals[4] = 1.0f;
        outputMatrix.setValues(vals);
    }

    @NotNull
    public final Matrix translate(@NotNull float[] transformedPts) {
        Intrinsics.checkNotNullParameter((Object)transformedPts, (String)"transformedPts");
        Matrix save = new Matrix();
        this.translate(transformedPts, save);
        return save;
    }

    public final void translate(@NotNull float[] transformedPts, @NotNull Matrix outputMatrix) {
        Intrinsics.checkNotNullParameter((Object)transformedPts, (String)"transformedPts");
        Intrinsics.checkNotNullParameter((Object)outputMatrix, (String)"outputMatrix");
        outputMatrix.reset();
        outputMatrix.set(this.matrixTouch);
        float x = transformedPts[0] - this.offsetLeft();
        float y = transformedPts[1] - this.offsetTop();
        outputMatrix.postTranslate(-x, -y);
    }

    @NotNull
    protected final Matrix getMCenterViewPortMatrixBuffer() {
        return this.mCenterViewPortMatrixBuffer;
    }

    protected final void setMCenterViewPortMatrixBuffer(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"<set-?>");
        this.mCenterViewPortMatrixBuffer = matrix;
    }

    public final void centerViewPort(@NotNull float[] transformedPts, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)transformedPts, (String)"transformedPts");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Matrix save = this.mCenterViewPortMatrixBuffer;
        save.reset();
        save.set(this.matrixTouch);
        float x = transformedPts[0] - this.offsetLeft();
        float y = transformedPts[1] - this.offsetTop();
        save.postTranslate(-x, -y);
        this.refresh(save, view, true);
    }

    @NotNull
    protected final float[] getMatrixBuffer() {
        return this.matrixBuffer;
    }

    @NotNull
    public final Matrix refresh(@NotNull Matrix newMatrix, @NotNull View chart, boolean invalidate) {
        Intrinsics.checkNotNullParameter((Object)newMatrix, (String)"newMatrix");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        this.matrixTouch.set(newMatrix);
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
        if (invalidate) {
            chart.invalidate();
        }
        newMatrix.set(this.matrixTouch);
        return newMatrix;
    }

    public final void limitTransAndScale(@NotNull Matrix matrix, @Nullable RectF content) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        matrix.getValues(this.matrixBuffer);
        float curTransX = this.matrixBuffer[2];
        float curScaleX = this.matrixBuffer[0];
        float curTransY = this.matrixBuffer[5];
        float curScaleY = this.matrixBuffer[4];
        this.scaleX = (float)Math.min(Math.max((double)this.minScaleX, (double)curScaleX), (double)this.maxScaleX);
        this.scaleY = (float)Math.min(Math.max((double)this.minScaleY, (double)curScaleY), (double)this.maxScaleY);
        float width = 0.0f;
        float height = 0.0f;
        if (content != null) {
            width = content.width();
            height = content.height();
        }
        float maxTransX = -width * (this.scaleX - 1.0f);
        this.transX = (float)Math.min(Math.max((double)curTransX, (double)(maxTransX - this.transOffsetX)), (double)this.transOffsetX);
        float maxTransY = height * (this.scaleY - 1.0f);
        this.transY = (float)Math.max(Math.min((double)curTransY, (double)(maxTransY + this.transOffsetY)), -((double)this.transOffsetY));
        this.matrixBuffer[2] = this.transX;
        this.matrixBuffer[0] = this.scaleX;
        this.matrixBuffer[5] = this.transY;
        this.matrixBuffer[4] = this.scaleY;
        matrix.setValues(this.matrixBuffer);
    }

    public final void setMinimumScaleX(float xScale) {
        float xScaleLocal = xScale;
        if (xScaleLocal < 1.0f) {
            xScaleLocal = 1.0f;
        }
        this.minScaleX = xScaleLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final void setMaximumScaleX(float xScale) {
        float xScaleLocal = xScale;
        if (xScaleLocal == 0.0f) {
            xScaleLocal = Float.MAX_VALUE;
        }
        this.maxScaleX = xScaleLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final void setMinMaxScaleX(float minScaleX, float maxScaleX) {
        float minScaleXLocal = minScaleX;
        float maxScaleXLocal = maxScaleX;
        if (minScaleXLocal < 1.0f) {
            minScaleXLocal = 1.0f;
        }
        if (maxScaleXLocal == 0.0f) {
            maxScaleXLocal = Float.MAX_VALUE;
        }
        this.minScaleX = minScaleXLocal;
        this.maxScaleX = maxScaleXLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final void setMinimumScaleY(float yScale) {
        float yScaleLocal = yScale;
        if (yScaleLocal < 1.0f) {
            yScaleLocal = 1.0f;
        }
        this.minScaleY = yScaleLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final void setMaximumScaleY(float yScale) {
        float yScaleLocal = yScale;
        if (yScaleLocal == 0.0f) {
            yScaleLocal = Float.MAX_VALUE;
        }
        this.maxScaleY = yScaleLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final void setMinMaxScaleY(float minScaleY, float maxScaleY) {
        float minScaleYLocal = minScaleY;
        float maxScaleYLocal = maxScaleY;
        if (minScaleYLocal < 1.0f) {
            minScaleYLocal = 1.0f;
        }
        if (maxScaleYLocal == 0.0f) {
            maxScaleYLocal = Float.MAX_VALUE;
        }
        this.minScaleY = minScaleYLocal;
        this.maxScaleY = maxScaleYLocal;
        this.limitTransAndScale(this.matrixTouch, this.contentRect);
    }

    public final boolean isInBoundsX(float x) {
        return this.isInBoundsLeft(x) && this.isInBoundsRight(x);
    }

    public final boolean isInBoundsY(float y) {
        return this.isInBoundsTop(y) && this.isInBoundsBottom(y);
    }

    public final boolean isInBounds(float x, float y) {
        return this.isInBoundsX(x) && this.isInBoundsY(y);
    }

    public final boolean isInBoundsLeft(float x) {
        return this.contentRect.left <= x + 1.0f;
    }

    public final boolean isInBoundsRight(float x) {
        float xLocal = x;
        return this.contentRect.right >= (xLocal = (float)((int)(xLocal * 100.0f)) / 100.0f) - 1.0f;
    }

    public final boolean isInBoundsTop(float y) {
        return this.contentRect.top <= y;
    }

    public final boolean isInBoundsBottom(float y) {
        float yLocal = y;
        return this.contentRect.bottom >= (yLocal = (float)((int)(yLocal * 100.0f)) / 100.0f);
    }

    public final boolean isFullyZoomedOut() {
        return this.isFullyZoomedOutX() && this.isFullyZoomedOutY();
    }

    public final boolean isFullyZoomedOutY() {
        return !(this.scaleY > this.minScaleY) && !(this.minScaleY > 1.0f);
    }

    public final boolean isFullyZoomedOutX() {
        return !(this.scaleX > this.minScaleX) && !(this.minScaleX > 1.0f);
    }

    public final void setDragOffsetX(float offset) {
        this.transOffsetX = Utils.convertDpToPixel(offset);
    }

    public final void setDragOffsetY(float offset) {
        this.transOffsetY = Utils.convertDpToPixel(offset);
    }

    public final boolean hasNoDragOffset() {
        return this.transOffsetX <= 0.0f && this.transOffsetY <= 0.0f;
    }

    public final boolean canZoomOutMoreX() {
        return this.scaleX > this.minScaleX;
    }

    public final boolean canZoomInMoreX() {
        return this.scaleX < this.maxScaleX;
    }

    public final boolean canZoomOutMoreY() {
        return this.scaleY > this.minScaleY;
    }

    public final boolean canZoomInMoreY() {
        return this.scaleY < this.maxScaleY;
    }
}

