/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016\u00a2\u0006\u0002\u0010#R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/mikephil/charting/renderer/BubbleChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarLineScatterCandleBubbleRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/BubbleDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BubbleDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "initBuffers", "", "drawData", "c", "Landroid/graphics/Canvas;", "sizeBuffer", "", "pointBuffer", "getShapeSize", "", "entrySize", "maxSize", "reference", "normalizeSize", "", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBubbleDataSet;", "drawValues", "drawExtras", "_hsvBuffer", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
public class BubbleChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    @JvmField
    @NotNull
    public BubbleDataProvider chart;
    @NotNull
    private final float[] sizeBuffer;
    @NotNull
    private final float[] pointBuffer;
    @NotNull
    private final float[] _hsvBuffer;

    public BubbleChartRenderer(@NotNull BubbleDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.sizeBuffer = new float[4];
        this.pointBuffer = new float[2];
        this._hsvBuffer = new float[3];
        this.getPaintRender().setStyle(Paint.Style.FILL);
        this.getPaintHighlight().setStyle(Paint.Style.STROKE);
        this.getPaintHighlight().setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        BubbleData bubbleData = this.chart.getBubbleData();
        for (IBubbleDataSet set : bubbleData.getDataSets()) {
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set);
        }
    }

    protected final float getShapeSize(float entrySize, float maxSize, float reference, boolean normalizeSize) {
        float factor = normalizeSize ? (maxSize == 0.0f ? 1.0f : (float)Math.sqrt(entrySize / maxSize)) : entrySize;
        float shapeSize = reference * factor;
        return shapeSize;
    }

    protected final void drawDataSet(@NotNull Canvas c, @NotNull IBubbleDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        this.xBounds.set(this.chart, dataSet);
        this.sizeBuffer[0] = 0.0f;
        this.sizeBuffer[2] = 1.0f;
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(this.sizeBuffer);
        boolean normalizeSize = dataSet.isNormalizeSizeEnabled();
        float maxBubbleWidth = (float)Math.abs((double)(this.sizeBuffer[2] - this.sizeBuffer[0]));
        float maxBubbleHeight = (float)Math.abs((double)(this.viewPortHandler.contentBottom() - this.viewPortHandler.contentTop()));
        float referenceSize = (float)Math.min((double)maxBubbleHeight, (double)maxBubbleWidth);
        int j = this.xBounds.min;
        int n = this.xBounds.range + this.xBounds.min;
        if (j <= n) {
            while (true) {
                BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j);
                this.pointBuffer[0] = entry.getX();
                this.pointBuffer[1] = entry.getY() * phaseY;
                trans.pointValuesToPixel(this.pointBuffer);
                float shapeHalf = this.getShapeSize(entry.getSize(), dataSet.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
                if (this.viewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) && this.viewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) && this.viewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) {
                    if (!this.viewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
                    int color = dataSet.getColor(j);
                    this.getPaintRender().setColor(color);
                    c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.getPaintRender());
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        BubbleData bubbleData = this.chart.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        BubbleData bubbleData2 = bubbleData;
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = bubbleData2.getDataSets();
            float lineHeight = Utils.calcTextHeight(this.getPaintValues(), "1");
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                IBubbleDataSet dataSet = (IBubbleDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                float phaseX = (float)Math.max(0.0, Math.min(1.0, (double)this.animator.getPhaseX()));
                float phaseY = this.animator.getPhaseY();
                this.xBounds.set(this.chart, dataSet);
                if (this.chart.getTransformer(dataSet.getAxisDependency()) != null) {
                    Transformer transformer;
                    boolean bl = false;
                    float[] positions = transformer.generateTransformedValuesBubble(dataSet, phaseY, this.xBounds.min, this.xBounds.max);
                    float alpha = phaseX == 1.0f ? phaseY : phaseX;
                    MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                    iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                    iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                    int j = 0;
                    while (j < positions.length) {
                        int valueTextColor = dataSet.getValueTextColor(j / 2 + this.xBounds.min);
                        valueTextColor = Color.argb((int)Math.round(255.0f * alpha), (int)Color.red((int)valueTextColor), (int)Color.green((int)valueTextColor), (int)Color.blue((int)valueTextColor));
                        float x = positions[j];
                        float y = positions[j + 1];
                        if (!this.viewPortHandler.isInBoundsRight(x)) break;
                        if (!this.viewPortHandler.isInBoundsLeft(x) || !this.viewPortHandler.isInBoundsY(y)) {
                            j += 2;
                            continue;
                        }
                        BubbleEntry entry = (BubbleEntry)dataSet.getEntryForIndex(j / 2 + this.xBounds.min);
                        if (dataSet.isDrawValuesEnabled()) {
                            IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                            Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                            this.drawValue(c, iValueFormatter, entry.getSize(), entry, i, x, y + 0.5f * lineHeight, valueTextColor);
                        }
                        if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                            Drawable icon = entry.getIcon();
                            int n2 = (int)(x + iconsOffset.x);
                            int n3 = (int)(y + iconsOffset.y);
                            Drawable drawable = icon;
                            Intrinsics.checkNotNull((Object)drawable);
                            Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                        }
                        j += 2;
                    }
                    MPPointF.recycleInstance(iconsOffset);
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        BubbleData bubbleData = this.chart.getBubbleData();
        float phaseY = this.animator.getPhaseY();
        for (Highlight high : indices) {
            BubbleEntry entry;
            IBubbleDataSet set = (IBubbleDataSet)bubbleData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !((entry = (BubbleEntry)set.getEntryForXValue(high.getX(), high.getY())).getY() == high.getY()) || !this.isInBoundsX(entry, set)) continue;
            Transformer trans = this.chart.getTransformer(set.getAxisDependency());
            this.sizeBuffer[0] = 0.0f;
            this.sizeBuffer[2] = 1.0f;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(this.sizeBuffer);
            boolean normalizeSize = set.isNormalizeSizeEnabled();
            float maxBubbleWidth = (float)Math.abs((double)(this.sizeBuffer[2] - this.sizeBuffer[0]));
            float maxBubbleHeight = (float)Math.abs((double)(this.viewPortHandler.contentBottom() - this.viewPortHandler.contentTop()));
            float referenceSize = (float)Math.min((double)maxBubbleHeight, (double)maxBubbleWidth);
            this.pointBuffer[0] = entry.getX();
            this.pointBuffer[1] = entry.getY() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            high.setDraw(this.pointBuffer[0], this.pointBuffer[1]);
            float shapeHalf = this.getShapeSize(entry.getSize(), set.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
            if (!this.viewPortHandler.isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.viewPortHandler.isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.viewPortHandler.isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.viewPortHandler.isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            int originalColor = set.getColor((int)entry.getX());
            Color.RGBToHSV((int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor), (float[])this._hsvBuffer);
            float[] fArray = this._hsvBuffer;
            fArray[2] = fArray[2] * 0.5f;
            int color = Color.HSVToColor((int)Color.alpha((int)originalColor), (float[])this._hsvBuffer);
            this.getPaintHighlight().setColor(color);
            this.getPaintHighlight().setStrokeWidth(set.getHighlightCircleWidth());
            c.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.getPaintHighlight());
        }
    }
}

