/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineScatterCandleRadarDataSet;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.scatter.ChevronDownShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.ChevronUpShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.CircleShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.CrossShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.SquareShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.TriangleShapeRenderer;
import com.github.mikephil.charting.renderer.scatter.XShapeRenderer;
import java.util.ArrayList;
import java.util.List;

public class ScatterDataSet
extends LineScatterCandleRadarDataSet<Entry>
implements IScatterDataSet {
    private float mShapeSize = 15.0f;
    protected IShapeRenderer mShapeRenderer = new SquareShapeRenderer();
    private float mScatterShapeHoleRadius = 0.0f;
    private int mScatterShapeHoleColor = 0x112233;

    public ScatterDataSet(List<Entry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<Entry> copy() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            entries.add(((Entry)this.mEntries.get(i)).copy());
        }
        ScatterDataSet copied = new ScatterDataSet((List<Entry>)entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected void copy(ScatterDataSet scatterDataSet) {
        super.copy(scatterDataSet);
        scatterDataSet.mShapeSize = this.mShapeSize;
        scatterDataSet.mShapeRenderer = this.mShapeRenderer;
        scatterDataSet.mScatterShapeHoleRadius = this.mScatterShapeHoleRadius;
        scatterDataSet.mScatterShapeHoleColor = this.mScatterShapeHoleColor;
    }

    public void setScatterShapeSize(float size) {
        this.mShapeSize = size;
    }

    @Override
    public float getScatterShapeSize() {
        return this.mShapeSize;
    }

    public void setScatterShape(ScatterChart.ScatterShape shape) {
        this.mShapeRenderer = ScatterDataSet.getRendererForShape(shape);
    }

    public void setShapeRenderer(IShapeRenderer shapeRenderer) {
        this.mShapeRenderer = shapeRenderer;
    }

    @Override
    public IShapeRenderer getShapeRenderer() {
        return this.mShapeRenderer;
    }

    public void setScatterShapeHoleRadius(float holeRadius) {
        this.mScatterShapeHoleRadius = holeRadius;
    }

    @Override
    public float getScatterShapeHoleRadius() {
        return this.mScatterShapeHoleRadius;
    }

    public void setScatterShapeHoleColor(int holeColor) {
        this.mScatterShapeHoleColor = holeColor;
    }

    @Override
    public int getScatterShapeHoleColor() {
        return this.mScatterShapeHoleColor;
    }

    public static IShapeRenderer getRendererForShape(ScatterChart.ScatterShape shape) {
        switch (shape) {
            case SQUARE: {
                return new SquareShapeRenderer();
            }
            case CIRCLE: {
                return new CircleShapeRenderer();
            }
            case TRIANGLE: {
                return new TriangleShapeRenderer();
            }
            case CROSS: {
                return new CrossShapeRenderer();
            }
            case X: {
                return new XShapeRenderer();
            }
            case CHEVRON_UP: {
                return new ChevronUpShapeRenderer();
            }
            case CHEVRON_DOWN: {
                return new ChevronDownShapeRenderer();
            }
        }
        return null;
    }
}

