/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Typeface;
import androidx.core.content.ContextCompat;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b=\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000b0JH\u0016J\b\u0010M\u001a\u00020\u000bH\u0016J\u0010\u0010M\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000bH\u0016J\u0014\u0010O\u001a\u00020H2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0012\u0010O\u001a\u00020H2\n\u0010P\u001a\u00020Q\"\u00020\u000bJ\u0016\u0010O\u001a\u00020H2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\u00020H2\u0006\u0010U\u001a\u00020\u000bJ\u000e\u0010V\u001a\u00020H2\u0006\u0010U\u001a\u00020\u000bJ\u0016\u0010V\u001a\u00020H2\u0006\u0010U\u001a\u00020\u000b2\u0006\u0010W\u001a\u00020\u000bJ\u0016\u0010O\u001a\u00020H2\u0006\u0010P\u001a\u00020Q2\u0006\u0010W\u001a\u00020\u000bJ\u0006\u0010X\u001a\u00020HJ\u0010\u0010Y\u001a\u00020H2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010Z\u001a\u00020\u0007H\u0016J\u0010\u0010[\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001bH\u0016J\b\u0010]\u001a\u00020\u001bH\u0016J\u0012\u0010^\u001a\u00020H2\b\u0010_\u001a\u0004\u0018\u00010!H\u0016J\b\u0010`\u001a\u00020!H\u0016J\b\u0010a\u001a\u00020\u001bH\u0016J\u0010\u0010b\u001a\u00020H2\u0006\u0010U\u001a\u00020\u000bH\u0016J\u0016\u0010c\u001a\u00020H2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0012\u0010d\u001a\u00020H2\b\u0010e\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010f\u001a\u00020H2\u0006\u0010g\u001a\u00020/H\u0016J\b\u0010h\u001a\u00020\u000bH\u0016J\u0010\u0010h\u001a\u00020\u000b2\u0006\u0010N\u001a\u00020\u000bH\u0016J\n\u0010i\u001a\u0004\u0018\u00010'H\u0016J\b\u0010j\u001a\u00020/H\u0016J\u000e\u0010k\u001a\u00020H2\u0006\u0010l\u001a\u00020-J\b\u0010m\u001a\u00020-H\u0016J\u000e\u0010n\u001a\u00020H2\u0006\u0010o\u001a\u00020/J\b\u0010p\u001a\u00020/H\u0016J\u000e\u0010q\u001a\u00020H2\u0006\u0010r\u001a\u00020/J\b\u0010s\u001a\u00020/H\u0016J\u0010\u0010t\u001a\u00020H2\b\u0010u\u001a\u0004\u0018\u000102J\n\u0010v\u001a\u0004\u0018\u000102H\u0016J\u0010\u0010w\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001bH\u0016J\b\u0010x\u001a\u00020\u001bH\u0016J\u0010\u0010y\u001a\u00020H2\u0006\u0010\\\u001a\u00020\u001bH\u0016J\b\u0010z\u001a\u00020\u001bH\u0016J\u0010\u0010{\u001a\u00020H2\u0006\u0010|\u001a\u00020:H\u0016J\b\u0010}\u001a\u00020:H\u0016J\u0010\u0010~\u001a\u00020H2\u0006\u0010\u007f\u001a\u00020\u001bH\u0016J\t\u0010\u0080\u0001\u001a\u00020\u001bH\u0016J\t\u0010\u0081\u0001\u001a\u00020\u0015H\u0016J\u0012\u0010\u0082\u0001\u001a\u00020H2\u0007\u0010\u0083\u0001\u001a\u00020\u0015H\u0016J\u0012\u0010\u0084\u0001\u001a\u00020\u000b2\u0007\u0010\u0085\u0001\u001a\u00020\u000bH\u0016J\t\u0010\u0086\u0001\u001a\u00020\u001bH\u0016J\t\u0010\u0087\u0001\u001a\u00020\u001bH\u0016J\u0012\u0010\u0088\u0001\u001a\u00020\u001b2\u0007\u0010\u0089\u0001\u001a\u00020/H\u0016J\u0011\u0010\u008a\u0001\u001a\u00020\u001b2\u0006\u0010N\u001a\u00020\u000bH\u0016J\u0019\u0010\u008b\u0001\u001a\u00020\u001b2\u0007\u0010\u008c\u0001\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0003\u0010\u008d\u0001J\u0016\u0010\u008e\u0001\u001a\u00020H2\u000b\u0010\u008f\u0001\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0004R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00103\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001d\"\u0004\b5\u0010\u001fR\u001a\u00106\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001d\"\u0004\b8\u0010\u001fR\u001a\u00109\u001a\u00020:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020/X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u001d\"\u0004\bF\u0010\u001fR\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000b0J8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\r\u00a8\u0006\u0090\u0001"}, d2={"Lcom/github/mikephil/charting/data/BaseDataSet;", "T", "Lcom/github/mikephil/charting/data/Entry;", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "<init>", "()V", "label", "", "(Ljava/lang/String;)V", "mColors", "", "", "getMColors", "()Ljava/util/List;", "setMColors", "(Ljava/util/List;)V", "mValueColors", "getMValueColors", "setMValueColors", "mLabel", "mAxisDependency", "Lcom/github/mikephil/charting/components/YAxis$AxisDependency;", "getMAxisDependency", "()Lcom/github/mikephil/charting/components/YAxis$AxisDependency;", "setMAxisDependency", "(Lcom/github/mikephil/charting/components/YAxis$AxisDependency;)V", "mHighlightEnabled", "", "getMHighlightEnabled", "()Z", "setMHighlightEnabled", "(Z)V", "mValueFormatter", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "getMValueFormatter", "()Lcom/github/mikephil/charting/formatter/IValueFormatter;", "setMValueFormatter", "(Lcom/github/mikephil/charting/formatter/IValueFormatter;)V", "mValueTypeface", "Landroid/graphics/Typeface;", "getMValueTypeface", "()Landroid/graphics/Typeface;", "setMValueTypeface", "(Landroid/graphics/Typeface;)V", "mForm", "Lcom/github/mikephil/charting/components/Legend$LegendForm;", "mFormSize", "", "mFormLineWidth", "mFormLineDashEffect", "Landroid/graphics/DashPathEffect;", "mDrawValues", "getMDrawValues", "setMDrawValues", "mDrawIcons", "getMDrawIcons", "setMDrawIcons", "mIconsOffset", "Lcom/github/mikephil/charting/utils/MPPointF;", "getMIconsOffset", "()Lcom/github/mikephil/charting/utils/MPPointF;", "setMIconsOffset", "(Lcom/github/mikephil/charting/utils/MPPointF;)V", "mValueTextSize", "getMValueTextSize", "()F", "setMValueTextSize", "(F)V", "mVisible", "getMVisible", "setMVisible", "notifyDataSetChanged", "", "getColors", "", "valueColors", "getValueColors", "getColor", "index", "setColors", "colors", "", "context", "Landroid/content/Context;", "addColor", "color", "setColor", "alpha", "resetColors", "setLabel", "getLabel", "setHighlightEnabled", "enabled", "isHighlightEnabled", "setValueFormatter", "f", "getValueFormatter", "needsFormatter", "setValueTextColor", "setValueTextColors", "setValueTypeface", "tf", "setValueTextSize", "size", "getValueTextColor", "getValueTypeface", "getValueTextSize", "setForm", "form", "getForm", "setFormSize", "formSize", "getFormSize", "setFormLineWidth", "formLineWidth", "getFormLineWidth", "setFormLineDashEffect", "dashPathEffect", "getFormLineDashEffect", "setDrawValues", "isDrawValuesEnabled", "setDrawIcons", "isDrawIconsEnabled", "setIconsOffset", "offsetDp", "getIconsOffset", "setVisible", "visible", "isVisible", "getAxisDependency", "setAxisDependency", "dependency", "getIndexInEntries", "xIndex", "removeFirst", "removeLast", "removeEntryByXValue", "xValue", "removeEntry", "contains", "e", "(Lcom/github/mikephil/charting/data/Entry;)Z", "copy", "baseDataSet", "MPChartLib_release"})
public abstract class BaseDataSet<T extends Entry>
implements IDataSet<T> {
    @NotNull
    private List<Integer> mColors;
    @NotNull
    private List<Integer> mValueColors;
    @NotNull
    private String mLabel;
    @NotNull
    private YAxis.AxisDependency mAxisDependency;
    private boolean mHighlightEnabled;
    @Nullable
    private transient IValueFormatter mValueFormatter;
    @Nullable
    private Typeface mValueTypeface;
    @NotNull
    private Legend.LegendForm mForm;
    private float mFormSize;
    private float mFormLineWidth;
    @Nullable
    private DashPathEffect mFormLineDashEffect;
    private boolean mDrawValues;
    private boolean mDrawIcons;
    @NotNull
    private MPPointF mIconsOffset;
    private float mValueTextSize;
    private boolean mVisible;

    public BaseDataSet() {
        this.mLabel = "DataSet";
        this.mAxisDependency = YAxis.AxisDependency.LEFT;
        this.mHighlightEnabled = true;
        this.mForm = Legend.LegendForm.DEFAULT;
        this.mFormSize = Float.NaN;
        this.mFormLineWidth = Float.NaN;
        this.mDrawValues = true;
        this.mDrawIcons = true;
        this.mIconsOffset = new MPPointF();
        this.mValueTextSize = 17.0f;
        this.mVisible = true;
        this.mColors = new ArrayList();
        this.mValueColors = new ArrayList();
        this.mColors.add(Color.rgb((int)140, (int)234, (int)255));
        this.mValueColors.add(-16777216);
    }

    @NotNull
    protected final List<Integer> getMColors() {
        return this.mColors;
    }

    protected final void setMColors(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mColors = list;
    }

    @NotNull
    protected final List<Integer> getMValueColors() {
        return this.mValueColors;
    }

    protected final void setMValueColors(@NotNull List<Integer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.mValueColors = list;
    }

    @NotNull
    protected final YAxis.AxisDependency getMAxisDependency() {
        return this.mAxisDependency;
    }

    protected final void setMAxisDependency(@NotNull YAxis.AxisDependency axisDependency) {
        Intrinsics.checkNotNullParameter((Object)((Object)axisDependency), (String)"<set-?>");
        this.mAxisDependency = axisDependency;
    }

    protected final boolean getMHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    protected final void setMHighlightEnabled(boolean bl) {
        this.mHighlightEnabled = bl;
    }

    @Nullable
    protected final IValueFormatter getMValueFormatter() {
        return this.mValueFormatter;
    }

    protected final void setMValueFormatter(@Nullable IValueFormatter iValueFormatter) {
        this.mValueFormatter = iValueFormatter;
    }

    @Nullable
    protected final Typeface getMValueTypeface() {
        return this.mValueTypeface;
    }

    protected final void setMValueTypeface(@Nullable Typeface typeface) {
        this.mValueTypeface = typeface;
    }

    protected final boolean getMDrawValues() {
        return this.mDrawValues;
    }

    protected final void setMDrawValues(boolean bl) {
        this.mDrawValues = bl;
    }

    protected final boolean getMDrawIcons() {
        return this.mDrawIcons;
    }

    protected final void setMDrawIcons(boolean bl) {
        this.mDrawIcons = bl;
    }

    @NotNull
    protected final MPPointF getMIconsOffset() {
        return this.mIconsOffset;
    }

    protected final void setMIconsOffset(@NotNull MPPointF mPPointF) {
        Intrinsics.checkNotNullParameter((Object)mPPointF, (String)"<set-?>");
        this.mIconsOffset = mPPointF;
    }

    protected final float getMValueTextSize() {
        return this.mValueTextSize;
    }

    protected final void setMValueTextSize(float f) {
        this.mValueTextSize = f;
    }

    protected final boolean getMVisible() {
        return this.mVisible;
    }

    protected final void setMVisible(boolean bl) {
        this.mVisible = bl;
    }

    public BaseDataSet(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this();
        this.mLabel = label;
    }

    public final void notifyDataSetChanged() {
        this.calcMinMax();
    }

    @Override
    @NotNull
    public List<Integer> getColors() {
        return this.mColors;
    }

    @NotNull
    public final List<Integer> getValueColors() {
        return this.mValueColors;
    }

    @Override
    public int getColor() {
        return ((Number)this.mColors.get(0)).intValue();
    }

    @Override
    public int getColor(int index) {
        return ((Number)this.mColors.get(index % this.mColors.size())).intValue();
    }

    public final void setColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.mColors = colors;
    }

    public final void setColors(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        List<Integer> list = ColorTemplate.createColors(colors);
        Intrinsics.checkNotNullExpressionValue(list, (String)"createColors(...)");
        this.mColors = list;
    }

    public final void setColors(@NotNull int[] colors, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mColors.clear();
        for (int color : colors) {
            this.mColors.add(ContextCompat.getColor((Context)context, (int)color));
        }
    }

    public final void addColor(int color) {
        this.mColors.add(color);
    }

    public final void setColor(int color) {
        this.resetColors();
        this.mColors.add(color);
    }

    public final void setColor(int color, int alpha) {
        this.setColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
    }

    public final void setColors(@NotNull int[] colors, int alpha) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.resetColors();
        for (int color : colors) {
            this.addColor(Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)));
        }
    }

    public final void resetColors() {
        this.mColors.clear();
    }

    @Override
    public void setLabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.mLabel = label;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public void setHighlightEnabled(boolean enabled) {
        this.mHighlightEnabled = enabled;
    }

    @Override
    public boolean isHighlightEnabled() {
        return this.mHighlightEnabled;
    }

    @Override
    public void setValueFormatter(@Nullable IValueFormatter f) {
        if (f == null) {
            return;
        }
        this.mValueFormatter = f;
    }

    @Override
    @NotNull
    public IValueFormatter getValueFormatter() {
        if (this.needsFormatter()) {
            IValueFormatter iValueFormatter = Utils.getDefaultValueFormatter();
            Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getDefaultValueFormatter(...)");
            return iValueFormatter;
        }
        IValueFormatter iValueFormatter = this.mValueFormatter;
        Intrinsics.checkNotNull((Object)iValueFormatter);
        return iValueFormatter;
    }

    @Override
    public boolean needsFormatter() {
        return this.mValueFormatter == null;
    }

    @Override
    public void setValueTextColor(int color) {
        this.mValueColors.clear();
        this.mValueColors.add(color);
    }

    @Override
    public void setValueTextColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.mValueColors = colors;
    }

    @Override
    public void setValueTypeface(@Nullable Typeface tf) {
        this.mValueTypeface = tf;
    }

    @Override
    public void setValueTextSize(float size) {
        this.mValueTextSize = Utils.convertDpToPixel(size);
    }

    @Override
    public int getValueTextColor() {
        return ((Number)this.mValueColors.get(0)).intValue();
    }

    @Override
    public int getValueTextColor(int index) {
        return ((Number)this.mValueColors.get(index % this.mValueColors.size())).intValue();
    }

    @Override
    @Nullable
    public Typeface getValueTypeface() {
        return this.mValueTypeface;
    }

    @Override
    public float getValueTextSize() {
        return this.mValueTextSize;
    }

    public final void setForm(@NotNull Legend.LegendForm form) {
        Intrinsics.checkNotNullParameter((Object)((Object)form), (String)"form");
        this.mForm = form;
    }

    @Override
    @NotNull
    public Legend.LegendForm getForm() {
        return this.mForm;
    }

    public final void setFormSize(float formSize) {
        this.mFormSize = formSize;
    }

    @Override
    public float getFormSize() {
        return this.mFormSize;
    }

    public final void setFormLineWidth(float formLineWidth) {
        this.mFormLineWidth = formLineWidth;
    }

    @Override
    public float getFormLineWidth() {
        return this.mFormLineWidth;
    }

    public final void setFormLineDashEffect(@Nullable DashPathEffect dashPathEffect) {
        this.mFormLineDashEffect = dashPathEffect;
    }

    @Override
    @Nullable
    public DashPathEffect getFormLineDashEffect() {
        return this.mFormLineDashEffect;
    }

    @Override
    public void setDrawValues(boolean enabled) {
        this.mDrawValues = enabled;
    }

    @Override
    public boolean isDrawValuesEnabled() {
        return this.mDrawValues;
    }

    @Override
    public void setDrawIcons(boolean enabled) {
        this.mDrawIcons = enabled;
    }

    @Override
    public boolean isDrawIconsEnabled() {
        return this.mDrawIcons;
    }

    @Override
    public void setIconsOffset(@NotNull MPPointF offsetDp) {
        Intrinsics.checkNotNullParameter((Object)offsetDp, (String)"offsetDp");
        this.mIconsOffset.x = offsetDp.x;
        this.mIconsOffset.y = offsetDp.y;
    }

    @Override
    @NotNull
    public MPPointF getIconsOffset() {
        return this.mIconsOffset;
    }

    @Override
    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.mVisible;
    }

    @Override
    @NotNull
    public YAxis.AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    @Override
    public void setAxisDependency(@NotNull YAxis.AxisDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)((Object)dependency), (String)"dependency");
        this.mAxisDependency = dependency;
    }

    @Override
    public int getIndexInEntries(int xIndex) {
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            float f = xIndex;
            Object t = this.getEntryForIndex(i);
            Intrinsics.checkNotNull(t);
            if (!(f == ((Entry)t).getX())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean removeFirst() {
        if (this.getEntryCount() > 0) {
            Object entry = this.getEntryForIndex(0);
            return this.removeEntry(entry);
        }
        return false;
    }

    @Override
    public boolean removeLast() {
        if (this.getEntryCount() > 0) {
            Object e = this.getEntryForIndex(this.getEntryCount() - 1);
            return this.removeEntry(e);
        }
        return false;
    }

    @Override
    public boolean removeEntryByXValue(float xValue) {
        Object e = this.getEntryForXValue(xValue, Float.NaN);
        return this.removeEntry(e);
    }

    @Override
    public boolean removeEntry(int index) {
        Object e = this.getEntryForIndex(index);
        return this.removeEntry(e);
    }

    @Override
    public boolean contains(T e) {
        int n = this.getEntryCount();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual(this.getEntryForIndex(i), e)) continue;
            return true;
        }
        return false;
    }

    protected final void copy(@NotNull BaseDataSet<?> baseDataSet) {
        Intrinsics.checkNotNullParameter(baseDataSet, (String)"baseDataSet");
        baseDataSet.mAxisDependency = this.mAxisDependency;
        baseDataSet.mColors = this.mColors;
        baseDataSet.mDrawIcons = this.mDrawIcons;
        baseDataSet.mDrawValues = this.mDrawValues;
        baseDataSet.mForm = this.mForm;
        baseDataSet.mFormLineDashEffect = this.mFormLineDashEffect;
        baseDataSet.mFormLineWidth = this.mFormLineWidth;
        baseDataSet.mFormSize = this.mFormSize;
        baseDataSet.mHighlightEnabled = this.mHighlightEnabled;
        baseDataSet.mIconsOffset = this.mIconsOffset;
        baseDataSet.mValueColors = this.mValueColors;
        baseDataSet.mValueFormatter = this.mValueFormatter;
        baseDataSet.mValueTextSize = this.mValueTextSize;
        baseDataSet.mVisible = this.mVisible;
    }
}

