/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.content.Context;
import android.graphics.Canvas;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.components.IMarker;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.utils.MPPointF;
import java.lang.ref.WeakReference;

public class MarkerView
extends RelativeLayout
implements IMarker {
    private MPPointF mOffset = new MPPointF();
    private MPPointF mOffset2 = new MPPointF();
    private WeakReference<Chart> mWeakChart;

    public MarkerView(Context context, int layoutResource) {
        super(context);
        this.setupLayoutResource(layoutResource);
    }

    private void setupLayoutResource(int layoutResource) {
        View inflated = LayoutInflater.from((Context)this.getContext()).inflate(layoutResource, (ViewGroup)this);
        inflated.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        inflated.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        inflated.layout(0, 0, inflated.getMeasuredWidth(), inflated.getMeasuredHeight());
    }

    public void setOffset(MPPointF offset) {
        this.mOffset = offset;
        if (this.mOffset == null) {
            this.mOffset = new MPPointF();
        }
    }

    public void setOffset(float offsetX, float offsetY) {
        this.mOffset.x = offsetX;
        this.mOffset.y = offsetY;
    }

    @Override
    public MPPointF getOffset() {
        return this.mOffset;
    }

    public void setChartView(Chart chart) {
        this.mWeakChart = new WeakReference<Chart>(chart);
    }

    public Chart getChartView() {
        return this.mWeakChart == null ? null : (Chart)this.mWeakChart.get();
    }

    @Override
    public MPPointF getOffsetForDrawingAtPoint(float posX, float posY) {
        MPPointF offset = this.getOffset();
        this.mOffset2.x = offset.x;
        this.mOffset2.y = offset.y;
        Chart chart = this.getChartView();
        float width = this.getWidth();
        float height = this.getHeight();
        if (posX + this.mOffset2.x < 0.0f) {
            this.mOffset2.x = -posX;
        } else if (chart != null && posX + width + this.mOffset2.x > (float)chart.getWidth()) {
            this.mOffset2.x = (float)chart.getWidth() - posX - width;
        }
        if (posY + this.mOffset2.y < 0.0f) {
            this.mOffset2.y = -posY;
        } else if (chart != null && posY + height + this.mOffset2.y > (float)chart.getHeight()) {
            this.mOffset2.y = (float)chart.getHeight() - posY - height;
        }
        return this.mOffset2;
    }

    @Override
    public void refreshContent(Entry e, Highlight highlight) {
        this.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        this.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    @Override
    public void draw(Canvas canvas, float posX, float posY) {
        MPPointF offset = this.getOffsetForDrawingAtPoint(posX, posY);
        int saveId = canvas.save();
        canvas.translate(posX + offset.x, posY + offset.y);
        this.draw(canvas);
        canvas.restoreToCount(saveId);
    }
}

