/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.utils.Utils;

public class LimitRange
extends ComponentBase {
    private Range mLimit;
    private float mLineWidth = 0.0f;
    private int mLineColor = Color.rgb((int)237, (int)91, (int)91);
    private int mRangeColor = Color.rgb((int)128, (int)128, (int)128);
    private Paint.Style mTextStyle = Paint.Style.FILL;
    private String mLabel = "";
    private DashPathEffect mDashPathEffect = null;
    private LimitLine.LimitLabelPosition mLabelPosition = LimitLine.LimitLabelPosition.RIGHT_TOP;

    public LimitRange(float firstLimit, float secondLimit) {
        this.mLimit = new Range(firstLimit, secondLimit);
    }

    public LimitRange(float firstLimit, float secondLimit, String label) {
        this.mLimit = new Range(firstLimit, secondLimit);
        this.mLabel = label;
    }

    public Range getLimit() {
        return this.mLimit;
    }

    public void setLineWidth(float width) {
        if (width > 12.0f) {
            width = 12.0f;
        }
        this.mLineWidth = Utils.convertDpToPixel(width);
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineColor(int color) {
        this.mLineColor = color;
    }

    public void setRangeColor(int color) {
        this.mRangeColor = color;
    }

    public int getLineColor() {
        return this.mLineColor;
    }

    public int getRangeColor() {
        return this.mRangeColor;
    }

    public void enableDashedLine(float lineLength, float spaceLength, float phase) {
        this.mDashPathEffect = new DashPathEffect(new float[]{lineLength, spaceLength}, phase);
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    public boolean isDashedLineEnabled() {
        return this.mDashPathEffect != null;
    }

    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    public void setTextStyle(Paint.Style style) {
        this.mTextStyle = style;
    }

    public Paint.Style getTextStyle() {
        return this.mTextStyle;
    }

    public void setLabelPosition(LimitLine.LimitLabelPosition pos) {
        this.mLabelPosition = pos;
    }

    public LimitLine.LimitLabelPosition getLabelPosition() {
        return this.mLabelPosition;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static class Range {
        private final float mLow;
        private final float mHigh;

        Range(float r1, float r2) {
            if (r1 < r2) {
                this.mLow = r1;
                this.mHigh = r2;
            } else {
                this.mLow = r2;
                this.mHigh = r1;
            }
        }

        public float getLow() {
            return this.mLow;
        }

        public float getHigh() {
            return this.mHigh;
        }
    }
}

