/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.AbstractBuffer;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0007J(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0004J\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\n\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0012\u0010\u0006\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00138\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/github/mikephil/charting/buffer/BarBuffer;", "Lcom/github/mikephil/charting/buffer/AbstractBuffer;", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "size", "", "dataSetCount", "containsStacks", "", "<init>", "(IIZ)V", "dataSetIndex", "getDataSetIndex", "()I", "setDataSetIndex", "(I)V", "getDataSetCount", "setDataSetCount", "inverted", "barWidth", "", "setBarWidth", "", "barWidthGiven", "setDataSet", "index", "setInverted", "invertedGiven", "addBar", "left", "top", "right", "bottom", "toString", "", "feed", "data", "MPChartLib_release"})
public class BarBuffer
extends AbstractBuffer<IBarDataSet> {
    private int dataSetIndex;
    private int dataSetCount = 1;
    @JvmField
    protected boolean containsStacks;
    @JvmField
    protected boolean inverted;
    @JvmField
    protected float barWidth = 1.0f;

    public BarBuffer(int size, int dataSetCount, boolean containsStacks) {
        super(size);
        this.dataSetCount = dataSetCount;
        this.containsStacks = containsStacks;
    }

    protected final int getDataSetIndex() {
        return this.dataSetIndex;
    }

    protected final void setDataSetIndex(int n) {
        this.dataSetIndex = n;
    }

    protected final int getDataSetCount() {
        return this.dataSetCount;
    }

    protected final void setDataSetCount(int n) {
        this.dataSetCount = n;
    }

    public final void setBarWidth(float barWidthGiven) {
        this.barWidth = barWidthGiven;
    }

    public final void setDataSet(int index) {
        this.dataSetIndex = index;
    }

    public final void setInverted(boolean invertedGiven) {
        this.inverted = invertedGiven;
    }

    protected final void addBar(float left, float top, float right, float bottom) {
        int n = this.index;
        this.index = n + 1;
        this.buffer[n] = left;
        n = this.index;
        this.index = n + 1;
        this.buffer[n] = top;
        n = this.index;
        this.index = n + 1;
        this.buffer[n] = right;
        n = this.index;
        this.index = n + 1;
        this.buffer[n] = bottom;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.buffer);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "BarBuffer{dataSetIndex=" + this.dataSetIndex + ", dataSetCount=" + this.dataSetCount + ", containsStacks=" + this.containsStacks + ", inverted=" + this.inverted + ", barWidth=" + this.barWidth + ", buffer=" + string + ", index=" + this.index + "}";
    }

    @Override
    public void feed(@Nullable IBarDataSet data) {
        IBarDataSet iBarDataSet = data;
        float size = (float)(iBarDataSet != null ? iBarDataSet.getEntryCount() : 0) * this.phaseX;
        float barWidthHalf = this.barWidth / 2.0f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e;
            IBarDataSet iBarDataSet2 = data;
            BarEntry barEntry = e = iBarDataSet2 != null ? (BarEntry)iBarDataSet2.getEntryForIndex(i) : null;
            if (e == null) {
                ++i;
                continue;
            }
            float x = e.getX();
            float y = e.getY();
            float[] vals = e.getYVals();
            if (!this.containsStacks || vals == null) {
                float left = x - barWidthHalf;
                float right = x + barWidthHalf;
                float bottom = 0.0f;
                float top = 0.0f;
                if (this.inverted) {
                    bottom = y >= 0.0f ? y : 0.0f;
                    top = y <= 0.0f ? y : 0.0f;
                } else {
                    top = y >= 0.0f ? y : 0.0f;
                    float f = bottom = y <= 0.0f ? y : 0.0f;
                }
                if (top > 0.0f) {
                    top *= this.phaseY;
                } else {
                    bottom *= this.phaseY;
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = -e.getNegativeSum();
                float yStart = 0.0f;
                for (float value : vals) {
                    if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                        yStart = y = value;
                    } else if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        yStart = (float)((double)negY + Math.abs((double)value));
                        negY += (float)Math.abs((double)value);
                    }
                    float left = x - barWidthHalf;
                    float right = x + barWidthHalf;
                    float bottom = 0.0f;
                    float top = 0.0f;
                    if (this.inverted) {
                        bottom = y >= yStart ? y : yStart;
                        top = y <= yStart ? y : yStart;
                    } else {
                        top = y >= yStart ? y : yStart;
                        bottom = y <= yStart ? y : yStart;
                    }
                    this.addBar(left, top *= this.phaseY, right, bottom *= this.phaseY);
                }
            }
            ++i;
        }
        this.reset();
    }
}

