/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.XAxisRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/mikephil/charting/renderer/XAxisRendererRadarChart;", "Lcom/github/mikephil/charting/renderer/XAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "xAxis", "Lcom/github/mikephil/charting/components/XAxis;", "chart", "Lcom/github/mikephil/charting/charts/RadarChart;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/XAxis;Lcom/github/mikephil/charting/charts/RadarChart;)V", "renderAxisLabels", "", "c", "Landroid/graphics/Canvas;", "renderLimitLines", "MPChartLib_release"})
public final class XAxisRendererRadarChart
extends XAxisRenderer {
    @NotNull
    private final RadarChart chart;

    public XAxisRendererRadarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull XAxis xAxis, @NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)xAxis, (String)"xAxis");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(viewPortHandler, xAxis, null);
        this.chart = chart;
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!this.xAxis.isEnabled() || !this.xAxis.isDrawLabelsEnabled()) {
            return;
        }
        float labelRotationAngleDegrees = this.xAxis.getLabelRotationAngle();
        MPPointF drawLabelAnchor = MPPointF.getInstance(0.5f, 0.25f);
        Paint paint = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint);
        paint.setTypeface(this.xAxis.getTypeface());
        Paint paint2 = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint2);
        paint2.setTextSize(this.xAxis.getTextSize());
        Paint paint3 = this.getPaintAxisLabels();
        Intrinsics.checkNotNull((Object)paint3);
        paint3.setColor(this.xAxis.getTextColor());
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.getInstance(0.0f, 0.0f);
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        int n = ((IRadarDataSet)((RadarData)t).getMaxEntryCountSet()).getEntryCount();
        for (int i = 0; i < n; ++i) {
            String label = this.xAxis.getValueFormatter().getFormattedValue(i, this.xAxis);
            float angle = (sliceAngle * (float)i + this.chart.getRotationAngle()) % 360.0f;
            Utils.getPosition(center, this.chart.getYRange() * factor + (float)this.xAxis.mLabelWidth / 2.0f, angle, pOut);
            this.drawLabel(c, label, pOut.x, pOut.y - (float)this.xAxis.mLabelHeight / 2.0f, drawLabelAnchor, labelRotationAngleDegrees);
        }
        MPPointF.recycleInstance(center);
        MPPointF.recycleInstance(pOut);
        MPPointF.recycleInstance(drawLabelAnchor);
    }

    @Override
    public void renderLimitLines(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }
}

