/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/mikephil/charting/renderer/CandleStickChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineScatterCandleRadarRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/CandleDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/CandleDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "shadowBuffers", "", "bodyBuffers", "rangeBuffers", "openBuffers", "closeBuffers", "initBuffers", "", "drawData", "c", "Landroid/graphics/Canvas;", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/ICandleDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    @JvmField
    @NotNull
    public CandleDataProvider chart;
    @NotNull
    private final float[] shadowBuffers;
    @NotNull
    private final float[] bodyBuffers;
    @NotNull
    private final float[] rangeBuffers;
    @NotNull
    private final float[] openBuffers;
    @NotNull
    private final float[] closeBuffers;

    public CandleStickChartRenderer(@NotNull CandleDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.shadowBuffers = new float[8];
        this.bodyBuffers = new float[4];
        this.rangeBuffers = new float[4];
        this.openBuffers = new float[4];
        this.closeBuffers = new float[4];
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        CandleData candleData = this.chart.getCandleData();
        for (ICandleDataSet set : candleData.getDataSets()) {
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set);
        }
    }

    protected final void drawDataSet(@NotNull Canvas c, @NotNull ICandleDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        float barSpace = dataSet.getBarSpace();
        boolean showCandleBar = dataSet.getShowCandleBar();
        this.xBounds.set(this.chart, dataSet);
        this.getPaintRender().setStrokeWidth(dataSet.getShadowWidth());
        int j = this.xBounds.min;
        int n = this.xBounds.range + this.xBounds.min;
        if (j <= n) {
            while (true) {
                if ((CandleEntry)dataSet.getEntryForIndex(j) != null) {
                    CandleEntry e;
                    float xPos = e.getX();
                    float open = e.getOpen();
                    float close = e.getClose();
                    float high = e.getHigh();
                    float low = e.getLow();
                    if (showCandleBar) {
                        this.shadowBuffers[0] = xPos;
                        this.shadowBuffers[2] = xPos;
                        this.shadowBuffers[4] = xPos;
                        this.shadowBuffers[6] = xPos;
                        if (open > close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = close * phaseY;
                        } else if (open < close) {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = close * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = open * phaseY;
                        } else {
                            this.shadowBuffers[1] = high * phaseY;
                            this.shadowBuffers[3] = open * phaseY;
                            this.shadowBuffers[5] = low * phaseY;
                            this.shadowBuffers[7] = this.shadowBuffers[3];
                        }
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.shadowBuffers);
                        if (dataSet.getShadowColorSameAsCandle()) {
                            if (open > close) {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getDecreasingColor());
                            } else if (open < close) {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getIncreasingColor());
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getNeutralColor());
                            }
                        } else {
                            this.getPaintRender().setColor(dataSet.getShadowColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getShadowColor());
                        }
                        this.getPaintRender().setStyle(Paint.Style.STROKE);
                        c.drawLines(this.shadowBuffers, this.getPaintRender());
                        this.bodyBuffers[0] = xPos - 0.5f + barSpace;
                        this.bodyBuffers[1] = close * phaseY;
                        this.bodyBuffers[2] = xPos + 0.5f - barSpace;
                        this.bodyBuffers[3] = open * phaseY;
                        trans.pointValuesToPixel(this.bodyBuffers);
                        if (open > close) {
                            if (dataSet.getDecreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColor(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getDecreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getDecreasingPaintStyle());
                            c.drawRect(this.bodyBuffers[0], this.bodyBuffers[3], this.bodyBuffers[2], this.bodyBuffers[1], this.getPaintRender());
                        } else if (open < close) {
                            if (dataSet.getIncreasingColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColor(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getIncreasingColor());
                            }
                            this.getPaintRender().setStyle(dataSet.getIncreasingPaintStyle());
                            c.drawRect(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        } else {
                            if (dataSet.getNeutralColor() == 0x112233) {
                                this.getPaintRender().setColor(dataSet.getColor(j));
                            } else {
                                this.getPaintRender().setColor(dataSet.getNeutralColor());
                            }
                            c.drawLine(this.bodyBuffers[0], this.bodyBuffers[1], this.bodyBuffers[2], this.bodyBuffers[3], this.getPaintRender());
                        }
                    } else {
                        this.rangeBuffers[0] = xPos;
                        this.rangeBuffers[1] = high * phaseY;
                        this.rangeBuffers[2] = xPos;
                        this.rangeBuffers[3] = low * phaseY;
                        this.openBuffers[0] = xPos - 0.5f + barSpace;
                        this.openBuffers[1] = open * phaseY;
                        this.openBuffers[2] = xPos;
                        this.openBuffers[3] = open * phaseY;
                        this.closeBuffers[0] = xPos + 0.5f - barSpace;
                        this.closeBuffers[1] = close * phaseY;
                        this.closeBuffers[2] = xPos;
                        this.closeBuffers[3] = close * phaseY;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.pointValuesToPixel(this.rangeBuffers);
                        trans.pointValuesToPixel(this.openBuffers);
                        trans.pointValuesToPixel(this.closeBuffers);
                        int barColor = open > close ? (dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getDecreasingColor()) : (open < close ? (dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getIncreasingColor()) : (dataSet.getNeutralColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getNeutralColor()));
                        this.getPaintRender().setColor(barColor);
                        c.drawLine(this.rangeBuffers[0], this.rangeBuffers[1], this.rangeBuffers[2], this.rangeBuffers[3], this.getPaintRender());
                        c.drawLine(this.openBuffers[0], this.openBuffers[1], this.openBuffers[2], this.openBuffers[3], this.getPaintRender());
                        c.drawLine(this.closeBuffers[0], this.closeBuffers[1], this.closeBuffers[2], this.closeBuffers[3], this.getPaintRender());
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = this.chart.getCandleData().getDataSets();
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                ICandleDataSet dataSet = (ICandleDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
                this.xBounds.set(this.chart, dataSet);
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                float[] positions = transformer.generateTransformedValuesCandle(dataSet, this.animator.getPhaseX(), this.animator.getPhaseY(), this.xBounds.min, this.xBounds.max);
                float yOffset = Utils.convertDpToPixel(5.0f);
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                int j = 0;
                while (j < positions.length) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.viewPortHandler.isInBoundsRight(x)) break;
                    if (!this.viewPortHandler.isInBoundsLeft(x) || !this.viewPortHandler.isInBoundsY(y)) {
                        j += 2;
                        continue;
                    }
                    CandleEntry entry = (CandleEntry)dataSet.getEntryForIndex(j / 2 + this.xBounds.min);
                    if (dataSet.isDrawValuesEnabled()) {
                        IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                        Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                        this.drawValue(c, iValueFormatter, entry.getHigh(), entry, i, x, y - yOffset, dataSet.getValueTextColor(j / 2));
                    }
                    if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                        Drawable icon = entry.getIcon();
                        int n2 = (int)(x + iconsOffset.x);
                        int n3 = (int)(y + iconsOffset.y);
                        Drawable drawable = icon;
                        Intrinsics.checkNotNull((Object)drawable);
                        Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                    }
                    j += 2;
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        CandleData candleData = this.chart.getCandleData();
        for (Highlight high : indices) {
            CandleEntry e;
            ICandleDataSet set = (ICandleDataSet)candleData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (CandleEntry)set.getEntryForXValue(high.getX(), high.getY()), set)) continue;
            float lowValue = e.getLow() * this.animator.getPhaseY();
            float highValue = e.getHigh() * this.animator.getPhaseY();
            float y = (lowValue + highValue) / 2.0f;
            Transformer transformer = this.chart.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pix = transformer.getPixelForValues(e.getX(), y);
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }
}

