/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0014J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H&J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H&J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H&J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(H&J\u000e\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0012\u0010\u0006\u001a\u00020\u00078\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R$\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0012\u0010\u001b\u001a\u00020\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00020\u000f8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/github/mikephil/charting/renderer/AxisRenderer;", "Lcom/github/mikephil/charting/renderer/Renderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "transformer", "Lcom/github/mikephil/charting/utils/Transformer;", "axis", "Lcom/github/mikephil/charting/components/AxisBase;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/utils/Transformer;Lcom/github/mikephil/charting/components/AxisBase;)V", "getTransformer", "()Lcom/github/mikephil/charting/utils/Transformer;", "setTransformer", "(Lcom/github/mikephil/charting/utils/Transformer;)V", "value", "Landroid/graphics/Paint;", "paintGrid", "getPaintGrid", "()Landroid/graphics/Paint;", "setPaintGrid", "(Landroid/graphics/Paint;)V", "paintAxisLabels", "getPaintAxisLabels", "setPaintAxisLabels", "paintAxisLine", "getPaintAxisLine", "setPaintAxisLine", "limitLinePaint", "limitRangePaint", "limitRangePaintFill", "computeAxis", "", "min", "", "max", "inverted", "", "computeAxisValues", "renderAxisLabels", "c", "Landroid/graphics/Canvas;", "renderGridLines", "renderAxisLine", "renderLimitLines", "setTextColor", "color", "", "MPChartLib_release"})
public abstract class AxisRenderer
extends Renderer {
    @Nullable
    private Transformer transformer;
    @JvmField
    @NotNull
    protected AxisBase axis;
    @NotNull
    private Paint paintGrid;
    @NotNull
    private Paint paintAxisLabels;
    @NotNull
    private Paint paintAxisLine;
    @JvmField
    @NotNull
    protected Paint limitLinePaint;
    @JvmField
    @NotNull
    protected Paint limitRangePaint;
    @JvmField
    @NotNull
    protected Paint limitRangePaintFill;

    /*
     * WARNING - void declaration
     */
    public AxisRenderer(@NotNull ViewPortHandler viewPortHandler, @Nullable Transformer transformer, @NotNull AxisBase axis) {
        void $this$limitRangePaintFill_u24lambda_u244;
        Paint $this$limitRangePaint_u24lambda_u243;
        Paint $this$limitLinePaint_u24lambda_u242;
        Paint $this$paintAxisLine_u24lambda_u241;
        Paint $this$paintGrid_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        super(viewPortHandler);
        this.transformer = transformer;
        this.axis = axis;
        Paint paint2 = paint = new Paint();
        AxisRenderer axisRenderer = this;
        boolean bl = false;
        $this$paintGrid_u24lambda_u240.setColor(-7829368);
        $this$paintGrid_u24lambda_u240.setStrokeWidth(1.0f);
        $this$paintGrid_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$paintGrid_u24lambda_u240.setAlpha(90);
        axisRenderer.paintGrid = paint;
        this.paintAxisLabels = new Paint(1);
        $this$paintGrid_u24lambda_u240 = paint = new Paint();
        axisRenderer = this;
        boolean bl2 = false;
        $this$paintAxisLine_u24lambda_u241.setColor(-16777216);
        $this$paintAxisLine_u24lambda_u241.setStrokeWidth(1.0f);
        $this$paintAxisLine_u24lambda_u241.setStyle(Paint.Style.STROKE);
        axisRenderer.paintAxisLine = paint;
        $this$paintAxisLine_u24lambda_u241 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl3 = false;
        $this$limitLinePaint_u24lambda_u242.setStyle(Paint.Style.STROKE);
        axisRenderer.limitLinePaint = paint;
        $this$limitLinePaint_u24lambda_u242 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl4 = false;
        $this$limitRangePaint_u24lambda_u243.setStyle(Paint.Style.STROKE);
        axisRenderer.limitRangePaint = paint;
        $this$limitRangePaint_u24lambda_u243 = paint = new Paint(1);
        axisRenderer = this;
        boolean bl5 = false;
        $this$limitRangePaintFill_u24lambda_u244.setStyle(Paint.Style.FILL);
        axisRenderer.limitRangePaintFill = paint;
    }

    @Nullable
    public final Transformer getTransformer() {
        return this.transformer;
    }

    public final void setTransformer(@Nullable Transformer transformer) {
        this.transformer = transformer;
    }

    @NotNull
    public final Paint getPaintGrid() {
        return this.paintGrid;
    }

    protected final void setPaintGrid(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintGrid = paint;
    }

    @NotNull
    public final Paint getPaintAxisLabels() {
        return this.paintAxisLabels;
    }

    protected final void setPaintAxisLabels(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintAxisLabels = paint;
    }

    @NotNull
    public final Paint getPaintAxisLine() {
        return this.paintAxisLine;
    }

    protected final void setPaintAxisLine(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.paintAxisLine = paint;
    }

    public void computeAxis(float min, float max, boolean inverted) {
        float minLocal = 0.0f;
        minLocal = min;
        float maxLocal = 0.0f;
        maxLocal = max;
        if (this.viewPortHandler.contentWidth() > 10.0f && !this.viewPortHandler.isFullyZoomedOutY()) {
            Transformer transformer = this.transformer;
            if (transformer != null) {
                Transformer it = transformer;
                boolean bl = false;
                MPPointD p1 = it.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentTop());
                MPPointD p2 = it.getValuesByTouchPoint(this.viewPortHandler.contentLeft(), this.viewPortHandler.contentBottom());
                if (!inverted) {
                    minLocal = (float)p2.y;
                    maxLocal = (float)p1.y;
                } else {
                    minLocal = (float)p1.y;
                    maxLocal = (float)p2.y;
                }
                MPPointD.recycleInstance(p1);
                MPPointD.recycleInstance(p2);
            }
        }
        this.computeAxisValues(minLocal, maxLocal);
    }

    protected void computeAxisValues(float min, float max) {
        int i;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        int labelCount = this.axis.getLabelCount();
        double range = Math.abs((double)(max - min));
        if (labelCount == 0 || range <= 0.0 || Double.isInfinite(range)) {
            this.axis.mEntries = new float[0];
            this.axis.mCenteredEntries = new float[0];
            this.axis.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        if (this.axis.isGranularityEnabled()) {
            double d = interval = interval < (double)this.axis.getGranularity() ? (double)this.axis.getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude) == 0.0 ? interval : Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = this.axis.isCenterAxisLabelsEnabled() ? 1 : 0;
        if (this.axis.isForceLabelsEnabled()) {
            interval = (float)range / (float)(labelCount - 1);
            if (this.axis.isGranularityEnabled()) {
                interval = interval < (double)this.axis.getGranularity() ? (double)this.axis.getGranularity() : interval;
            }
            this.axis.mEntryCount = labelCount;
            this.axis.mEntries = new float[labelCount];
            float v = min;
            for (i = 0; i < labelCount; ++i) {
                this.axis.mEntries[i] = v;
                v += (float)interval;
            }
            n = labelCount;
        } else {
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)min / interval) * interval;
            if (this.axis.isCenterAxisLabelsEnabled()) {
                first -= interval;
            }
            double last = interval == 0.0 ? 0.0 : Utils.nextUp(Math.floor((double)max / interval) * interval);
            double f = 0.0;
            if (!(interval == 0.0) && !(last == first)) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            } else if (last == first && n == 0) {
                n = 1;
            }
            this.axis.mEntryCount = n;
            this.axis.mEntries = new float[n];
            f = first;
            for (int i2 = 0; i2 < n; ++i2) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.axis.mEntries[i2] = (float)f;
                f += interval;
            }
        }
        this.axis.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
        if (this.axis.isCenterAxisLabelsEnabled()) {
            if (this.axis.mCenteredEntries.length < n) {
                this.axis.mCenteredEntries = new float[n];
            }
            float offset = (float)interval / 2.0f;
            int n3 = n;
            for (i = 0; i < n3; ++i) {
                this.axis.mCenteredEntries[i] = this.axis.mEntries[i] + offset;
            }
        }
    }

    public abstract void renderAxisLabels(@NotNull Canvas var1);

    public abstract void renderGridLines(@NotNull Canvas var1);

    public abstract void renderAxisLine(@NotNull Canvas var1);

    public abstract void renderLimitLines(@NotNull Canvas var1);

    public final void setTextColor(int color) {
        this.axis.setTextColor(color);
    }
}

