/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Typeface;
import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class ChartData<T extends IDataSet<? extends Entry>>
implements Serializable {
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin = Float.MAX_VALUE;
    protected float mLeftAxisMax = -3.4028235E38f;
    protected float mLeftAxisMin = Float.MAX_VALUE;
    protected float mRightAxisMax = -3.4028235E38f;
    protected float mRightAxisMin = Float.MAX_VALUE;
    protected List<T> mDataSets;

    public ChartData() {
        this.mDataSets = new ArrayList<T>();
    }

    public ChartData(T ... dataSets) {
        this.mDataSets = this.arrayToList((IDataSet[])dataSets);
        this.notifyDataChanged();
    }

    private List<T> arrayToList(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T set : array) {
            list.add(set);
        }
        return list;
    }

    public ChartData(List<T> sets) {
        this.mDataSets = sets;
        this.notifyDataChanged();
    }

    public void notifyDataChanged() {
        this.calcMinMax();
    }

    public void calcMinMaxY(float fromX, float toX) {
        for (IDataSet set : this.mDataSets) {
            set.calcMinMaxY(fromX, toX);
        }
        this.calcMinMax();
    }

    protected void calcMinMax() {
        T firstRight;
        if (this.mDataSets == null) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        for (Object set : this.mDataSets) {
            this.calcMinMax(set);
        }
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        T firstLeft = this.getFirstLeft(this.mDataSets);
        if (firstLeft != null) {
            this.mLeftAxisMax = firstLeft.getYMax();
            this.mLeftAxisMin = firstLeft.getYMin();
            for (IDataSet dataSet : this.mDataSets) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                if (dataSet.getYMin() < this.mLeftAxisMin) {
                    this.mLeftAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mLeftAxisMax)) continue;
                this.mLeftAxisMax = dataSet.getYMax();
            }
        }
        if ((firstRight = this.getFirstRight(this.mDataSets)) != null) {
            this.mRightAxisMax = firstRight.getYMax();
            this.mRightAxisMin = firstRight.getYMin();
            for (IDataSet dataSet : this.mDataSets) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                if (dataSet.getYMin() < this.mRightAxisMin) {
                    this.mRightAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mRightAxisMax)) continue;
                this.mRightAxisMax = dataSet.getYMax();
            }
        }
    }

    public int getDataSetCount() {
        if (this.mDataSets == null) {
            return 0;
        }
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMin(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMin == Float.MAX_VALUE) {
                return this.mRightAxisMin;
            }
            return this.mLeftAxisMin;
        }
        if (this.mRightAxisMin == Float.MAX_VALUE) {
            return this.mLeftAxisMin;
        }
        return this.mRightAxisMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getYMax(YAxis.AxisDependency axis) {
        if (axis == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax == -3.4028235E38f) {
                return this.mRightAxisMax;
            }
            return this.mLeftAxisMax;
        }
        if (this.mRightAxisMax == -3.4028235E38f) {
            return this.mLeftAxisMax;
        }
        return this.mRightAxisMax;
    }

    public float getXMin() {
        return this.mXMin;
    }

    public float getXMax() {
        return this.mXMax;
    }

    public List<T> getDataSets() {
        return this.mDataSets;
    }

    protected int getDataSetIndexByLabel(List<T> dataSets, String label, boolean ignorecase) {
        if (ignorecase) {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equalsIgnoreCase(((IDataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        } else {
            for (int i = 0; i < dataSets.size(); ++i) {
                if (!label.equals(((IDataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        }
        return -1;
    }

    public String[] getDataSetLabels() {
        String[] types = new String[this.mDataSets.size()];
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            types[i] = ((IDataSet)this.mDataSets.get(i)).getLabel();
        }
        return types;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        if (highlight.getDataSetIndex() >= this.mDataSets.size()) {
            return null;
        }
        return ((IDataSet)this.mDataSets.get(highlight.getDataSetIndex())).getEntryForXValue(highlight.getX(), highlight.getY());
    }

    public T getDataSetByLabel(String label, boolean ignorecase) {
        int index = this.getDataSetIndexByLabel(this.mDataSets, label, ignorecase);
        if (index < 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((IDataSet)this.mDataSets.get(index));
    }

    public T getDataSetByIndex(int index) {
        if (this.mDataSets == null || index < 0 || index >= this.mDataSets.size()) {
            return null;
        }
        return (T)((IDataSet)this.mDataSets.get(index));
    }

    public void addDataSet(T d) {
        if (d == null) {
            return;
        }
        this.calcMinMax(d);
        this.mDataSets.add(d);
    }

    public boolean removeDataSet(T d) {
        if (d == null) {
            return false;
        }
        boolean removed = this.mDataSets.remove(d);
        if (removed) {
            this.notifyDataChanged();
        }
        return removed;
    }

    public boolean removeDataSet(int index) {
        if (index >= this.mDataSets.size() || index < 0) {
            return false;
        }
        IDataSet set = (IDataSet)this.mDataSets.get(index);
        return this.removeDataSet(set);
    }

    public void addEntry(Entry e, int dataSetIndex) {
        if (this.mDataSets.size() > dataSetIndex && dataSetIndex >= 0) {
            IDataSet set = (IDataSet)this.mDataSets.get(dataSetIndex);
            if (!set.addEntry(e)) {
                return;
            }
            this.calcMinMax(e, set.getAxisDependency());
        } else {
            Log.e((String)"addEntry", (String)"Cannot add Entry because dataSetIndex too high or too low.");
        }
    }

    protected void calcMinMax(Entry e, YAxis.AxisDependency axis) {
        if (this.mYMax < e.getY()) {
            this.mYMax = e.getY();
        }
        if (this.mYMin > e.getY()) {
            this.mYMin = e.getY();
        }
        if (this.mXMax < e.getX()) {
            this.mXMax = e.getX();
        }
        if (this.mXMin > e.getX()) {
            this.mXMin = e.getX();
        }
        if (axis == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < e.getY()) {
                this.mLeftAxisMax = e.getY();
            }
            if (this.mLeftAxisMin > e.getY()) {
                this.mLeftAxisMin = e.getY();
            }
        } else {
            if (this.mRightAxisMax < e.getY()) {
                this.mRightAxisMax = e.getY();
            }
            if (this.mRightAxisMin > e.getY()) {
                this.mRightAxisMin = e.getY();
            }
        }
    }

    protected void calcMinMax(T d) {
        if (this.mYMax < d.getYMax()) {
            this.mYMax = d.getYMax();
        }
        if (this.mYMin > d.getYMin()) {
            this.mYMin = d.getYMin();
        }
        if (this.mXMax < d.getXMax()) {
            this.mXMax = d.getXMax();
        }
        if (this.mXMin > d.getXMin()) {
            this.mXMin = d.getXMin();
        }
        if (d.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < d.getYMax()) {
                this.mLeftAxisMax = d.getYMax();
            }
            if (this.mLeftAxisMin > d.getYMin()) {
                this.mLeftAxisMin = d.getYMin();
            }
        } else {
            if (this.mRightAxisMax < d.getYMax()) {
                this.mRightAxisMax = d.getYMax();
            }
            if (this.mRightAxisMin > d.getYMin()) {
                this.mRightAxisMin = d.getYMin();
            }
        }
    }

    public boolean removeEntry(Entry e, int dataSetIndex) {
        if (e == null || dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        IDataSet set = (IDataSet)this.mDataSets.get(dataSetIndex);
        if (set != null) {
            boolean removed = set.removeEntry(e);
            if (removed) {
                this.notifyDataChanged();
            }
            return removed;
        }
        return false;
    }

    public boolean removeEntry(float xValue, int dataSetIndex) {
        if (dataSetIndex >= this.mDataSets.size()) {
            return false;
        }
        IDataSet dataSet = (IDataSet)this.mDataSets.get(dataSetIndex);
        Object e = dataSet.getEntryForXValue(xValue, Float.NaN);
        if (e == null) {
            return false;
        }
        return this.removeEntry((Entry)e, dataSetIndex);
    }

    public T getDataSetForEntry(Entry e) {
        if (e == null) {
            return null;
        }
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            IDataSet set = (IDataSet)this.mDataSets.get(i);
            for (int j = 0; j < set.getEntryCount(); ++j) {
                if (!e.equalTo((Entry)set.getEntryForXValue(e.getX(), e.getY()))) continue;
                return (T)set;
            }
        }
        return null;
    }

    public int[] getColors() {
        if (this.mDataSets == null) {
            return null;
        }
        int clrcnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            clrcnt += ((IDataSet)this.mDataSets.get(i)).getColors().size();
        }
        int[] colors = new int[clrcnt];
        int cnt = 0;
        for (int i = 0; i < this.mDataSets.size(); ++i) {
            List<Integer> clrs = ((IDataSet)this.mDataSets.get(i)).getColors();
            for (Integer clr : clrs) {
                colors[cnt] = clr;
                ++cnt;
            }
        }
        return colors;
    }

    public int getIndexOfDataSet(T dataSet) {
        return this.mDataSets.indexOf(dataSet);
    }

    protected T getFirstLeft(List<T> sets) {
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public T getFirstRight(List<T> sets) {
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public void setValueFormatter(IValueFormatter f) {
        if (f == null) {
            return;
        }
        for (IDataSet set : this.mDataSets) {
            set.setValueFormatter(f);
        }
    }

    public void setValueTextColor(int color) {
        for (IDataSet set : this.mDataSets) {
            set.setValueTextColor(color);
        }
    }

    public void setValueTextColors(List<Integer> colors) {
        for (IDataSet set : this.mDataSets) {
            set.setValueTextColors(colors);
        }
    }

    public void setValueTypeface(Typeface tf) {
        for (IDataSet set : this.mDataSets) {
            set.setValueTypeface(tf);
        }
    }

    public void setValueTextSize(float size) {
        for (IDataSet set : this.mDataSets) {
            set.setValueTextSize(size);
        }
    }

    public void setDrawValues(boolean enabled) {
        for (IDataSet set : this.mDataSets) {
            set.setDrawValues(enabled);
        }
    }

    public void setHighlightEnabled(boolean enabled) {
        for (IDataSet set : this.mDataSets) {
            set.setHighlightEnabled(enabled);
        }
    }

    public boolean isHighlightEnabled() {
        for (IDataSet set : this.mDataSets) {
            if (set.isHighlightEnabled()) continue;
            return false;
        }
        return true;
    }

    public void clearValues() {
        if (this.mDataSets != null) {
            this.mDataSets.clear();
        }
        this.notifyDataChanged();
    }

    public boolean contains(T dataSet) {
        for (IDataSet set : this.mDataSets) {
            if (!set.equals(dataSet)) continue;
            return true;
        }
        return false;
    }

    public int getEntryCount() {
        int count = 0;
        for (IDataSet set : this.mDataSets) {
            count += set.getEntryCount();
        }
        return count;
    }

    public T getMaxEntryCountSet() {
        if (this.mDataSets == null || this.mDataSets.isEmpty()) {
            return null;
        }
        IDataSet max = (IDataSet)this.mDataSets.get(0);
        for (IDataSet set : this.mDataSets) {
            if (set.getEntryCount() <= max.getEntryCount()) continue;
            max = set;
        }
        return (T)max;
    }
}

