/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.HorizontalBarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class RoundedHorizontalBarChartRenderer
extends HorizontalBarChartRenderer {
    private final RectF mBarShadowRectBuffer = new RectF();
    private float roundedShadowRadius = 0.0f;
    private float roundedPositiveDataSetRadius = 0.0f;
    private float roundedNegativeDataSetRadius = 0.0f;

    public void setRoundedNegativeDataSetRadius(float roundedNegativeDataSet) {
        this.roundedNegativeDataSetRadius = roundedNegativeDataSet;
    }

    public void setRoundedShadowRadius(float roundedShadow) {
        this.roundedShadowRadius = roundedShadow;
    }

    public void setRoundedPositiveDataSetRadius(float roundedPositiveDataSet) {
        this.roundedPositiveDataSetRadius = roundedPositiveDataSet;
    }

    public RoundedHorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    protected void drawDataSet(Canvas c, IBarDataSet dataSet, int index) {
        boolean isSingleColor;
        this.initBuffers();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mBarBorderPaint.setColor(dataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mShadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.mChart.getBarData();
            float barWidth = barData.getBarWidth();
            float barWidthHalf = barWidth / 2.0f;
            int i = 0;
            double count = Math.min((double)((int)((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
            while ((double)i < count) {
                BarEntry e = (BarEntry)dataSet.getEntryForIndex(i);
                float x = e.getX();
                this.mBarShadowRectBuffer.top = x - barWidthHalf;
                this.mBarShadowRectBuffer.bottom = x + barWidthHalf;
                trans.rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.mViewPortHandler.isInBoundsTop(this.mBarShadowRectBuffer.bottom)) {
                    ++i;
                    continue;
                }
                if (!this.mViewPortHandler.isInBoundsBottom(this.mBarShadowRectBuffer.top)) break;
                this.mBarShadowRectBuffer.left = this.mViewPortHandler.contentLeft();
                this.mBarShadowRectBuffer.right = this.mViewPortHandler.contentRight();
                if (this.roundedShadowRadius > 0.0f) {
                    c.drawRoundRect(this.mBarRect, this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                } else {
                    c.drawRect(this.mBarShadowRectBuffer, this.mShadowPaint);
                }
                ++i;
            }
        }
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        if (dataSet.getColors().size() > 1) {
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) continue;
                if (this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        if (this.roundedShadowRadius > 0.0f) {
                            c.drawRoundRect(new RectF(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                        } else {
                            c.drawRect(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
                        }
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(j / 4));
                    if (this.roundedPositiveDataSetRadius > 0.0f) {
                        c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.mRenderPaint);
                        continue;
                    }
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) continue;
                if (this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        if (this.roundedShadowRadius > 0.0f) {
                            c.drawRoundRect(new RectF(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                        } else {
                            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                        }
                    }
                    if (this.roundedPositiveDataSetRadius > 0.0f) {
                        c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.mRenderPaint);
                        continue;
                    }
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        }
        boolean bl = isSingleColor = dataSet.getColors().size() == 1;
        if (isSingleColor) {
            this.mRenderPaint.setColor(dataSet.getColor(index));
        }
        int j = 0;
        while (j < buffer.size()) {
            if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3])) {
                j += 4;
                continue;
            }
            if (!this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) break;
            if (!isSingleColor) {
                this.mRenderPaint.setColor(dataSet.getColor(j / 4));
            }
            if (((BarEntry)dataSet.getEntryForIndex(j / 4)).getY() < 0.0f && this.roundedNegativeDataSetRadius > 0.0f) {
                Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedNegativeDataSetRadius, this.roundedNegativeDataSetRadius, true, true, true, true);
                c.drawPath(path2, this.mRenderPaint);
            } else if (((BarEntry)dataSet.getEntryForIndex(j / 4)).getY() > 0.0f && this.roundedPositiveDataSetRadius > 0.0f) {
                Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, true, true, true, true);
                c.drawPath(path2, this.mRenderPaint);
            } else {
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            }
            j += 4;
        }
    }

    private Path roundRect(RectF rect, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        float top = rect.top;
        float left = rect.left;
        float right = rect.right;
        float bottom = rect.bottom;
        Path path = new Path();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        path.moveTo(right, top + ry);
        if (tr) {
            path.rQuadTo(0.0f, -ry, -rx, -ry);
        } else {
            path.rLineTo(0.0f, -ry);
            path.rLineTo(-rx, 0.0f);
        }
        path.rLineTo(-widthMinusCorners, 0.0f);
        if (tl) {
            path.rQuadTo(-rx, 0.0f, -rx, ry);
        } else {
            path.rLineTo(-rx, 0.0f);
            path.rLineTo(0.0f, ry);
        }
        path.rLineTo(0.0f, heightMinusCorners);
        if (bl) {
            path.rQuadTo(0.0f, ry, rx, ry);
        } else {
            path.rLineTo(0.0f, ry);
            path.rLineTo(rx, 0.0f);
        }
        path.rLineTo(widthMinusCorners, 0.0f);
        if (br) {
            path.rQuadTo(rx, 0.0f, rx, -ry);
        } else {
            path.rLineTo(rx, 0.0f);
            path.rLineTo(0.0f, -ry);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }
}

