/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CandleEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class CandleStickChartRenderer
extends LineScatterCandleRadarRenderer {
    protected CandleDataProvider mChart;
    private float[] mShadowBuffers = new float[8];
    private float[] mBodyBuffers = new float[4];
    private float[] mRangeBuffers = new float[4];
    private float[] mOpenBuffers = new float[4];
    private float[] mCloseBuffers = new float[4];

    public CandleStickChartRenderer(CandleDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        CandleData candleData = this.mChart.getCandleData();
        for (ICandleDataSet set : candleData.getDataSets()) {
            if (!set.isVisible()) continue;
            this.drawDataSet(c, set);
        }
    }

    protected void drawDataSet(Canvas c, ICandleDataSet dataSet) {
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.mAnimator.getPhaseY();
        float barSpace = dataSet.getBarSpace();
        boolean showCandleBar = dataSet.getShowCandleBar();
        this.mXBounds.set(this.mChart, dataSet);
        this.mRenderPaint.setStrokeWidth(dataSet.getShadowWidth());
        for (int j = this.mXBounds.min; j <= this.mXBounds.range + this.mXBounds.min; ++j) {
            CandleEntry e = (CandleEntry)dataSet.getEntryForIndex(j);
            if (e == null) continue;
            float xPos = e.getX();
            float open = e.getOpen();
            float close = e.getClose();
            float high = e.getHigh();
            float low = e.getLow();
            if (showCandleBar) {
                this.mShadowBuffers[0] = xPos;
                this.mShadowBuffers[2] = xPos;
                this.mShadowBuffers[4] = xPos;
                this.mShadowBuffers[6] = xPos;
                if (open > close) {
                    this.mShadowBuffers[1] = high * phaseY;
                    this.mShadowBuffers[3] = open * phaseY;
                    this.mShadowBuffers[5] = low * phaseY;
                    this.mShadowBuffers[7] = close * phaseY;
                } else if (open < close) {
                    this.mShadowBuffers[1] = high * phaseY;
                    this.mShadowBuffers[3] = close * phaseY;
                    this.mShadowBuffers[5] = low * phaseY;
                    this.mShadowBuffers[7] = open * phaseY;
                } else {
                    this.mShadowBuffers[1] = high * phaseY;
                    this.mShadowBuffers[3] = open * phaseY;
                    this.mShadowBuffers[5] = low * phaseY;
                    this.mShadowBuffers[7] = this.mShadowBuffers[3];
                }
                trans.pointValuesToPixel(this.mShadowBuffers);
                if (dataSet.getShadowColorSameAsCandle()) {
                    if (open > close) {
                        this.mRenderPaint.setColor(dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getDecreasingColor());
                    } else if (open < close) {
                        this.mRenderPaint.setColor(dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getIncreasingColor());
                    } else {
                        this.mRenderPaint.setColor(dataSet.getNeutralColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getNeutralColor());
                    }
                } else {
                    this.mRenderPaint.setColor(dataSet.getShadowColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getShadowColor());
                }
                this.mRenderPaint.setStyle(Paint.Style.STROKE);
                c.drawLines(this.mShadowBuffers, this.mRenderPaint);
                this.mBodyBuffers[0] = xPos - 0.5f + barSpace;
                this.mBodyBuffers[1] = close * phaseY;
                this.mBodyBuffers[2] = xPos + 0.5f - barSpace;
                this.mBodyBuffers[3] = open * phaseY;
                trans.pointValuesToPixel(this.mBodyBuffers);
                if (open > close) {
                    if (dataSet.getDecreasingColor() == 0x112233) {
                        this.mRenderPaint.setColor(dataSet.getColor(j));
                    } else {
                        this.mRenderPaint.setColor(dataSet.getDecreasingColor());
                    }
                    this.mRenderPaint.setStyle(dataSet.getDecreasingPaintStyle());
                    c.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[3], this.mBodyBuffers[2], this.mBodyBuffers[1], this.mRenderPaint);
                    continue;
                }
                if (open < close) {
                    if (dataSet.getIncreasingColor() == 0x112233) {
                        this.mRenderPaint.setColor(dataSet.getColor(j));
                    } else {
                        this.mRenderPaint.setColor(dataSet.getIncreasingColor());
                    }
                    this.mRenderPaint.setStyle(dataSet.getIncreasingPaintStyle());
                    c.drawRect(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
                    continue;
                }
                if (dataSet.getNeutralColor() == 0x112233) {
                    this.mRenderPaint.setColor(dataSet.getColor(j));
                } else {
                    this.mRenderPaint.setColor(dataSet.getNeutralColor());
                }
                c.drawLine(this.mBodyBuffers[0], this.mBodyBuffers[1], this.mBodyBuffers[2], this.mBodyBuffers[3], this.mRenderPaint);
                continue;
            }
            this.mRangeBuffers[0] = xPos;
            this.mRangeBuffers[1] = high * phaseY;
            this.mRangeBuffers[2] = xPos;
            this.mRangeBuffers[3] = low * phaseY;
            this.mOpenBuffers[0] = xPos - 0.5f + barSpace;
            this.mOpenBuffers[1] = open * phaseY;
            this.mOpenBuffers[2] = xPos;
            this.mOpenBuffers[3] = open * phaseY;
            this.mCloseBuffers[0] = xPos + 0.5f - barSpace;
            this.mCloseBuffers[1] = close * phaseY;
            this.mCloseBuffers[2] = xPos;
            this.mCloseBuffers[3] = close * phaseY;
            trans.pointValuesToPixel(this.mRangeBuffers);
            trans.pointValuesToPixel(this.mOpenBuffers);
            trans.pointValuesToPixel(this.mCloseBuffers);
            int barColor = open > close ? (dataSet.getDecreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getDecreasingColor()) : (open < close ? (dataSet.getIncreasingColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getIncreasingColor()) : (dataSet.getNeutralColor() == 0x112233 ? dataSet.getColor(j) : dataSet.getNeutralColor()));
            this.mRenderPaint.setColor(barColor);
            c.drawLine(this.mRangeBuffers[0], this.mRangeBuffers[1], this.mRangeBuffers[2], this.mRangeBuffers[3], this.mRenderPaint);
            c.drawLine(this.mOpenBuffers[0], this.mOpenBuffers[1], this.mOpenBuffers[2], this.mOpenBuffers[3], this.mRenderPaint);
            c.drawLine(this.mCloseBuffers[0], this.mCloseBuffers[1], this.mCloseBuffers[2], this.mCloseBuffers[3], this.mRenderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getCandleData().getDataSets();
            for (int i = 0; i < dataSets.size(); ++i) {
                ICandleDataSet dataSet = (ICandleDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(dataSet);
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                this.mXBounds.set(this.mChart, dataSet);
                float[] positions = trans.generateTransformedValuesCandle(dataSet, this.mAnimator.getPhaseX(), this.mAnimator.getPhaseY(), this.mXBounds.min, this.mXBounds.max);
                float yOffset = Utils.convertDpToPixel(5.0f);
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                for (int j = 0; j < positions.length; j += 2) {
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                    if (!this.mViewPortHandler.isInBoundsLeft(x) || !this.mViewPortHandler.isInBoundsY(y)) continue;
                    CandleEntry entry = (CandleEntry)dataSet.getEntryForIndex(j / 2 + this.mXBounds.min);
                    if (dataSet.isDrawValuesEnabled()) {
                        this.drawValue(c, dataSet.getValueFormatter(), entry.getHigh(), entry, i, x, y - yOffset, dataSet.getValueTextColor(j / 2));
                    }
                    if (entry.getIcon() == null || !dataSet.isDrawIconsEnabled()) continue;
                    Drawable icon = entry.getIcon();
                    Utils.drawImage(c, icon, (int)(x + iconsOffset.x), (int)(y + iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(Canvas c) {
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        CandleData candleData = this.mChart.getCandleData();
        for (Highlight high : indices) {
            CandleEntry e;
            ICandleDataSet set = (ICandleDataSet)candleData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (CandleEntry)set.getEntryForXValue(high.getX(), high.getY()), set)) continue;
            float lowValue = e.getLow() * this.mAnimator.getPhaseY();
            float highValue = e.getHigh() * this.mAnimator.getPhaseY();
            float y = (lowValue + highValue) / 2.0f;
            MPPointD pix = this.mChart.getTransformer(set.getAxisDependency()).getPixelForValues(e.getX(), y);
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }
}

