/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.utils.Utils;

public class YAxis
extends AxisBase {
    private boolean mDrawBottomYLabelEntry = true;
    private boolean mDrawTopYLabelEntry = true;
    protected boolean mInverted = false;
    protected boolean mDrawZeroLine = false;
    private boolean mUseAutoScaleRestrictionMin = false;
    private boolean mUseAutoScaleRestrictionMax = false;
    protected int mZeroLineColor = -7829368;
    protected float mZeroLineWidth = 1.0f;
    protected float mSpacePercentTop = 10.0f;
    protected float mSpacePercentBottom = 10.0f;
    private YAxisLabelPosition mPosition = YAxisLabelPosition.OUTSIDE_CHART;
    private float mXLabelOffset = 0.0f;
    private AxisDependency mAxisDependency;
    protected float mMinWidth = 0.0f;
    protected float mMaxWidth = Float.POSITIVE_INFINITY;

    public YAxis() {
        this.mAxisDependency = AxisDependency.LEFT;
        this.mYOffset = 0.0f;
    }

    public YAxis(AxisDependency position) {
        this.mAxisDependency = position;
        this.mYOffset = 0.0f;
    }

    public AxisDependency getAxisDependency() {
        return this.mAxisDependency;
    }

    public float getMinWidth() {
        return this.mMinWidth;
    }

    public void setMinWidth(float minWidth) {
        this.mMinWidth = minWidth;
    }

    public float getMaxWidth() {
        return this.mMaxWidth;
    }

    public void setMaxWidth(float maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public YAxisLabelPosition getLabelPosition() {
        return this.mPosition;
    }

    public void setPosition(YAxisLabelPosition pos) {
        this.mPosition = pos;
    }

    public float getLabelXOffset() {
        return this.mXLabelOffset;
    }

    public void setLabelXOffset(float xOffset) {
        this.mXLabelOffset = xOffset;
    }

    public boolean isDrawTopYLabelEntryEnabled() {
        return this.mDrawTopYLabelEntry;
    }

    public boolean isDrawBottomYLabelEntryEnabled() {
        return this.mDrawBottomYLabelEntry;
    }

    public void setDrawTopYLabelEntry(boolean enabled) {
        this.mDrawTopYLabelEntry = enabled;
    }

    public void setInverted(boolean enabled) {
        this.mInverted = enabled;
    }

    public boolean isInverted() {
        return this.mInverted;
    }

    @Deprecated
    public void setStartAtZero(boolean startAtZero) {
        if (startAtZero) {
            this.setAxisMinimum(0.0f);
        } else {
            this.resetAxisMinimum();
        }
    }

    public void setSpaceTop(float percent) {
        this.mSpacePercentTop = percent;
    }

    public float getSpaceTop() {
        return this.mSpacePercentTop;
    }

    public void setSpaceBottom(float percent) {
        this.mSpacePercentBottom = percent;
    }

    public float getSpaceBottom() {
        return this.mSpacePercentBottom;
    }

    public boolean isDrawZeroLineEnabled() {
        return this.mDrawZeroLine;
    }

    public void setDrawZeroLine(boolean mDrawZeroLine) {
        this.mDrawZeroLine = mDrawZeroLine;
    }

    public int getZeroLineColor() {
        return this.mZeroLineColor;
    }

    public void setZeroLineColor(int color) {
        this.mZeroLineColor = color;
    }

    public float getZeroLineWidth() {
        return this.mZeroLineWidth;
    }

    public void setZeroLineWidth(float width) {
        this.mZeroLineWidth = Utils.convertDpToPixel(width);
    }

    public float getRequiredWidthSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel(p);
        float width = (float)Utils.calcTextWidth(p, label) + this.getXOffset() * 2.0f;
        float minWidth = this.getMinWidth();
        float maxWidth = this.getMaxWidth();
        if (minWidth > 0.0f) {
            minWidth = Utils.convertDpToPixel(minWidth);
        }
        if (maxWidth > 0.0f && maxWidth != Float.POSITIVE_INFINITY) {
            maxWidth = Utils.convertDpToPixel(maxWidth);
        }
        width = Math.max(minWidth, Math.min(width, (double)maxWidth > 0.0 ? maxWidth : width));
        return width;
    }

    public float getRequiredHeightSpace(Paint p) {
        p.setTextSize(this.mTextSize);
        String label = this.getLongestLabel(p);
        return (float)Utils.calcTextHeight(p, label) + this.getYOffset() * 2.0f;
    }

    public boolean needsOffset() {
        return this.isEnabled() && this.isDrawLabelsEnabled() && this.getLabelPosition() == YAxisLabelPosition.OUTSIDE_CHART;
    }

    @Deprecated
    public boolean isUseAutoScaleMinRestriction() {
        return this.mUseAutoScaleRestrictionMin;
    }

    @Deprecated
    public void setUseAutoScaleMinRestriction(boolean isEnabled) {
        this.mUseAutoScaleRestrictionMin = isEnabled;
    }

    @Deprecated
    public boolean isUseAutoScaleMaxRestriction() {
        return this.mUseAutoScaleRestrictionMax;
    }

    @Deprecated
    public void setUseAutoScaleMaxRestriction(boolean isEnabled) {
        this.mUseAutoScaleRestrictionMax = isEnabled;
    }

    @Override
    public void calculate(float dataMin, float dataMax) {
        float range;
        float min = dataMin;
        float max = dataMax;
        if (min > max) {
            if (this.mCustomAxisMax && this.mCustomAxisMin) {
                float t = min;
                min = max;
                max = t;
            } else if (this.mCustomAxisMax) {
                min = max < 0.0f ? max * 1.5f : max * 0.5f;
            } else if (this.mCustomAxisMin) {
                float f = max = min < 0.0f ? min * 0.5f : min * 1.5f;
            }
        }
        if ((range = Math.abs(max - min)) == 0.0f) {
            max += 1.0f;
            min -= 1.0f;
        }
        range = Math.abs(max - min);
        this.mAxisMinimum = this.mCustomAxisMin ? this.mAxisMinimum : min - range / 100.0f * this.getSpaceBottom();
        this.mAxisMaximum = this.mCustomAxisMax ? this.mAxisMaximum : max + range / 100.0f * this.getSpaceTop();
        this.mAxisRange = Math.abs(this.mAxisMinimum - this.mAxisMaximum);
    }

    public static enum YAxisLabelPosition {
        OUTSIDE_CHART,
        INSIDE_CHART;

    }

    public static enum AxisDependency {
        LEFT,
        RIGHT;

    }
}

