/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.buffer;

import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class HorizontalBarBuffer
extends BarBuffer {
    public HorizontalBarBuffer(int size, int dataSetCount, boolean containsStacks) {
        super(size, dataSetCount, containsStacks);
    }

    @Override
    public void feed(IBarDataSet data) {
        float size = (float)data.getEntryCount() * this.phaseX;
        float barWidthHalf = this.mBarWidth / 2.0f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e = (BarEntry)data.getEntryForIndex(i);
            if (e != null) {
                float x = e.getX();
                float y = e.getY();
                float[] vals = e.getYVals();
                if (!this.mContainsStacks || vals == null) {
                    float right;
                    float left;
                    float bottom = x - barWidthHalf;
                    float top = x + barWidthHalf;
                    if (this.mInverted) {
                        left = y >= 0.0f ? y : 0.0f;
                        right = y <= 0.0f ? y : 0.0f;
                    } else {
                        right = y >= 0.0f ? y : 0.0f;
                        float f = left = y <= 0.0f ? y : 0.0f;
                    }
                    if (right > 0.0f) {
                        right *= this.phaseY;
                    } else {
                        left *= this.phaseY;
                    }
                    this.addBar(left, top, right, bottom);
                } else {
                    float posY = 0.0f;
                    float negY = -e.getNegativeSum();
                    float yStart = 0.0f;
                    for (int k = 0; k < vals.length; ++k) {
                        float value = vals[k];
                        if (value >= 0.0f) {
                            y = posY;
                            posY = yStart = posY + value;
                        } else {
                            y = negY;
                            yStart = negY + Math.abs(value);
                            negY += Math.abs(value);
                        }
                        float bottom = x - barWidthHalf;
                        float top = x + barWidthHalf;
                        if (this.mInverted) {
                            left = y >= yStart ? y : yStart;
                            right = y <= yStart ? y : yStart;
                        } else {
                            right = y >= yStart ? y : yStart;
                            left = y <= yStart ? y : yStart;
                        }
                        this.addBar(left *= this.phaseY, top, right *= this.phaseY, bottom);
                    }
                }
            }
            ++i;
        }
        this.reset();
    }
}

