/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import java.util.Locale;

public class LineChart
extends BarLineChartBase<LineData>
implements LineDataProvider {
    public LineChart(Context context) {
        super(context);
    }

    public LineChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LineChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new LineChartRenderer(this, this.mAnimator, this.mViewPortHandler);
    }

    @Override
    public LineData getLineData() {
        return (LineData)this.mData;
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mRenderer != null && this.mRenderer instanceof LineChartRenderer) {
            ((LineChartRenderer)this.mRenderer).releaseBitmap();
        }
        super.onDetachedFromWindow();
    }

    @Override
    public String getAccessibilityDescription() {
        LineData lineData = this.getLineData();
        int numberOfPoints = lineData.getEntryCount();
        IAxisValueFormatter yAxisValueFormmater = this.getAxisLeft().getValueFormatter();
        String minVal = yAxisValueFormmater.getFormattedValue(lineData.getYMin(), null);
        String maxVal = yAxisValueFormmater.getFormattedValue(lineData.getYMax(), null);
        IAxisValueFormatter xAxisValueFormatter = this.getXAxis().getValueFormatter();
        String minRange = xAxisValueFormatter.getFormattedValue(lineData.getXMin(), null);
        String maxRange = xAxisValueFormatter.getFormattedValue(lineData.getXMax(), null);
        String entries = numberOfPoints == 1 ? "entry" : "entries";
        return String.format(Locale.getDefault(), "The line chart has %d %s. The minimum value is %s and maximum value is %s.Data ranges from %s to %s.", numberOfPoints, entries, minVal, maxVal, minRange, maxRange);
    }
}

