/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.PieChart;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.data.PieDataSet;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.List;

public class PieChartRenderer
extends DataRenderer {
    protected PieChart mChart;
    protected Paint mHolePaint;
    protected Paint mTransparentCirclePaint;
    protected Paint mValueLinePaint;
    private TextPaint mCenterTextPaint;
    private Paint mEntryLabelsPaint;
    private StaticLayout mCenterTextLayout;
    private CharSequence mCenterTextLastValue;
    private RectF mCenterTextLastBounds = new RectF();
    private RectF[] mRectBuffer = new RectF[]{new RectF(), new RectF(), new RectF()};
    protected WeakReference<Bitmap> mDrawBitmap;
    protected Canvas mBitmapCanvas;
    private Path mPathBuffer = new Path();
    private RectF mInnerRectBuffer = new RectF();
    private Path mHoleCirclePath = new Path();
    protected Path mDrawCenterTextPathBuffer = new Path();
    protected RectF mDrawHighlightedRectF = new RectF();

    public PieChartRenderer(PieChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHolePaint = new Paint(1);
        this.mHolePaint.setColor(-1);
        this.mHolePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint = new Paint(1);
        this.mTransparentCirclePaint.setColor(-1);
        this.mTransparentCirclePaint.setStyle(Paint.Style.FILL);
        this.mTransparentCirclePaint.setAlpha(105);
        this.mCenterTextPaint = new TextPaint(1);
        this.mCenterTextPaint.setColor(-16777216);
        this.mCenterTextPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mValuePaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValuePaint.setColor(-1);
        this.mValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mEntryLabelsPaint = new Paint(1);
        this.mEntryLabelsPaint.setColor(-1);
        this.mEntryLabelsPaint.setTextAlign(Paint.Align.CENTER);
        this.mEntryLabelsPaint.setTextSize(Utils.convertDpToPixel(13.0f));
        this.mValueLinePaint = new Paint(1);
        this.mValueLinePaint.setStyle(Paint.Style.STROKE);
    }

    public Paint getPaintHole() {
        return this.mHolePaint;
    }

    public Paint getPaintTransparentCircle() {
        return this.mTransparentCirclePaint;
    }

    public TextPaint getPaintCenterText() {
        return this.mCenterTextPaint;
    }

    public Paint getPaintEntryLabels() {
        return this.mEntryLabelsPaint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas c) {
        Bitmap drawBitmap;
        int width = (int)this.mViewPortHandler.getChartWidth();
        int height = (int)this.mViewPortHandler.getChartHeight();
        Bitmap bitmap = drawBitmap = this.mDrawBitmap == null ? null : (Bitmap)this.mDrawBitmap.get();
        if (drawBitmap == null || drawBitmap.getWidth() != width || drawBitmap.getHeight() != height) {
            if (width > 0 && height > 0) {
                drawBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.mDrawBitmap = new WeakReference<Bitmap>(drawBitmap);
                this.mBitmapCanvas = new Canvas(drawBitmap);
            } else {
                return;
            }
        }
        drawBitmap.eraseColor(0);
        PieData pieData = (PieData)this.mChart.getData();
        for (IPieDataSet set : pieData.getDataSets()) {
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set);
        }
    }

    protected float calculateMinimumRadiusForSpacedSlice(MPPointF center, float radius, float angle, float arcStartPointX, float arcStartPointY, float startAngle, float sweepAngle) {
        float angleMiddle = startAngle + sweepAngle / 2.0f;
        float arcEndPointX = center.x + radius * (float)Math.cos((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcEndPointY = center.y + radius * (float)Math.sin((startAngle + sweepAngle) * ((float)Math.PI / 180));
        float arcMidPointX = center.x + radius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
        float arcMidPointY = center.y + radius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
        double basePointsDistance = Math.sqrt(Math.pow(arcEndPointX - arcStartPointX, 2.0) + Math.pow(arcEndPointY - arcStartPointY, 2.0));
        float containedTriangleHeight = (float)(basePointsDistance / 2.0 * Math.tan((180.0 - (double)angle) / 2.0 * (Math.PI / 180)));
        float spacedRadius = radius - containedTriangleHeight;
        spacedRadius = (float)((double)spacedRadius - Math.sqrt(Math.pow(arcMidPointX - (arcEndPointX + arcStartPointX) / 2.0f, 2.0) + Math.pow(arcMidPointY - (arcEndPointY + arcStartPointY) / 2.0f, 2.0)));
        return spacedRadius;
    }

    protected float getSliceSpace(IPieDataSet dataSet) {
        float minValueRatio;
        if (!dataSet.isAutomaticallyDisableSliceSpacingEnabled()) {
            return dataSet.getSliceSpace();
        }
        float spaceSizeRatio = dataSet.getSliceSpace() / this.mViewPortHandler.getSmallestContentExtension();
        float sliceSpace = spaceSizeRatio > (minValueRatio = dataSet.getYMin() / ((PieData)this.mChart.getData()).getYValueSum() * 2.0f) ? 0.0f : dataSet.getSliceSpace();
        return sliceSpace;
    }

    protected void drawDataSet(Canvas c, IPieDataSet dataSet) {
        float angle = 0.0f;
        float rotationAngle = this.mChart.getRotationAngle();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        RectF circleBox = this.mChart.getCircleBox();
        int entryCount = dataSet.getEntryCount();
        float[] drawAngles = this.mChart.getDrawAngles();
        MPPointF center = this.mChart.getCenterCircleBox();
        float radius = this.mChart.getRadius();
        boolean drawInnerArc = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        float userInnerRadius = drawInnerArc ? radius * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        float roundedRadius = (radius - radius * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        RectF roundedCircleBox = new RectF();
        boolean drawRoundedSlices = drawInnerArc && this.mChart.isDrawRoundedSlicesEnabled();
        int visibleAngleCount = 0;
        for (int j = 0; j < entryCount; ++j) {
            if (!(Math.abs(((PieEntry)dataSet.getEntryForIndex(j)).getY()) > Utils.FLOAT_EPSILON)) continue;
            ++visibleAngleCount;
        }
        float sliceSpace = visibleAngleCount <= 1 ? 0.0f : this.getSliceSpace(dataSet);
        for (int j = 0; j < entryCount; ++j) {
            float sliceAngle = drawAngles[j];
            float innerRadius = userInnerRadius;
            Object e = dataSet.getEntryForIndex(j);
            if (!(Math.abs(((BaseEntry)e).getY()) > Utils.FLOAT_EPSILON)) {
                angle += sliceAngle * phaseX;
                continue;
            }
            if (dataSet.isHighlightEnabled() && this.mChart.needsHighlight(j) && !drawRoundedSlices) {
                angle += sliceAngle * phaseX;
                continue;
            }
            boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
            this.mRenderPaint.setColor(dataSet.getColor(j));
            float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
            float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
            float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            this.mPathBuffer.reset();
            if (drawRoundedSlices) {
                float x = center.x + (radius - roundedRadius) * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180));
                float y = center.y + (radius - roundedRadius) * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180));
                roundedCircleBox.set(x - roundedRadius, y - roundedRadius, x + roundedRadius, y + roundedRadius);
            }
            float arcStartPointX = center.x + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180));
            float arcStartPointY = center.y + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180));
            if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.FLOAT_EPSILON) {
                this.mPathBuffer.addCircle(center.x, center.y, radius, Path.Direction.CW);
            } else {
                if (drawRoundedSlices) {
                    this.mPathBuffer.arcTo(roundedCircleBox, startAngleOuter + 180.0f, -180.0f);
                }
                this.mPathBuffer.arcTo(circleBox, startAngleOuter, sweepAngleOuter);
            }
            this.mInnerRectBuffer.set(center.x - innerRadius, center.y - innerRadius, center.x + innerRadius, center.y + innerRadius);
            if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                if (accountForSliceSpacing) {
                    float minSpacedRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                    if (minSpacedRadius < 0.0f) {
                        minSpacedRadius = -minSpacedRadius;
                    }
                    innerRadius = Math.max(innerRadius, minSpacedRadius);
                }
                float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                if (sweepAngleInner < 0.0f) {
                    sweepAngleInner = 0.0f;
                }
                float endAngleInner = startAngleInner + sweepAngleInner;
                if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.FLOAT_EPSILON) {
                    this.mPathBuffer.addCircle(center.x, center.y, innerRadius, Path.Direction.CCW);
                } else {
                    if (drawRoundedSlices) {
                        float x = center.x + (radius - roundedRadius) * (float)Math.cos(endAngleInner * ((float)Math.PI / 180));
                        float y = center.y + (radius - roundedRadius) * (float)Math.sin(endAngleInner * ((float)Math.PI / 180));
                        roundedCircleBox.set(x - roundedRadius, y - roundedRadius, x + roundedRadius, y + roundedRadius);
                        this.mPathBuffer.arcTo(roundedCircleBox, endAngleInner, 180.0f);
                    } else {
                        this.mPathBuffer.lineTo(center.x + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.y + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                    }
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                }
            } else if (sweepAngleOuter % 360.0f > Utils.FLOAT_EPSILON) {
                if (accountForSliceSpacing) {
                    float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                    float sliceSpaceOffset = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, arcStartPointX, arcStartPointY, startAngleOuter, sweepAngleOuter);
                    float arcEndPointX = center.x + sliceSpaceOffset * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                    float arcEndPointY = center.y + sliceSpaceOffset * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                    this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                } else {
                    this.mPathBuffer.lineTo(center.x, center.y);
                }
            }
            this.mPathBuffer.close();
            this.mBitmapCanvas.drawPath(this.mPathBuffer, this.mRenderPaint);
            angle += sliceAngle * phaseX;
        }
        MPPointF.recycleInstance(center);
    }

    @Override
    public void drawValues(Canvas c) {
        MPPointF center = this.mChart.getCenterCircleBox();
        float radius = this.mChart.getRadius();
        float rotationAngle = this.mChart.getRotationAngle();
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float roundedRadius = (radius - radius * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        float holeRadiusPercent = this.mChart.getHoleRadius() / 100.0f;
        float labelRadiusOffset = radius / 10.0f * 3.6f;
        if (this.mChart.isDrawHoleEnabled()) {
            labelRadiusOffset = (radius - radius * holeRadiusPercent) / 2.0f;
            if (!this.mChart.isDrawSlicesUnderHoleEnabled() && this.mChart.isDrawRoundedSlicesEnabled()) {
                rotationAngle = (float)((double)rotationAngle + (double)(roundedRadius * 360.0f) / (Math.PI * 2 * (double)radius));
            }
        }
        float labelRadius = radius - labelRadiusOffset;
        PieData data = (PieData)this.mChart.getData();
        List<IPieDataSet> dataSets = data.getDataSets();
        float yValueSum = data.getYValueSum();
        boolean drawEntryLabels = this.mChart.isDrawEntryLabelsEnabled();
        int xIndex = 0;
        c.save();
        float offset = Utils.convertDpToPixel(5.0f);
        for (int i = 0; i < dataSets.size(); ++i) {
            boolean drawValues;
            IPieDataSet dataSet = dataSets.get(i);
            if (dataSet.getEntryCount() == 0 || !(drawValues = dataSet.isDrawValuesEnabled()) && !drawEntryLabels) continue;
            PieDataSet.ValuePosition xValuePosition = dataSet.getXValuePosition();
            PieDataSet.ValuePosition yValuePosition = dataSet.getYValuePosition();
            this.applyValueTextStyle(dataSet);
            float lineHeight = (float)Utils.calcTextHeight(this.mValuePaint, "Q") + Utils.convertDpToPixel(4.0f);
            IValueFormatter formatter = dataSet.getValueFormatter();
            int entryCount = dataSet.getEntryCount();
            boolean isUseValueColorForLineEnabled = dataSet.isUseValueColorForLineEnabled();
            int valueLineColor = dataSet.getValueLineColor();
            this.mValueLinePaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getValueLineWidth()));
            float sliceSpace = this.getSliceSpace(dataSet);
            MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
            iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
            iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
            for (int j = 0; j < entryCount; ++j) {
                boolean drawYInside;
                PieEntry entry = (PieEntry)dataSet.getEntryForIndex(j);
                float angle = xIndex == 0 ? 0.0f : absoluteAngles[xIndex - 1] * phaseX;
                float sliceAngle = drawAngles[xIndex];
                float sliceSpaceMiddleAngle = sliceSpace / ((float)Math.PI / 180 * labelRadius);
                float angleOffset = (sliceAngle - sliceSpaceMiddleAngle / 2.0f) / 2.0f;
                float transformedAngle = rotationAngle + (angle += angleOffset) * phaseY;
                float value = this.mChart.isUsePercentValuesEnabled() ? entry.getY() / yValueSum * 100.0f : entry.getY();
                String entryLabel = entry.getLabel();
                float sliceXBase = (float)Math.cos(transformedAngle * ((float)Math.PI / 180));
                float sliceYBase = (float)Math.sin(transformedAngle * ((float)Math.PI / 180));
                boolean drawXOutside = drawEntryLabels && xValuePosition == PieDataSet.ValuePosition.OUTSIDE_SLICE;
                boolean drawYOutside = drawValues && yValuePosition == PieDataSet.ValuePosition.OUTSIDE_SLICE;
                boolean drawXInside = drawEntryLabels && xValuePosition == PieDataSet.ValuePosition.INSIDE_SLICE;
                boolean bl = drawYInside = drawValues && yValuePosition == PieDataSet.ValuePosition.INSIDE_SLICE;
                if (drawXOutside || drawYOutside) {
                    float labelPty;
                    float labelPtx;
                    float pt2y;
                    float pt2x;
                    float valueLineLength1 = dataSet.getValueLinePart1Length();
                    float valueLineLength2 = dataSet.getValueLinePart2Length();
                    float valueLinePart1OffsetPercentage = dataSet.getValueLinePart1OffsetPercentage() / 100.0f;
                    float line1Radius = this.mChart.isDrawHoleEnabled() ? (radius - radius * holeRadiusPercent) * valueLinePart1OffsetPercentage + radius * holeRadiusPercent : radius * valueLinePart1OffsetPercentage;
                    float polyline2Width = dataSet.isValueLineVariableLength() ? labelRadius * valueLineLength2 * (float)Math.abs(Math.sin(transformedAngle * ((float)Math.PI / 180))) : labelRadius * valueLineLength2;
                    float pt0x = line1Radius * sliceXBase + center.x;
                    float pt0y = line1Radius * sliceYBase + center.y;
                    float pt1x = labelRadius * (1.0f + valueLineLength1) * sliceXBase + center.x;
                    float pt1y = labelRadius * (1.0f + valueLineLength1) * sliceYBase + center.y;
                    if ((double)transformedAngle % 360.0 >= 90.0 && (double)transformedAngle % 360.0 <= 270.0) {
                        pt2x = pt1x - polyline2Width;
                        pt2y = pt1y;
                        this.mValuePaint.setTextAlign(Paint.Align.RIGHT);
                        if (drawXOutside) {
                            this.mEntryLabelsPaint.setTextAlign(Paint.Align.RIGHT);
                        }
                        labelPtx = pt2x - offset;
                        labelPty = pt2y;
                    } else {
                        pt2x = pt1x + polyline2Width;
                        pt2y = pt1y;
                        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
                        if (drawXOutside) {
                            this.mEntryLabelsPaint.setTextAlign(Paint.Align.LEFT);
                        }
                        labelPtx = pt2x + offset;
                        labelPty = pt2y;
                    }
                    int lineColor = 0x112233;
                    if (isUseValueColorForLineEnabled) {
                        lineColor = dataSet.getColor(j);
                    } else if (valueLineColor != 0x112233) {
                        lineColor = valueLineColor;
                    }
                    if (lineColor != 0x112233) {
                        this.mValueLinePaint.setColor(lineColor);
                        c.drawLine(pt0x, pt0y, pt1x, pt1y, this.mValueLinePaint);
                        c.drawLine(pt1x, pt1y, pt2x, pt2y, this.mValueLinePaint);
                    }
                    if (drawXOutside && drawYOutside) {
                        this.drawValue(c, formatter, value, entry, 0, labelPtx, labelPty, dataSet.getValueTextColor(j));
                        if (j < data.getEntryCount() && entryLabel != null) {
                            this.drawEntryLabel(c, entryLabel, labelPtx, labelPty + lineHeight);
                        }
                    } else if (drawXOutside) {
                        if (j < data.getEntryCount() && entryLabel != null) {
                            this.drawEntryLabel(c, entryLabel, labelPtx, labelPty + lineHeight / 2.0f);
                        }
                    } else if (drawYOutside) {
                        this.drawValue(c, formatter, value, entry, 0, labelPtx, labelPty + lineHeight / 2.0f, dataSet.getValueTextColor(j));
                    }
                }
                if (drawXInside || drawYInside) {
                    float x = labelRadius * sliceXBase + center.x;
                    float y = labelRadius * sliceYBase + center.y;
                    this.mValuePaint.setTextAlign(Paint.Align.CENTER);
                    if (drawXInside && drawYInside) {
                        this.drawValue(c, formatter, value, entry, 0, x, y, dataSet.getValueTextColor(j));
                        if (j < data.getEntryCount() && entryLabel != null) {
                            this.drawEntryLabel(c, entryLabel, x, y + lineHeight);
                        }
                    } else if (drawXInside) {
                        if (j < data.getEntryCount() && entryLabel != null) {
                            this.drawEntryLabel(c, entryLabel, x, y + lineHeight / 2.0f);
                        }
                    } else if (drawYInside) {
                        this.drawValue(c, formatter, value, entry, 0, x, y + lineHeight / 2.0f, dataSet.getValueTextColor(j));
                    }
                }
                if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                    Drawable icon = entry.getIcon();
                    float x = (labelRadius + iconsOffset.y) * sliceXBase + center.x;
                    float y = (labelRadius + iconsOffset.y) * sliceYBase + center.y;
                    Utils.drawImage(c, icon, (int)x, (int)(y += iconsOffset.x), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                }
                ++xIndex;
            }
            MPPointF.recycleInstance(iconsOffset);
        }
        MPPointF.recycleInstance(center);
        c.restore();
    }

    protected void drawEntryLabel(Canvas c, String label, float x, float y) {
        c.drawText(label, x, y, this.mEntryLabelsPaint);
    }

    @Override
    public void drawExtras(Canvas c) {
        this.drawHole(c);
        c.drawBitmap((Bitmap)this.mDrawBitmap.get(), 0.0f, 0.0f, null);
        this.drawCenterText(c);
    }

    protected void drawHole(Canvas c) {
        if (this.mChart.isDrawHoleEnabled() && this.mBitmapCanvas != null) {
            float radius = this.mChart.getRadius();
            float holeRadius = radius * (this.mChart.getHoleRadius() / 100.0f);
            MPPointF center = this.mChart.getCenterCircleBox();
            if (Color.alpha((int)this.mHolePaint.getColor()) > 0) {
                this.mBitmapCanvas.drawCircle(center.x, center.y, holeRadius, this.mHolePaint);
            }
            if (Color.alpha((int)this.mTransparentCirclePaint.getColor()) > 0 && this.mChart.getTransparentCircleRadius() > this.mChart.getHoleRadius()) {
                int alpha = this.mTransparentCirclePaint.getAlpha();
                float secondHoleRadius = radius * (this.mChart.getTransparentCircleRadius() / 100.0f);
                this.mTransparentCirclePaint.setAlpha((int)((float)alpha * this.mAnimator.getPhaseX() * this.mAnimator.getPhaseY()));
                this.mHoleCirclePath.reset();
                this.mHoleCirclePath.addCircle(center.x, center.y, secondHoleRadius, Path.Direction.CW);
                this.mHoleCirclePath.addCircle(center.x, center.y, holeRadius, Path.Direction.CCW);
                this.mBitmapCanvas.drawPath(this.mHoleCirclePath, this.mTransparentCirclePaint);
                this.mTransparentCirclePaint.setAlpha(alpha);
            }
            MPPointF.recycleInstance(center);
        }
    }

    protected void drawCenterText(Canvas c) {
        CharSequence centerText = this.mChart.getCenterText();
        if (this.mChart.isDrawCenterTextEnabled() && centerText != null) {
            MPPointF center = this.mChart.getCenterCircleBox();
            MPPointF offset = this.mChart.getCenterTextOffset();
            float x = center.x + offset.x;
            float y = center.y + offset.y;
            float innerRadius = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled() ? this.mChart.getRadius() * (this.mChart.getHoleRadius() / 100.0f) : this.mChart.getRadius();
            RectF holeRect = this.mRectBuffer[0];
            holeRect.left = x - innerRadius;
            holeRect.top = y - innerRadius;
            holeRect.right = x + innerRadius;
            holeRect.bottom = y + innerRadius;
            RectF boundingRect = this.mRectBuffer[1];
            boundingRect.set(holeRect);
            float radiusPercent = this.mChart.getCenterTextRadiusPercent() / 100.0f;
            if ((double)radiusPercent > 0.0) {
                boundingRect.inset((boundingRect.width() - boundingRect.width() * radiusPercent) / 2.0f, (boundingRect.height() - boundingRect.height() * radiusPercent) / 2.0f);
            }
            if (!centerText.equals(this.mCenterTextLastValue) || !boundingRect.equals((Object)this.mCenterTextLastBounds)) {
                this.mCenterTextLastBounds.set(boundingRect);
                this.mCenterTextLastValue = centerText;
                float width = this.mCenterTextLastBounds.width();
                this.mCenterTextLayout = new StaticLayout(centerText, 0, centerText.length(), this.mCenterTextPaint, (int)Math.max(Math.ceil(width), 1.0), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
            }
            float layoutHeight = this.mCenterTextLayout.getHeight();
            c.save();
            if (Build.VERSION.SDK_INT >= 18) {
                Path path = this.mDrawCenterTextPathBuffer;
                path.reset();
                path.addOval(holeRect, Path.Direction.CW);
                c.clipPath(path);
            }
            c.translate(boundingRect.left, boundingRect.top + (boundingRect.height() - layoutHeight) / 2.0f);
            this.mCenterTextLayout.draw(c);
            c.restore();
            MPPointF.recycleInstance(center);
            MPPointF.recycleInstance(offset);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        boolean drawInnerArc;
        boolean bl = drawInnerArc = this.mChart.isDrawHoleEnabled() && !this.mChart.isDrawSlicesUnderHoleEnabled();
        if (drawInnerArc && this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        float rotationAngle = this.mChart.getRotationAngle();
        float[] drawAngles = this.mChart.getDrawAngles();
        float[] absoluteAngles = this.mChart.getAbsoluteAngles();
        MPPointF center = this.mChart.getCenterCircleBox();
        float radius = this.mChart.getRadius();
        float userInnerRadius = drawInnerArc ? radius * (this.mChart.getHoleRadius() / 100.0f) : 0.0f;
        RectF highlightedCircleBox = this.mDrawHighlightedRectF;
        highlightedCircleBox.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < indices.length; ++i) {
            IPieDataSet set;
            int index = (int)indices[i].getX();
            if (index >= drawAngles.length || (set = ((PieData)this.mChart.getData()).getDataSetByIndex(indices[i].getDataSetIndex())) == null || !set.isHighlightEnabled()) continue;
            int entryCount = set.getEntryCount();
            int visibleAngleCount = 0;
            for (int j = 0; j < entryCount; ++j) {
                if (!(Math.abs(((PieEntry)set.getEntryForIndex(j)).getY()) > Utils.FLOAT_EPSILON)) continue;
                ++visibleAngleCount;
            }
            float angle = index == 0 ? 0.0f : absoluteAngles[index - 1] * phaseX;
            float sliceSpace = visibleAngleCount <= 1 ? 0.0f : set.getSliceSpace();
            float sliceAngle = drawAngles[index];
            float innerRadius = userInnerRadius;
            float shift = set.getSelectionShift();
            float highlightedRadius = radius + shift;
            highlightedCircleBox.set(this.mChart.getCircleBox());
            highlightedCircleBox.inset(-shift, -shift);
            boolean accountForSliceSpacing = sliceSpace > 0.0f && sliceAngle <= 180.0f;
            Integer highlightColor = set.getHighlightColor();
            if (highlightColor == null) {
                highlightColor = set.getColor(index);
            }
            this.mRenderPaint.setColor(highlightColor.intValue());
            float sliceSpaceAngleOuter = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * radius);
            float sliceSpaceAngleShifted = visibleAngleCount == 1 ? 0.0f : sliceSpace / ((float)Math.PI / 180 * highlightedRadius);
            float startAngleOuter = rotationAngle + (angle + sliceSpaceAngleOuter / 2.0f) * phaseY;
            float sweepAngleOuter = (sliceAngle - sliceSpaceAngleOuter) * phaseY;
            if (sweepAngleOuter < 0.0f) {
                sweepAngleOuter = 0.0f;
            }
            float startAngleShifted = rotationAngle + (angle + sliceSpaceAngleShifted / 2.0f) * phaseY;
            float sweepAngleShifted = (sliceAngle - sliceSpaceAngleShifted) * phaseY;
            if (sweepAngleShifted < 0.0f) {
                sweepAngleShifted = 0.0f;
            }
            this.mPathBuffer.reset();
            if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.FLOAT_EPSILON) {
                this.mPathBuffer.addCircle(center.x, center.y, highlightedRadius, Path.Direction.CW);
            } else {
                this.mPathBuffer.moveTo(center.x + highlightedRadius * (float)Math.cos(startAngleShifted * ((float)Math.PI / 180)), center.y + highlightedRadius * (float)Math.sin(startAngleShifted * ((float)Math.PI / 180)));
                this.mPathBuffer.arcTo(highlightedCircleBox, startAngleShifted, sweepAngleShifted);
            }
            float sliceSpaceRadius = 0.0f;
            if (accountForSliceSpacing) {
                sliceSpaceRadius = this.calculateMinimumRadiusForSpacedSlice(center, radius, sliceAngle * phaseY, center.x + radius * (float)Math.cos(startAngleOuter * ((float)Math.PI / 180)), center.y + radius * (float)Math.sin(startAngleOuter * ((float)Math.PI / 180)), startAngleOuter, sweepAngleOuter);
            }
            this.mInnerRectBuffer.set(center.x - innerRadius, center.y - innerRadius, center.x + innerRadius, center.y + innerRadius);
            if (drawInnerArc && (innerRadius > 0.0f || accountForSliceSpacing)) {
                if (accountForSliceSpacing) {
                    float minSpacedRadius = sliceSpaceRadius;
                    if (minSpacedRadius < 0.0f) {
                        minSpacedRadius = -minSpacedRadius;
                    }
                    innerRadius = Math.max(innerRadius, minSpacedRadius);
                }
                float sliceSpaceAngleInner = visibleAngleCount == 1 || innerRadius == 0.0f ? 0.0f : sliceSpace / ((float)Math.PI / 180 * innerRadius);
                float startAngleInner = rotationAngle + (angle + sliceSpaceAngleInner / 2.0f) * phaseY;
                float sweepAngleInner = (sliceAngle - sliceSpaceAngleInner) * phaseY;
                if (sweepAngleInner < 0.0f) {
                    sweepAngleInner = 0.0f;
                }
                float endAngleInner = startAngleInner + sweepAngleInner;
                if (sweepAngleOuter >= 360.0f && sweepAngleOuter % 360.0f <= Utils.FLOAT_EPSILON) {
                    this.mPathBuffer.addCircle(center.x, center.y, innerRadius, Path.Direction.CCW);
                } else {
                    this.mPathBuffer.lineTo(center.x + innerRadius * (float)Math.cos(endAngleInner * ((float)Math.PI / 180)), center.y + innerRadius * (float)Math.sin(endAngleInner * ((float)Math.PI / 180)));
                    this.mPathBuffer.arcTo(this.mInnerRectBuffer, endAngleInner, -sweepAngleInner);
                }
            } else if (sweepAngleOuter % 360.0f > Utils.FLOAT_EPSILON) {
                if (accountForSliceSpacing) {
                    float angleMiddle = startAngleOuter + sweepAngleOuter / 2.0f;
                    float arcEndPointX = center.x + sliceSpaceRadius * (float)Math.cos(angleMiddle * ((float)Math.PI / 180));
                    float arcEndPointY = center.y + sliceSpaceRadius * (float)Math.sin(angleMiddle * ((float)Math.PI / 180));
                    this.mPathBuffer.lineTo(arcEndPointX, arcEndPointY);
                } else {
                    this.mPathBuffer.lineTo(center.x, center.y);
                }
            }
            this.mPathBuffer.close();
            this.mBitmapCanvas.drawPath(this.mPathBuffer, this.mRenderPaint);
        }
        MPPointF.recycleInstance(center);
    }

    protected void drawRoundedSlices(Canvas c) {
        if (!this.mChart.isDrawRoundedSlicesEnabled()) {
            return;
        }
        IPieDataSet dataSet = ((PieData)this.mChart.getData()).getDataSet();
        if (!dataSet.isVisible()) {
            return;
        }
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        MPPointF center = this.mChart.getCenterCircleBox();
        float r = this.mChart.getRadius();
        float circleRadius = (r - r * this.mChart.getHoleRadius() / 100.0f) / 2.0f;
        float[] drawAngles = this.mChart.getDrawAngles();
        float angle = this.mChart.getRotationAngle();
        for (int j = 0; j < dataSet.getEntryCount(); ++j) {
            float sliceAngle = drawAngles[j];
            Object e = dataSet.getEntryForIndex(j);
            if (Math.abs(((BaseEntry)e).getY()) > Utils.FLOAT_EPSILON) {
                float x = (float)((double)(r - circleRadius) * Math.cos(Math.toRadians((angle + sliceAngle) * phaseY)) + (double)center.x);
                float y = (float)((double)(r - circleRadius) * Math.sin(Math.toRadians((angle + sliceAngle) * phaseY)) + (double)center.y);
                this.mRenderPaint.setColor(dataSet.getColor(j));
                this.mBitmapCanvas.drawCircle(x, y, circleRadius, this.mRenderPaint);
            }
            angle += sliceAngle * phaseX;
        }
        MPPointF.recycleInstance(center);
    }

    public void releaseBitmap() {
        if (this.mBitmapCanvas != null) {
            this.mBitmapCanvas.setBitmap(null);
            this.mBitmapCanvas = null;
        }
        if (this.mDrawBitmap != null) {
            Bitmap drawBitmap = (Bitmap)this.mDrawBitmap.get();
            if (drawBitmap != null) {
                drawBitmap.recycle();
            }
            this.mDrawBitmap.clear();
            this.mDrawBitmap = null;
        }
    }
}

