/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.buffer.HorizontalBarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class HorizontalBarChartRenderer
extends BarChartRenderer {
    private RectF mBarShadowRectBuffer = new RectF();

    public HorizontalBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
        this.mValuePaint.setTextAlign(Paint.Align.LEFT);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new HorizontalBarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new HorizontalBarBuffer(set.getEntryCount() * 4 * (set.isStacked() ? set.getStackSize() : 1), barData.getDataSetCount(), set.isStacked());
        }
    }

    @Override
    protected void drawDataSet(Canvas c, IBarDataSet dataSet, int index) {
        boolean isSingleColor;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mBarBorderPaint.setColor(dataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mShadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.mChart.getBarData();
            float barWidth = barData.getBarWidth();
            float barWidthHalf = barWidth / 2.0f;
            int count = Math.min((int)Math.ceil((float)dataSet.getEntryCount() * phaseX), dataSet.getEntryCount());
            for (int i = 0; i < count; ++i) {
                BarEntry e = (BarEntry)dataSet.getEntryForIndex(i);
                float x = e.getX();
                this.mBarShadowRectBuffer.top = x - barWidthHalf;
                this.mBarShadowRectBuffer.bottom = x + barWidthHalf;
                trans.rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.mViewPortHandler.isInBoundsTop(this.mBarShadowRectBuffer.bottom)) continue;
                if (!this.mViewPortHandler.isInBoundsBottom(this.mBarShadowRectBuffer.top)) break;
                this.mBarShadowRectBuffer.left = this.mViewPortHandler.contentLeft();
                this.mBarShadowRectBuffer.right = this.mViewPortHandler.contentRight();
                c.drawRect(this.mBarShadowRectBuffer, this.mShadowPaint);
            }
        }
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        boolean bl = isSingleColor = dataSet.getColors().size() == 1;
        if (isSingleColor) {
            this.mRenderPaint.setColor(dataSet.getColor());
        }
        for (int j = 0; j < buffer.size() && this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 3]); j += 4) {
            if (!this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) continue;
            if (!isSingleColor) {
                this.mRenderPaint.setColor(dataSet.getColor(j / 4));
            }
            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            if (!drawBorder) continue;
            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mBarBorderPaint);
        }
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(5.0f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                IBarDataSet dataSet = (IBarDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                this.applyValueTextStyle(dataSet);
                float halfTextHeight = (float)Utils.calcTextHeight(this.mValuePaint, "10") / 2.0f;
                IValueFormatter formatter = dataSet.getValueFormatter();
                BarBuffer buffer = this.mBarBuffers[i];
                float phaseY = this.mAnimator.getPhaseY();
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                if (!dataSet.isStacked()) {
                    int j = 0;
                    while ((float)j < (float)buffer.buffer.length * this.mAnimator.getPhaseX()) {
                        float y = (buffer.buffer[j + 1] + buffer.buffer[j + 3]) / 2.0f;
                        if (this.mViewPortHandler.isInBoundsTop(buffer.buffer[j + 1])) {
                            if (this.mViewPortHandler.isInBoundsX(buffer.buffer[j]) && this.mViewPortHandler.isInBoundsBottom(buffer.buffer[j + 1])) {
                                BarEntry entry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                                float val = entry.getY();
                                String formattedValue = formatter.getFormattedValue(val, entry, i, this.mViewPortHandler);
                                float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                                posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                if (isInverted) {
                                    posOffset = -posOffset - valueTextWidth;
                                    negOffset = -negOffset - valueTextWidth;
                                }
                                if (dataSet.isDrawValuesEnabled()) {
                                    this.drawValue(c, formattedValue, buffer.buffer[j + 2] + (val >= 0.0f ? posOffset : negOffset), y + halfTextHeight, dataSet.getValueTextColor(j / 2));
                                }
                                if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                    Drawable icon = entry.getIcon();
                                    float px = buffer.buffer[j + 2] + (val >= 0.0f ? posOffset : negOffset);
                                    float py = y;
                                    Utils.drawImage(c, icon, (int)(px += iconsOffset.x), (int)(py += iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                                }
                            }
                            j += 4;
                            continue;
                        }
                        break;
                    }
                } else {
                    Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()) {
                        BarEntry entry = (BarEntry)dataSet.getEntryForIndex(index);
                        int color = dataSet.getValueTextColor(index);
                        float[] vals = entry.getYVals();
                        if (vals == null) {
                            if (!this.mViewPortHandler.isInBoundsTop(buffer.buffer[bufferIndex + 1])) break;
                            if (!this.mViewPortHandler.isInBoundsX(buffer.buffer[bufferIndex]) || !this.mViewPortHandler.isInBoundsBottom(buffer.buffer[bufferIndex + 1])) continue;
                            float val = entry.getY();
                            String formattedValue = formatter.getFormattedValue(val, entry, i, this.mViewPortHandler);
                            float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                            posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                            float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                            if (isInverted) {
                                posOffset = -posOffset - valueTextWidth;
                                negOffset = -negOffset - valueTextWidth;
                            }
                            if (dataSet.isDrawValuesEnabled()) {
                                this.drawValue(c, formattedValue, buffer.buffer[bufferIndex + 2] + (entry.getY() >= 0.0f ? posOffset : negOffset), buffer.buffer[bufferIndex + 1] + halfTextHeight, color);
                            }
                            if (entry.getIcon() != null && dataSet.isDrawIconsEnabled()) {
                                Drawable icon = entry.getIcon();
                                float px = buffer.buffer[bufferIndex + 2] + (entry.getY() >= 0.0f ? posOffset : negOffset);
                                float py = buffer.buffer[bufferIndex + 1];
                                Utils.drawImage(c, icon, (int)(px += iconsOffset.x), (int)(py += iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                        } else {
                            float[] transformed = new float[vals.length * 2];
                            float posY = 0.0f;
                            float negY = -entry.getNegativeSum();
                            int k = 0;
                            int idx = 0;
                            while (k < transformed.length) {
                                float y;
                                float value = vals[idx];
                                if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                    y = value;
                                } else if (value >= 0.0f) {
                                    y = posY += value;
                                } else {
                                    y = negY;
                                    negY -= value;
                                }
                                transformed[k] = y * phaseY;
                                k += 2;
                                ++idx;
                            }
                            trans.pointValuesToPixel(transformed);
                            for (k = 0; k < transformed.length; k += 2) {
                                float val = vals[k / 2];
                                String formattedValue = formatter.getFormattedValue(val, entry, i, this.mViewPortHandler);
                                float valueTextWidth = Utils.calcTextWidth(this.mValuePaint, formattedValue);
                                posOffset = drawValueAboveBar ? valueOffsetPlus : -(valueTextWidth + valueOffsetPlus);
                                float f = negOffset = drawValueAboveBar ? -(valueTextWidth + valueOffsetPlus) : valueOffsetPlus;
                                if (isInverted) {
                                    posOffset = -posOffset - valueTextWidth;
                                    negOffset = -negOffset - valueTextWidth;
                                }
                                boolean drawBelow = val == 0.0f && negY == 0.0f && posY > 0.0f || val < 0.0f;
                                float x = transformed[k] + (drawBelow ? negOffset : posOffset);
                                float y = (buffer.buffer[bufferIndex + 1] + buffer.buffer[bufferIndex + 3]) / 2.0f;
                                if (!this.mViewPortHandler.isInBoundsTop(y)) break;
                                if (!this.mViewPortHandler.isInBoundsX(x) || !this.mViewPortHandler.isInBoundsBottom(y)) continue;
                                if (dataSet.isDrawValuesEnabled()) {
                                    this.drawValue(c, formattedValue, x, y + halfTextHeight, color);
                                }
                                if (entry.getIcon() == null || !dataSet.isDrawIconsEnabled()) continue;
                                Drawable icon = entry.getIcon();
                                Utils.drawImage(c, icon, (int)(x + iconsOffset.x), (int)(y + iconsOffset.y), icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
                            }
                        }
                        bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        ++index;
                    }
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    protected void drawValue(Canvas c, String valueText, float x, float y, int color) {
        this.mValuePaint.setColor(color);
        c.drawText(valueText, x, y, this.mValuePaint);
    }

    @Override
    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, Transformer trans) {
        float top = x - barWidthHalf;
        float bottom = x + barWidthHalf;
        float left = y1;
        float right = y2;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectToPixelPhaseHorizontal(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    protected void setHighlightDrawPos(Highlight high, RectF bar) {
        high.setDraw(bar.centerY(), bar.right);
    }

    @Override
    protected boolean isDrawingValuesAllowed(ChartInterface chart) {
        return (float)chart.getData().getEntryCount() < (float)chart.getMaxVisibleCount() * this.mViewPortHandler.getScaleY();
    }
}

