/*
 * Decompiled with CFR 0.152.
 */
package xyz.hanks.library.bang;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import xyz.hanks.library.R;
import xyz.hanks.library.bang.CircleView;
import xyz.hanks.library.bang.DotsView;

public class SmallBangView
extends FrameLayout {
    public static final Property<View, Float> SCALE = new FloatProperty<View>("scale"){

        public void setValue(View object, float value) {
            object.setScaleX(value);
            object.setScaleY(value);
        }

        public Float get(View object) {
            return Float.valueOf(object.getScaleY());
        }
    };
    private static AccelerateDecelerateInterpolator ACCELERATE_DECELERATE_INTERPOLATOR;
    private static OvershootInterpolator OVERSHOOT_INTERPOLATOR;
    private int circleStartColor;
    private int circleEndColor;
    private int animScaleFactor;
    private CircleView vCircle;
    private DotsView vDotsView;
    private View scaleView;
    private AnimatorSet animatorSet;
    private boolean init;

    public SmallBangView(Context context) {
        this(context, null);
    }

    public SmallBangView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmallBangView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.SmallBangView, defStyleAttr, 0);
        this.circleStartColor = array.getColor(R.styleable.SmallBangView_circle_start_color, CircleView.START_COLOR);
        this.circleEndColor = array.getColor(R.styleable.SmallBangView_circle_end_color, CircleView.END_COLOR);
        int dotPrimaryColor = array.getColor(R.styleable.SmallBangView_dots_primary_color, -2145656);
        int dotSecondaryColor = array.getColor(R.styleable.SmallBangView_dots_secondary_color, -3306504);
        this.animScaleFactor = array.getColor(R.styleable.SmallBangView_anim_scale_factor, 3);
        Boolean status = array.getBoolean(R.styleable.SmallBangView_liked, false);
        this.setSelected(status);
        array.recycle();
        OVERSHOOT_INTERPOLATOR = new OvershootInterpolator((float)this.animScaleFactor);
        ACCELERATE_DECELERATE_INTERPOLATOR = new AccelerateDecelerateInterpolator();
        FrameLayout.LayoutParams dotParams = new FrameLayout.LayoutParams(-1, -1);
        dotParams.gravity = 17;
        this.vDotsView = new DotsView(this.getContext());
        this.vDotsView.setLayoutParams((ViewGroup.LayoutParams)dotParams);
        this.vDotsView.setColors(new int[]{dotPrimaryColor, dotSecondaryColor, dotPrimaryColor, dotSecondaryColor});
        FrameLayout.LayoutParams circleParams = new FrameLayout.LayoutParams(-1, -1);
        circleParams.gravity = 17;
        this.vCircle = new CircleView(this.getContext());
        this.vCircle.setStartColor(this.circleStartColor);
        this.vCircle.setEndColor(this.circleEndColor);
        this.vCircle.setLayoutParams((ViewGroup.LayoutParams)circleParams);
        this.addView(this.vDotsView);
        this.addView(this.vCircle);
    }

    public void setCircleEndColor(int circleEndColor) {
        this.circleEndColor = circleEndColor;
        this.vCircle.setEndColor(circleEndColor);
    }

    public void setCircleStartColor(int circleStartColor) {
        this.circleStartColor = circleStartColor;
        this.vCircle.setStartColor(circleStartColor);
    }

    public void setDotColors(int[] colors) {
        this.vDotsView.setColors(colors);
    }

    public void setAnimScaleFactor(int animScaleFactor) {
        this.animScaleFactor = animScaleFactor;
        OVERSHOOT_INTERPOLATOR = new OvershootInterpolator((float)animScaleFactor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        if (childCount != 3) {
            throw new RuntimeException("must have one child view");
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.scaleView == null) {
            this.scaleView = this.findScaleView();
        }
        int iconSize = Math.min(this.scaleView.getMeasuredWidth(), this.scaleView.getMeasuredHeight());
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child instanceof CircleView) {
                this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)((int)((float)iconSize * 1.5f)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)((float)iconSize * 1.5f)), (int)0x40000000));
                continue;
            }
            if (!(child instanceof DotsView)) continue;
            this.measureChild(child, View.MeasureSpec.makeMeasureSpec((int)((int)((float)iconSize * 2.5f)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)((float)iconSize * 2.5f)), (int)0x40000000));
        }
        int width = sizeWidth;
        int height = sizeHeight;
        if (widthMode == Integer.MIN_VALUE || widthMode == 0) {
            width = (int)((float)iconSize * 2.5f);
        }
        if (heightMode == Integer.MIN_VALUE || heightMode == 0) {
            height = (int)((float)iconSize * 2.5f);
        }
        this.setMeasuredDimension(width, height);
    }

    private View findScaleView() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!this.isScaleView(child)) continue;
            return child;
        }
        throw new RuntimeException("must have one child in SmallBangView");
    }

    private boolean isScaleView(View child) {
        return child != null && !(child instanceof DotsView) && !(child instanceof CircleView);
    }

    public void stopAnimation() {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        this.scaleView.setScaleX(1.0f);
        this.scaleView.setScaleY(1.0f);
        this.vCircle.setProgress(0.0f);
        this.vDotsView.setCurrentProgress(0.0f);
    }

    public void likeAnimation() {
        this.likeAnimation(null);
    }

    public void likeAnimation(Animator.AnimatorListener listener) {
        if (this.animatorSet != null) {
            this.animatorSet.cancel();
        }
        this.scaleView.setScaleX(0.0f);
        this.scaleView.setScaleY(0.0f);
        this.vCircle.setProgress(0.0f);
        this.vDotsView.setCurrentProgress(0.0f);
        this.animatorSet = new AnimatorSet();
        ObjectAnimator outerCircleAnimator = ObjectAnimator.ofFloat((Object)((Object)this.vCircle), CircleView.OUTER_CIRCLE_RADIUS_PROGRESS, (float[])new float[]{0.1f, 1.0f});
        outerCircleAnimator.setDuration(250L);
        ObjectAnimator starScaleAnimator = ObjectAnimator.ofFloat((Object)this.scaleView, SCALE, (float[])new float[]{0.2f, 1.0f});
        starScaleAnimator.setDuration(250L);
        starScaleAnimator.setStartDelay(250L);
        starScaleAnimator.setInterpolator((TimeInterpolator)OVERSHOOT_INTERPOLATOR);
        ObjectAnimator dotsAnimator = ObjectAnimator.ofFloat((Object)((Object)this.vDotsView), DotsView.DOTS_PROGRESS, (float[])new float[]{0.0f, 1.0f});
        dotsAnimator.setDuration(800L);
        dotsAnimator.setStartDelay(50L);
        dotsAnimator.setInterpolator((TimeInterpolator)ACCELERATE_DECELERATE_INTERPOLATOR);
        this.animatorSet.playTogether(new Animator[]{outerCircleAnimator, starScaleAnimator, dotsAnimator});
        this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                SmallBangView.this.vCircle.setProgress(0.0f);
                SmallBangView.this.vDotsView.setCurrentProgress(0.0f);
                SmallBangView.this.scaleView.setScaleX(1.0f);
                SmallBangView.this.scaleView.setScaleY(1.0f);
            }
        });
        this.animatorSet.start();
        if (listener != null) {
            this.animatorSet.addListener(listener);
        }
    }
}

