/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker.util;

public class PersianHelper {
    private static final char[] persianNumbers = new char[]{'\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9'};
    private static final char[] englishNumbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String toPersianNumber(String text) {
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if ('0' <= c && c <= '9') {
                int number = Integer.parseInt(String.valueOf(c));
                out.append(persianNumbers[number]);
                continue;
            }
            if (c == '\u066b') {
                out.append('\u060c');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String toEnglishNumber(String text) {
        if (text.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            int charPos = PersianHelper.hasCharachter(c);
            if (charPos != -1) {
                out.append(englishNumbers[charPos]);
                continue;
            }
            if (c == '\u060c') {
                out.append('\u066b');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static int hasCharachter(char c) {
        for (int i = 0; i < persianNumbers.length; ++i) {
            if (c != persianNumbers[i]) continue;
            return i;
        }
        return -1;
    }
}

