/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker.util;

import ir.hamsaa.persiandatepicker.date.PersianDateImpl;
import ir.hamsaa.persiandatepicker.util.PersianCalendarConstants;
import ir.hamsaa.persiandatepicker.util.PersianCalendarUtils;
import ir.hamsaa.persiandatepicker.util.PersianDateParser;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

@Deprecated
public class PersianCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = 5541422440580682494L;
    private int persianYear;
    private int persianMonth;
    private int persianDay;
    private String delimiter = "/";
    private static int[] gregorianDaysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] persianDaysInMonth = new int[]{31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 29};

    private long convertToMilis(long julianDate) {
        return -210866803200000L + julianDate * 86400000L + PersianCalendarUtils.ceil(this.getTimeInMillis() - -210866803200000L, 8.64E7);
    }

    public PersianCalendar(long millis) {
        this.setTimeInMillis(millis);
    }

    public PersianCalendar() {
        super(TimeZone.getDefault(), Locale.getDefault());
    }

    protected void calculatePersianDate() {
        YearMonthDay persianYearMonthDay = PersianCalendar.gregorianToJalali(new YearMonthDay(this.get(1), this.get(2), this.get(5)));
        this.persianYear = persianYearMonthDay.year;
        this.persianMonth = persianYearMonthDay.month;
        this.persianDay = persianYearMonthDay.day;
    }

    public boolean isPersianLeapYear() {
        return PersianDateImpl.isLeapYear(this.persianYear);
    }

    public void setPersianDate(int persianYear, int persianMonth, int persianDay) {
        this.persianYear = persianYear;
        this.persianMonth = persianMonth;
        this.persianDay = persianDay;
        YearMonthDay gregorianYearMonthDay = PersianCalendar.persianToGregorian(new YearMonthDay(persianYear, this.persianMonth - 1, persianDay));
        this.set(gregorianYearMonthDay.year, gregorianYearMonthDay.month, gregorianYearMonthDay.day);
    }

    public int getPersianYear() {
        return this.persianYear;
    }

    public int getPersianMonth() {
        return this.persianMonth + 1;
    }

    public String getPersianMonthName() {
        return PersianCalendarConstants.persianMonthNames[this.persianMonth];
    }

    public int getPersianDay() {
        return this.persianDay;
    }

    public String getPersianWeekDayName() {
        switch (this.get(7)) {
            case 7: {
                return PersianCalendarConstants.persianWeekDays[0];
            }
            case 1: {
                return PersianCalendarConstants.persianWeekDays[1];
            }
            case 2: {
                return PersianCalendarConstants.persianWeekDays[2];
            }
            case 3: {
                return PersianCalendarConstants.persianWeekDays[3];
            }
            case 4: {
                return PersianCalendarConstants.persianWeekDays[4];
            }
            case 5: {
                return PersianCalendarConstants.persianWeekDays[5];
            }
        }
        return PersianCalendarConstants.persianWeekDays[6];
    }

    public String getPersianLongDate() {
        return this.getPersianWeekDayName() + "  " + this.persianDay + "  " + this.getPersianMonthName() + "  " + this.persianYear;
    }

    public String getPersianLongDateAndTime() {
        return this.getPersianLongDate() + " \u0633\u0627\u0639\u062a " + this.get(11) + ":" + this.get(12) + ":" + this.get(13);
    }

    public String getPersianShortDate() {
        return "" + this.formatToMilitary(this.persianYear) + this.delimiter + this.formatToMilitary(this.getPersianMonth()) + this.delimiter + this.formatToMilitary(this.persianDay);
    }

    public String getPersianShortDateTime() {
        return "" + this.formatToMilitary(this.persianYear) + this.delimiter + this.formatToMilitary(this.getPersianMonth()) + this.delimiter + this.formatToMilitary(this.persianDay) + " " + this.formatToMilitary(this.get(11)) + ":" + this.formatToMilitary(this.get(12)) + ":" + this.formatToMilitary(this.get(13));
    }

    private String formatToMilitary(int i) {
        return i < 9 ? "0" + i : String.valueOf(i);
    }

    public void addPersianDate(int field, int amount) {
        if (amount == 0) {
            return;
        }
        if (field < 0 || field >= 15) {
            throw new IllegalArgumentException();
        }
        if (field == 1) {
            this.setPersianDate(this.persianYear + amount, this.getPersianMonth(), this.persianDay);
            return;
        }
        if (field == 2) {
            this.setPersianDate(this.persianYear + (this.getPersianMonth() + amount) / 12, (this.getPersianMonth() + amount) % 12, this.persianDay);
            return;
        }
        this.add(field, amount);
        this.calculatePersianDate();
    }

    public void parse(String dateString) {
        PersianCalendar p = new PersianDateParser(dateString, this.delimiter).getPersianDate();
        this.setPersianDate(p.getPersianYear(), p.getPersianMonth(), p.getPersianDay());
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String toString() {
        String str = super.toString();
        return str.substring(0, str.length() - 1) + ",PersianDate=" + this.getPersianShortDate() + "]";
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void set(int field, int value) {
        super.set(field, value);
        this.calculatePersianDate();
    }

    @Override
    public void setTimeInMillis(long millis) {
        super.setTimeInMillis(millis);
        this.calculatePersianDate();
    }

    @Override
    public void setTimeZone(TimeZone zone) {
        super.setTimeZone(zone);
        this.calculatePersianDate();
    }

    private static YearMonthDay gregorianToJalali(YearMonthDay gregorian) {
        int i;
        if (gregorian.getMonth() > 11 || gregorian.getMonth() < -11) {
            throw new IllegalArgumentException();
        }
        gregorian.setYear(gregorian.getYear() - 1600);
        gregorian.setDay(gregorian.getDay() - 1);
        int gregorianDayNo = 365 * gregorian.getYear() + (int)Math.floor((gregorian.getYear() + 3) / 4) - (int)Math.floor((gregorian.getYear() + 99) / 100) + (int)Math.floor((gregorian.getYear() + 399) / 400);
        for (i = 0; i < gregorian.getMonth(); ++i) {
            gregorianDayNo += gregorianDaysInMonth[i];
        }
        if (gregorian.getMonth() > 1 && (gregorian.getYear() % 4 == 0 && gregorian.getYear() % 100 != 0 || gregorian.getYear() % 400 == 0)) {
            ++gregorianDayNo;
        }
        int persianDayNo = (gregorianDayNo += gregorian.getDay()) - 79;
        int persianNP = (int)Math.floor(persianDayNo / 12053);
        int persianYear = 979 + 33 * persianNP + 4 * ((persianDayNo %= 12053) / 1461);
        if ((persianDayNo %= 1461) >= 366) {
            persianYear += (int)Math.floor((persianDayNo - 1) / 365);
            persianDayNo = (persianDayNo - 1) % 365;
        }
        for (i = 0; i < 11 && persianDayNo >= persianDaysInMonth[i]; persianDayNo -= persianDaysInMonth[i], ++i) {
        }
        int persianMonth = i;
        int persianDay = persianDayNo + 1;
        return new YearMonthDay(persianYear, persianMonth, persianDay);
    }

    private static YearMonthDay persianToGregorian(YearMonthDay persian) {
        int i;
        if (persian.getMonth() > 11 || persian.getMonth() < -11) {
            throw new IllegalArgumentException();
        }
        persian.setYear(persian.getYear() - 979);
        persian.setDay(persian.getDay() - 1);
        int persianDayNo = 365 * persian.getYear() + persian.getYear() / 33 * 8 + (int)Math.floor((persian.getYear() % 33 + 3) / 4);
        for (i = 0; i < persian.getMonth(); ++i) {
            persianDayNo += persianDaysInMonth[i];
        }
        int gregorianDayNo = (persianDayNo += persian.getDay()) + 79;
        int gregorianYear = 1600 + 400 * (int)Math.floor(gregorianDayNo / 146097);
        boolean leap = true;
        if ((gregorianDayNo %= 146097) >= 36525) {
            gregorianYear += 100 * (int)Math.floor(--gregorianDayNo / 36524);
            if ((gregorianDayNo %= 36524) >= 365) {
                ++gregorianDayNo;
            } else {
                leap = false;
            }
        }
        gregorianYear += 4 * (int)Math.floor(gregorianDayNo / 1461);
        if ((gregorianDayNo %= 1461) >= 366) {
            leap = false;
            gregorianYear += (int)Math.floor(--gregorianDayNo / 365);
            gregorianDayNo %= 365;
        }
        i = 0;
        while (gregorianDayNo >= gregorianDaysInMonth[i] + (i == 1 && leap ? i : 0)) {
            gregorianDayNo -= gregorianDaysInMonth[i] + (i == 1 && leap ? i : 0);
            ++i;
        }
        int gregorianMonth = i;
        int gregorianDay = gregorianDayNo + 1;
        return new YearMonthDay(gregorianYear, gregorianMonth, gregorianDay);
    }

    static class YearMonthDay {
        private int year;
        private int month;
        private int day;

        YearMonthDay(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int date) {
            this.day = date;
        }

        public String toString() {
            return this.getYear() + "/" + this.getMonth() + "/" + this.getDay();
        }
    }
}

