/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import ir.hamsaa.persiandatepicker.R;
import ir.hamsaa.persiandatepicker.api.PersianPickerDate;
import ir.hamsaa.persiandatepicker.date.PersianDateImpl;
import ir.hamsaa.persiandatepicker.util.PersianCalendar;
import ir.hamsaa.persiandatepicker.util.PersianCalendarConstants;
import ir.hamsaa.persiandatepicker.util.PersianCalendarUtils;
import ir.hamsaa.persiandatepicker.util.PersianHelper;
import ir.hamsaa.persiandatepicker.view.PersianNumberPicker;
import java.lang.reflect.Field;
import java.util.Date;

class PersianDatePicker
extends LinearLayout {
    private PersianPickerDate persianDate;
    private int selectedMonth;
    private int selectedYear;
    private int selectedDay;
    private boolean displayMonthNames;
    private OnDateChangedListener mListener;
    private final PersianNumberPicker yearNumberPicker;
    private final PersianNumberPicker monthNumberPicker;
    private final PersianNumberPicker dayNumberPicker;
    private int minYear;
    private int maxYear;
    private int maxMonth;
    private int maxDay;
    private boolean displayDescription;
    private final TextView descriptionTextView;
    private Typeface typeFace;
    private int dividerColor;
    private int yearRange;
    NumberPicker.OnValueChangeListener dateChangeListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            int year = PersianDatePicker.this.yearNumberPicker.getValue();
            boolean isLeapYear = PersianCalendarUtils.isPersianLeapYear(year);
            int month = PersianDatePicker.this.monthNumberPicker.getValue();
            int day = PersianDatePicker.this.dayNumberPicker.getValue();
            if (month < 7) {
                PersianDatePicker.this.dayNumberPicker.setMinValue(1);
                PersianDatePicker.this.setDayNumberPickerMaxValue(31);
            } else if (month < 12) {
                if (day == 31) {
                    PersianDatePicker.this.dayNumberPicker.setValue(30);
                }
                PersianDatePicker.this.dayNumberPicker.setMinValue(1);
                PersianDatePicker.this.setDayNumberPickerMaxValue(30);
            } else if (month == 12) {
                if (isLeapYear) {
                    if (day == 31) {
                        PersianDatePicker.this.dayNumberPicker.setValue(30);
                    }
                    PersianDatePicker.this.dayNumberPicker.setMinValue(1);
                    PersianDatePicker.this.setDayNumberPickerMaxValue(30);
                } else {
                    if (day > 29) {
                        PersianDatePicker.this.dayNumberPicker.setValue(29);
                    }
                    PersianDatePicker.this.dayNumberPicker.setMinValue(1);
                    PersianDatePicker.this.setDayNumberPickerMaxValue(29);
                }
            }
            PersianDatePicker.this.persianDate.setDate(year, month, day);
            if (PersianDatePicker.this.displayDescription) {
                PersianDatePicker.this.descriptionTextView.setText((CharSequence)PersianDatePicker.this.persianDate.getPersianLongDate());
            }
            if (PersianDatePicker.this.mListener != null) {
                PersianDatePicker.this.mListener.onDateChanged(year, month, day);
            }
        }
    };

    public PersianDatePicker(Context context) {
        this(context, null, -1);
    }

    public PersianDatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public PersianDatePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.sl_persian_date_picker, (ViewGroup)this);
        this.yearNumberPicker = (PersianNumberPicker)view.findViewById(R.id.yearNumberPicker);
        this.monthNumberPicker = (PersianNumberPicker)view.findViewById(R.id.monthNumberPicker);
        this.dayNumberPicker = (PersianNumberPicker)view.findViewById(R.id.dayNumberPicker);
        this.descriptionTextView = (TextView)view.findViewById(R.id.descriptionTextView);
        this.yearNumberPicker.setFormatter(new NumberPicker.Formatter(){

            public String format(int i) {
                return PersianHelper.toPersianNumber(i + "");
            }
        });
        this.monthNumberPicker.setFormatter(new NumberPicker.Formatter(){

            public String format(int i) {
                return PersianHelper.toPersianNumber(i + "");
            }
        });
        this.dayNumberPicker.setFormatter(new NumberPicker.Formatter(){

            public String format(int i) {
                return PersianHelper.toPersianNumber(i + "");
            }
        });
        this.persianDate = new PersianDateImpl();
        this.updateVariablesFromXml(context, attrs);
        this.updateViewData();
    }

    private void updateVariablesFromXml(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PersianDatePicker, 0, 0);
        this.yearRange = a.getInteger(R.styleable.PersianDatePicker_yearRange, 10);
        this.minYear = a.getInt(R.styleable.PersianDatePicker_minYear, this.persianDate.getPersianYear() - this.yearRange);
        this.maxYear = a.getInt(R.styleable.PersianDatePicker_maxYear, this.persianDate.getPersianYear() + this.yearRange);
        this.displayMonthNames = a.getBoolean(R.styleable.PersianDatePicker_displayMonthNames, false);
        this.displayDescription = a.getBoolean(R.styleable.PersianDatePicker_displayDescription, false);
        this.selectedDay = a.getInteger(R.styleable.PersianDatePicker_selectedDay, this.persianDate.getPersianDay());
        this.selectedYear = a.getInt(R.styleable.PersianDatePicker_selectedYear, this.persianDate.getPersianYear());
        this.selectedMonth = a.getInteger(R.styleable.PersianDatePicker_selectedMonth, this.persianDate.getPersianMonth());
        if (this.minYear > this.selectedYear) {
            this.minYear = this.selectedYear - this.yearRange;
        }
        if (this.maxYear < this.selectedYear) {
            this.maxYear = this.selectedYear + this.yearRange;
        }
        a.recycle();
    }

    public void setBackgroundColor(@ColorInt int color) {
        this.yearNumberPicker.setBackgroundColor(color);
        this.monthNumberPicker.setBackgroundColor(color);
        this.dayNumberPicker.setBackgroundColor(color);
    }

    public void setBackgroundDrawable(@DrawableRes int drawableBg) {
        this.yearNumberPicker.setBackgroundResource(drawableBg);
        this.monthNumberPicker.setBackgroundResource(drawableBg);
        this.dayNumberPicker.setBackgroundResource(drawableBg);
    }

    public void setMaxYear(int maxYear) {
        this.maxYear = maxYear;
        this.updateViewData();
    }

    public void setMaxMonth(int maxMonth) {
        this.maxMonth = maxMonth;
        this.updateViewData();
    }

    public void setMaxDay(int maxDay) {
        this.maxDay = maxDay;
        this.updateViewData();
    }

    public void setMinYear(int minYear) {
        this.minYear = minYear;
        this.updateViewData();
    }

    public void setTypeFace(Typeface typeFace) {
        this.typeFace = typeFace;
        this.updateViewData();
    }

    public void setDividerColor(@ColorInt int color) {
        this.dividerColor = color;
        this.updateViewData();
    }

    private void setDividerColor(NumberPicker picker, int color) {
        Field[] pickerFields;
        for (Field pf : pickerFields = NumberPicker.class.getDeclaredFields()) {
            if (!pf.getName().equals("mSelectionDivider")) continue;
            pf.setAccessible(true);
            try {
                ColorDrawable colorDrawable = new ColorDrawable(color);
                pf.set(picker, colorDrawable);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            break;
        }
    }

    private void updateViewData() {
        if (this.typeFace != null) {
            this.yearNumberPicker.setTypeFace(this.typeFace);
            this.monthNumberPicker.setTypeFace(this.typeFace);
            this.dayNumberPicker.setTypeFace(this.typeFace);
        }
        if (this.dividerColor > 0) {
            this.setDividerColor(this.yearNumberPicker, this.dividerColor);
            this.setDividerColor(this.monthNumberPicker, this.dividerColor);
            this.setDividerColor(this.dayNumberPicker, this.dividerColor);
        }
        this.yearNumberPicker.setMinValue(this.minYear);
        this.yearNumberPicker.setMaxValue(this.maxYear);
        if (this.selectedYear > this.maxYear) {
            this.selectedYear = this.maxYear;
        }
        if (this.selectedYear < this.minYear) {
            this.selectedYear = this.minYear;
        }
        this.yearNumberPicker.setValue(this.selectedYear);
        this.yearNumberPicker.setOnValueChangedListener(this.dateChangeListener);
        this.monthNumberPicker.setMinValue(1);
        this.monthNumberPicker.setMaxValue(this.maxMonth > 0 ? this.maxMonth : 12);
        if (this.displayMonthNames) {
            this.monthNumberPicker.setDisplayedValues(PersianCalendarConstants.persianMonthNames);
        }
        if (this.selectedMonth < 1 || this.selectedMonth > 12) {
            throw new IllegalArgumentException(String.format("Selected month (%d) must be between 1 and 12", this.selectedMonth));
        }
        this.monthNumberPicker.setValue(this.selectedMonth);
        this.monthNumberPicker.setOnValueChangedListener(this.dateChangeListener);
        this.dayNumberPicker.setMinValue(1);
        this.setDayNumberPickerMaxValue(31);
        if (this.selectedDay > 31 || this.selectedDay < 1) {
            throw new IllegalArgumentException(String.format("Selected day (%d) must be between 1 and 31", this.selectedDay));
        }
        if (this.selectedMonth > 6 && this.selectedMonth < 12 && this.selectedDay == 31) {
            this.selectedDay = 30;
        } else {
            boolean isLeapYear = PersianCalendarUtils.isPersianLeapYear(this.selectedYear);
            if (isLeapYear && this.selectedDay == 31) {
                this.selectedDay = 30;
            } else if (this.selectedDay > 29) {
                this.selectedDay = 29;
            }
        }
        this.dayNumberPicker.setValue(this.selectedDay);
        this.dayNumberPicker.setOnValueChangedListener(this.dateChangeListener);
        if (this.displayDescription) {
            this.descriptionTextView.setVisibility(0);
            this.descriptionTextView.setText((CharSequence)this.persianDate.getPersianLongDate());
        }
    }

    public void setDayNumberPickerMaxValue(int value) {
        if (this.monthNumberPicker.getValue() == this.maxMonth) {
            if (this.maxDay > 0) {
                this.dayNumberPicker.setMaxValue(this.maxDay);
            } else {
                this.dayNumberPicker.setMaxValue(value);
            }
        } else {
            this.dayNumberPicker.setMaxValue(value);
        }
    }

    public void setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mListener = onDateChangedListener;
    }

    public Date getDisplayDate() {
        return this.persianDate.getGregorianDate();
    }

    public void setDisplayDate(Date displayDate) {
        this.persianDate.setDate(displayDate);
        this.setDisplayPersianDate(this.persianDate);
    }

    @Deprecated
    public PersianCalendar getDisplayPersianDate() {
        PersianCalendar persianCalendar = new PersianCalendar();
        persianCalendar.setPersianDate(this.persianDate.getPersianYear(), this.persianDate.getPersianMonth(), this.persianDate.getPersianDay());
        return persianCalendar;
    }

    public PersianPickerDate getPersianDate() {
        return this.persianDate;
    }

    @Deprecated
    public void setDisplayPersianDate(PersianCalendar displayPersianDate) {
        PersianDateImpl persianPickerDate = new PersianDateImpl();
        persianPickerDate.setDate(displayPersianDate.getPersianYear(), displayPersianDate.getPersianMonth(), displayPersianDate.getPersianDay());
        this.setDisplayPersianDate(persianPickerDate);
    }

    public void setDisplayPersianDate(PersianPickerDate displayPersianDate) {
        this.persianDate.setDate(displayPersianDate.getTimestamp());
        final int year = this.persianDate.getPersianYear();
        final int month = this.persianDate.getPersianMonth();
        final int day = this.persianDate.getPersianDay();
        this.selectedYear = year;
        this.selectedMonth = month;
        this.selectedDay = day;
        if (this.minYear > this.selectedYear) {
            this.minYear = this.selectedYear - this.yearRange;
            this.yearNumberPicker.setMinValue(this.minYear);
        }
        if (this.maxYear < this.selectedYear) {
            this.maxYear = this.selectedYear + this.yearRange;
            this.yearNumberPicker.setMaxValue(this.maxYear);
        }
        this.yearNumberPicker.post(new Runnable(){

            @Override
            public void run() {
                PersianDatePicker.this.yearNumberPicker.setValue(year);
            }
        });
        this.monthNumberPicker.post(new Runnable(){

            @Override
            public void run() {
                PersianDatePicker.this.monthNumberPicker.setValue(month);
            }
        });
        this.dayNumberPicker.post(new Runnable(){

            @Override
            public void run() {
                PersianDatePicker.this.dayNumberPicker.setValue(day);
            }
        });
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.datetime = this.getDisplayDate().getTime();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setDisplayDate(new Date(ss.datetime));
    }

    static class SavedState
    extends View.BaseSavedState {
        long datetime;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.datetime = in.readLong();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.datetime);
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(int var1, int var2, int var3);
    }
}

