/*
 * Decompiled with CFR 0.152.
 */
package ir.hamsaa.persiandatepicker.util;

public class PersianHelper {
    private static char[] persianNumbers = new char[]{'\u06f0', '\u06f1', '\u06f2', '\u06f3', '\u06f4', '\u06f5', '\u06f6', '\u06f7', '\u06f8', '\u06f9'};
    private static char[] englishNumbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static String toPersianNumber(String text) {
        if (text.isEmpty()) {
            return "";
        }
        String out = "";
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if ('0' <= c && c <= '9') {
                int number = Integer.parseInt(String.valueOf(c));
                out = out + persianNumbers[number];
                continue;
            }
            out = c == '\u066b' ? out + '\u060c' : out + c;
        }
        return out;
    }

    public static String toEnglishNumber(String text) {
        if (text.isEmpty()) {
            return "";
        }
        String out = "";
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            int charPos = PersianHelper.hasCharachter(c);
            out = charPos != -1 ? out + englishNumbers[charPos] : (c == '\u060c' ? out + '\u066b' : out + c);
        }
        return out;
    }

    private static int hasCharachter(char c) {
        for (int i = 0; i < persianNumbers.length; ++i) {
            if (c != persianNumbers[i]) continue;
            return i;
        }
        return -1;
    }
}

