/*
 * Decompiled with CFR 0.152.
 */
package com.github.hakkazuu.slotsinputview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.github.hakkazuu.slotsinputview.R;
import java.util.ArrayList;

public class SlotsInputView
extends LinearLayout {
    private View mRoot;
    private LinearLayout mLayout;
    private int mLength;
    private int mSlotLength = 1;
    private int mInputType;
    private float mTextSize;
    @ColorRes
    private int mTextColor;
    @ColorRes
    private int mHintColor;
    @ColorRes
    private int mUnderlineColor;
    private boolean mIsEnabled;
    private String mHint;
    private ArrayList<Slot> mSlotList = new ArrayList();
    private OnSlotsTextChangedListener mOnSlotsTextChangedListener = null;
    private static final int DEFAULT_LENGTH = 4;
    private static final int DEFAULT_INPUT_TYPE = 2;
    private static final int DEFAULT_SLOT_LENGTH = 1;
    private static final float DEFAULT_TEXT_SIZE = 20.0f;
    @ColorRes
    private static final int DEFAULT_TEXT_COLOR = 17170444;
    @ColorRes
    private static final int DEFAULT_HINT_COLOR = 0x1060000;
    @ColorRes
    private static final int DEFAULT_UNDERLINE_COLOR = 17170444;
    private static final boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_HINT = "****";

    public SlotsInputView(Context context) {
        super(context);
        this.init(context, null);
    }

    public SlotsInputView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SlotsInputView, 0, 0);
        this.init(context, typedArray);
    }

    public SlotsInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SlotsInputView, 0, 0);
        this.init(context, typedArray);
    }

    public String getText() {
        String text = "";
        for (Slot slot : this.mSlotList) {
            if (slot.mValue == null) continue;
            text = text + slot.mValue;
        }
        return text;
    }

    public void setLength(int length) {
        this.mLength = length;
        this.createSlots();
    }

    public int getLength() {
        return this.mLength;
    }

    public void setSlotTextSize(float textSize) {
        this.mTextSize = textSize;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setTextSize(this.mTextSize);
        }
    }

    public void setSlotTextColor(@ColorRes int color2) {
        this.mTextColor = color2;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setTextColor(this.getResources().getColorStateList(color2));
        }
    }

    public void setHintTextColor(@ColorRes int color2) {
        this.mHintColor = color2;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setHintTextColor(this.getResources().getColorStateList(color2));
        }
    }

    public void setUnderlineColor(@ColorRes int color2) {
        this.mUnderlineColor = color2;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setBackgroundTintList(this.getResources().getColorStateList(color2));
        }
    }

    public void setHint(String hint) {
        this.mHint = hint;
        for (Slot slot : this.mSlotList) {
            if (this.mHint.length() > slot.mSlotIndex) {
                slot.mSlot.setHint((CharSequence)String.valueOf(this.mHint.charAt(slot.mSlotIndex)));
                continue;
            }
            slot.mSlot.setHint(null);
        }
    }

    public void setInputType(int inputType) {
        this.mInputType = inputType;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setInputType(this.mInputType);
        }
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.mIsEnabled = isEnabled;
        for (Slot slot : this.mSlotList) {
            slot.mSlot.setEnabled(this.mIsEnabled);
            slot.mSlot.setTextColor(this.getResources().getColorStateList(this.mIsEnabled ? this.mTextColor : this.mHintColor));
        }
    }

    public void clear() {
        this.createSlots();
        this.checkSlots();
    }

    private void init(Context context, TypedArray typedArray) {
        this.mRoot = SlotsInputView.inflate((Context)context, (int)R.layout.view_slots_input, (ViewGroup)this);
        this.mLayout = (LinearLayout)this.mRoot.findViewById(R.id.view_slots_input_layout);
        if (typedArray != null) {
            this.initAttributes(typedArray);
        }
        this.createSlots();
    }

    private void initAttributes(@NonNull TypedArray typedArray) {
        this.mLength = typedArray.getInteger(R.styleable.SlotsInputView_siv_length, 4);
        this.mIsEnabled = typedArray.getBoolean(R.styleable.SlotsInputView_siv_enabled, true);
        switch (typedArray.getInt(R.styleable.SlotsInputView_siv_input_type, 0)) {
            case 0: {
                this.mInputType = 2;
                break;
            }
            case 1: {
                this.mInputType = 18;
                break;
            }
            case 2: {
                this.mInputType = 1;
                break;
            }
            case 3: {
                this.mInputType = 129;
                break;
            }
            default: {
                this.mInputType = 2;
            }
        }
        this.mTextSize = typedArray.getDimension(R.styleable.SlotsInputView_siv_text_size, 20.0f);
        this.mTextColor = typedArray.getResourceId(R.styleable.SlotsInputView_siv_text_color, 17170444);
        String hintAttr = typedArray.getString(R.styleable.SlotsInputView_siv_hint);
        this.mHint = hintAttr == null ? DEFAULT_HINT : hintAttr;
        this.mHintColor = typedArray.getResourceId(R.styleable.SlotsInputView_siv_hint_color, 0x1060000);
        this.mUnderlineColor = typedArray.getResourceId(R.styleable.SlotsInputView_siv_underline_color, 17170444);
    }

    private void createSlots() {
        this.mLayout.removeAllViews();
        this.mSlotList.clear();
        for (int i = 0; i < this.mLength; ++i) {
            Slot slot = new Slot(new EditText(this.mRoot.getContext()), i);
            this.mLayout.addView((View)slot.mSlot);
            this.mSlotList.add(slot);
        }
    }

    private void checkSlots() {
        boolean isAllFilled = true;
        String text = "";
        ArrayList<String> textArrayList = new ArrayList<String>();
        for (Slot slot : this.mSlotList) {
            slot.mValue = slot.mSlot.getText().toString();
            if (slot.mValue != null) {
                text = text + slot.mValue;
                textArrayList.add(slot.mValue);
            }
            if (slot.mIsFilled) continue;
            isAllFilled = false;
        }
        if (this.mOnSlotsTextChangedListener != null) {
            this.mOnSlotsTextChangedListener.onSlotsTextChanged(text, textArrayList, isAllFilled);
        }
    }

    private void requestFocusOnNextSlot(Slot currentSlot) {
        if (this.mSlotList.indexOf(currentSlot) != this.mLength - 1) {
            this.mSlotList.get(this.mSlotList.indexOf(currentSlot) + 1).mSlot.requestFocus();
        } else {
            try {
                InputMethodManager imm = (InputMethodManager)this.mRoot.getContext().getSystemService("input_method");
                imm.hideSoftInputFromWindow(this.mRoot.getWindowToken(), 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            currentSlot.mSlot.clearFocus();
            this.mLayout.requestFocus();
        }
    }

    private void requestFocusOnPrevSlot(Slot currentSlot) {
        if (this.mSlotList.indexOf(currentSlot) != 0) {
            this.mSlotList.get(this.mSlotList.indexOf(currentSlot) - 1).mSlot.requestFocus();
        } else {
            try {
                InputMethodManager imm = (InputMethodManager)this.mRoot.getContext().getSystemService("input_method");
                imm.hideSoftInputFromWindow(this.mRoot.getWindowToken(), 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mLayout.getFocusedChild().clearFocus();
        }
    }

    public void setOnSlotsTextChangedListener(OnSlotsTextChangedListener listener) {
        this.mOnSlotsTextChangedListener = listener;
    }

    private class Slot {
        private EditText mSlot;
        private int mSlotIndex;
        private boolean mIsFilled;
        private String mValue;

        Slot(EditText slot, int slotIndex) {
            this.mSlot = slot;
            this.mSlotIndex = slotIndex;
            this.mSlot.setEnabled(SlotsInputView.this.mIsEnabled);
            this.mSlot.setTextColor(SlotsInputView.this.getResources().getColorStateList(SlotsInputView.this.mIsEnabled ? SlotsInputView.this.mTextColor : SlotsInputView.this.mHintColor));
            this.mSlot.setTextSize(0, SlotsInputView.this.mTextSize);
            this.mSlot.setTextAlignment(4);
            this.mSlot.setEms(SlotsInputView.this.mSlotLength);
            this.mSlot.setTypeface(Typeface.MONOSPACE);
            this.mSlot.setSelectAllOnFocus(true);
            this.mSlot.setBackgroundTintList(SlotsInputView.this.getResources().getColorStateList(SlotsInputView.this.mUnderlineColor));
            this.mSlot.setHintTextColor(SlotsInputView.this.getResources().getColorStateList(SlotsInputView.this.mHintColor));
            if (SlotsInputView.this.mHint.length() > this.mSlotIndex) {
                this.mSlot.setHint((CharSequence)String.valueOf(SlotsInputView.this.mHint.charAt(this.mSlotIndex)));
            }
            this.mSlot.setMaxLines(1);
            this.mSlot.setFilters(new InputFilter[]{new InputFilter.LengthFilter(SlotsInputView.this.mSlotLength)});
            this.mSlot.setInputType(SlotsInputView.this.mInputType);
            this.mSlot.setOnFocusChangeListener((view, hasFocus) -> {
                if (hasFocus) {
                    this.mSlot.setHintTextColor(0);
                } else {
                    this.mSlot.setHintTextColor(SlotsInputView.this.getResources().getColorStateList(SlotsInputView.this.mHintColor));
                }
            });
            this.mSlot.setOnKeyListener((view, keyCode, event) -> {
                if (keyCode == 67) {
                    SlotsInputView.this.requestFocusOnPrevSlot(this);
                    SlotsInputView.this.checkSlots();
                }
                return false;
            });
            this.mSlot.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence text, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence text, int start, int before, int count) {
                }

                public void afterTextChanged(Editable editable) {
                    Slot.this.mValue = editable.toString();
                    if (editable.length() == SlotsInputView.this.mSlotLength) {
                        Slot.this.mIsFilled = true;
                        SlotsInputView.this.requestFocusOnNextSlot(Slot.this);
                    } else {
                        Slot.this.mIsFilled = false;
                    }
                    SlotsInputView.this.checkSlots();
                }
            });
            this.mIsFilled = false;
        }
    }

    public static interface OnSlotsTextChangedListener {
        public void onSlotsTextChanged(String var1, ArrayList<String> var2, boolean var3);
    }
}

