/*
 * Decompiled with CFR 0.152.
 */
package smile.swing.table;

import java.util.prefs.Preferences;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnSettings
implements TableColumnModelListener {
    private String id;
    private JTable table;
    private Preferences prefs = Preferences.userNodeForPackage(TableColumnSettings.class);

    public TableColumnSettings(String id) {
        this.id = id;
    }

    public void apply(JTable table) {
        this.table = table;
        this.restoreSettings();
        table.getColumnModel().addColumnModelListener(this);
    }

    private void restoreSettings() {
        TableColumnModel columnModel = this.table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            int idx = col.getModelIndex();
            int width = this.prefs.getInt(this.id + "-column-width-" + idx, 0);
            if (width == 0) continue;
            col.setPreferredWidth(width);
        }
        TableColumn[] column = new TableColumn[columnModel.getColumnCount()];
        for (int i = 0; i < column.length; ++i) {
            column[i] = columnModel.getColumn(i);
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        int visibleColumnCount = this.prefs.getInt(this.id + "-visible-column-count", column.length);
        for (int i = 0; i < visibleColumnCount; ++i) {
            int idx = this.prefs.getInt(this.id + "-column-order-" + i, i);
            columnModel.addColumn(column[idx]);
        }
    }

    private void saveSettings() {
        TableColumnModel columnModel = this.table.getColumnModel();
        this.prefs.putInt(this.id + "-visible-column-count", columnModel.getColumnCount());
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn col = columnModel.getColumn(i);
            int idx = col.getModelIndex();
            int width = col.getWidth();
            this.prefs.putInt(this.id + "-column-width-" + idx, width);
            this.prefs.putInt(this.id + "-column-order-" + i, idx);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.saveSettings();
    }

    @Override
    public void columnAdded(TableColumnModelEvent tcme) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tcme) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tcme) {
        this.saveSettings();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent lse) {
    }
}

