/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Graphics;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;
import smile.plot.swing.Projection3D;
import smile.sort.QuickSort;

public class Surface
extends Plot {
    private double[][][] data;
    private double[][] zc;
    private double[] az;
    private int[] order;
    private int[][] triangles;
    private double min;
    private double max;
    private double width = 1.0;
    private Color[] palette;

    public Surface(double[][][] data) {
        this(data, null);
    }

    public Surface(double[][][] data, Color[] palette) {
        super(Color.GRAY);
        this.palette = palette;
        this.data = data;
        int m = data.length;
        int n = data[0].length;
        this.zc = new double[m][n];
        this.triangles = new int[2 * m * n][6];
        this.az = new double[2 * m * n];
        this.order = new int[this.az.length];
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        int k = 0;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                double z = data[i][j][2];
                if (z < this.min) {
                    this.min = z;
                }
                if (z > this.max) {
                    this.max = z;
                }
                if (i < m - 1 && j < n - 1) {
                    this.triangles[k][0] = i;
                    this.triangles[k][1] = j;
                    this.triangles[k][2] = i + 1;
                    this.triangles[k][3] = j;
                    this.triangles[k][4] = i;
                    this.triangles[k][5] = j + 1;
                    this.triangles[k + 1][0] = i + 1;
                    this.triangles[k + 1][1] = j + 1;
                    this.triangles[k + 1][2] = i + 1;
                    this.triangles[k + 1][3] = j;
                    this.triangles[k + 1][4] = i;
                    this.triangles[k + 1][5] = j + 1;
                }
                ++j;
                k += 2;
            }
        }
        if (palette != null) {
            this.width = (this.max - this.min) / (double)palette.length;
        }
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{this.data[0][0][0], this.data[0][0][1], this.data[0][0][2]};
        double[][][] dArray = this.data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[][] row;
            for (double[] x : row = dArray[i]) {
                if (x[0] < bound[0]) {
                    bound[0] = x[0];
                }
                if (x[1] < bound[1]) {
                    bound[1] = x[1];
                }
                if (!(x[2] < bound[2])) continue;
                bound[2] = x[2];
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{this.data[0][0][0], this.data[0][0][1], this.data[0][0][2]};
        double[][][] dArray = this.data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[][] row;
            for (double[] x : row = dArray[i]) {
                if (x[0] > bound[0]) {
                    bound[0] = x[0];
                }
                if (x[1] > bound[1]) {
                    bound[1] = x[1];
                }
                if (!(x[2] > bound[2])) continue;
                bound[2] = x[2];
            }
        }
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        g.setColor(this.color);
        for (i = 0; i < this.data.length; ++i) {
            for (j = 0; j < this.data[i].length - 1; ++j) {
                g.drawLine(this.data[i][j], this.data[i][j + 1]);
            }
        }
        for (i = 0; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                g.drawLine(this.data[i][j], this.data[i + 1][j]);
            }
        }
        if (this.palette != null) {
            int i2;
            int m = this.data.length;
            int n = this.data[0].length;
            Projection3D p3d = (Projection3D)g.projection;
            for (i2 = 0; i2 < m; ++i2) {
                for (int j2 = 0; j2 < n; ++j2) {
                    this.zc[i2][j2] = p3d.z(this.data[i2][j2]);
                }
            }
            for (i2 = 0; i2 < this.triangles.length; ++i2) {
                this.az[i2] = this.zc[this.triangles[i2][0]][this.triangles[i2][1]] + this.zc[this.triangles[i2][2]][this.triangles[i2][3]] + this.zc[this.triangles[i2][4]][this.triangles[i2][5]];
            }
            for (i2 = 0; i2 < this.order.length; ++i2) {
                this.order[i2] = i2;
            }
            QuickSort.sort((double[])this.az, (int[])this.order);
            for (int i3 : this.order) {
                double avg = (this.data[this.triangles[i3][0]][this.triangles[i3][1]][2] + this.data[this.triangles[i3][2]][this.triangles[i3][3]][2] + this.data[this.triangles[i3][4]][this.triangles[i3][5]][2]) / 3.0;
                int k = (int)((avg - this.min) / this.width);
                if (k == this.palette.length) {
                    k = this.palette.length - 1;
                }
                g.setColor(this.palette[k]);
                g.fillPolygon(this.data[this.triangles[i3][0]][this.triangles[i3][1]], this.data[this.triangles[i3][2]][this.triangles[i3][3]], this.data[this.triangles[i3][4]][this.triangles[i3][5]]);
            }
        }
    }

    public static Surface of(double[][] z, int k) {
        return Surface.of(z, Palette.jet(k, 1.0f));
    }

    public static Surface of(double[][] z, Color[] palette) {
        int m = z.length;
        int n = z[0].length;
        double[] x = new double[m];
        double[] y = new double[n];
        for (int i = 0; i < m; ++i) {
            x[i] = (double)i + 0.5;
        }
        for (int j = 0; j < n; ++j) {
            y[j] = (double)j + 0.5;
        }
        return Surface.of(x, y, z, palette);
    }

    public static Surface of(double[] x, double[] y, double[][] z) {
        return Surface.of(x, y, z, null);
    }

    public static Surface of(double[] x, double[] y, double[][] z, int k) {
        return Surface.of(x, y, z, Palette.jet(k, 1.0f));
    }

    public static Surface of(double[] x, double[] y, double[][] z, Color[] palette) {
        int m = z.length;
        int n = z[0].length;
        double[][][] data = new double[m][n][3];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                data[i][j][0] = x[i];
                data[i][j][1] = y[j];
                data[i][j][2] = z[i][j];
            }
        }
        return new Surface(data, palette);
    }
}

