/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Graphics;
import smile.plot.swing.Shape;

public class Staircase
extends Shape {
    final double[][] points;

    public Staircase(double[][] points, Color color) {
        super(color);
        this.points = points;
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        g.setColor(this.color);
        int n = this.points.length;
        int d = this.points[0].length;
        double[] begin = new double[d];
        double[] end = new double[d];
        for (i = 0; i < n - 1; ++i) {
            for (j = 0; j < d; ++j) {
                begin[j] = this.points[i][j];
                end[j] = this.points[i + 1][j];
            }
            end[d - 1] = this.points[i][d - 1];
            g.drawLine(begin, end);
        }
        for (i = 1; i < n; ++i) {
            for (j = 0; j < d; ++j) {
                begin[j] = this.points[i][j];
                end[j] = this.points[i][j];
            }
            begin[d - 1] = this.points[i - 1][d - 1];
            g.drawLine(begin, end);
        }
    }

    public static Staircase of(double[][] points) {
        return new Staircase(points, Color.BLACK);
    }
}

