/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.util.Arrays;
import smile.math.MathEx;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.Distribution;
import smile.stat.distribution.GaussianDistribution;

public class QQPlot
extends Plot {
    private double[][] points;

    public QQPlot(double[][] points) {
        this.points = points;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        double[] lowerEnd = g.getLowerBound();
        lowerEnd[0] = Math.min(lowerEnd[0], lowerEnd[1]);
        lowerEnd[1] = lowerEnd[0];
        double[] upperEnd = g.getUpperBound();
        upperEnd[0] = Math.max(upperEnd[0], upperEnd[1]);
        upperEnd[1] = upperEnd[0];
        g.drawLine(lowerEnd, upperEnd);
        for (double[] point : this.points) {
            g.drawPoint('o', point);
        }
    }

    @Override
    public double[] getLowerBound() {
        return MathEx.colMin((double[][])this.points);
    }

    @Override
    public double[] getUpperBound() {
        return MathEx.colMax((double[][])this.points);
    }

    public static QQPlot of(double[] x) {
        return QQPlot.of(x, (Distribution)GaussianDistribution.getInstance());
    }

    public static QQPlot of(double[] x, Distribution d) {
        Arrays.sort(x);
        int n = x.length;
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round(p * (double)x.length)];
            q[i][1] = d.quantile(p);
        }
        return new QQPlot(q);
    }

    public static QQPlot of(int[] x, DiscreteDistribution d) {
        Arrays.sort(x);
        int n = x.length;
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round(p * (double)x.length)];
            q[i][1] = d.quantile(p);
        }
        return new QQPlot(q);
    }

    public static QQPlot of(double[] x, double[] y) {
        Arrays.sort(x);
        Arrays.sort(y);
        int n = Math.min(x.length, y.length);
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round(p * (double)x.length)];
            q[i][1] = y[(int)Math.round(p * (double)y.length)];
        }
        return new QQPlot(q);
    }

    public static QQPlot of(int[] x, int[] y) {
        Arrays.sort(x);
        Arrays.sort(y);
        int n = Math.min(x.length, y.length);
        double[][] q = new double[n][2];
        for (int i = 0; i < n; ++i) {
            double p = (double)(i + 1) / ((double)n + 1.0);
            q[i][0] = x[(int)Math.round(p * (double)x.length)];
            q[i][1] = y[(int)Math.round(p * (double)y.length)];
        }
        return new QQPlot(q);
    }
}

