/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Graphics;
import smile.plot.swing.Shape;

public class Point
extends Shape {
    public static char[] MARKS = new char[]{'.', '+', '-', '|', '*', 'x', 'o', 'O', '@', '#', 's', 'S', 'q', 'Q'};
    final double[][] points;
    final char mark;

    public Point(double[][] points, char mark, Color color) {
        super(color);
        this.points = points;
        this.mark = mark;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        for (double[] point : this.points) {
            g.drawPoint(this.mark, point);
        }
    }

    public static Point of(double[][] points) {
        return new Point(points, 'o', Color.BLACK);
    }

    public static Point of(double[][] points, Color color) {
        return new Point(points, 'o', color);
    }

    public static Point of(double[][] points, char mark) {
        return new Point(points, mark, Color.BLACK);
    }
}

