/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.plot.swing.Canvas;
import smile.plot.swing.PlotPanel;
import smile.plot.swing.ScatterPlot;
import smile.swing.FileChooser;
import smile.swing.Printer;

public class PlotGrid
extends JPanel
implements ActionListener,
Printable {
    private static final Logger logger = LoggerFactory.getLogger(PlotGrid.class);
    private static final String SAVE = "save";
    private static final String PRINT = "print";
    private JPanel contentPane;
    private JToolBar toolbar;

    public PlotGrid(int nrows, int ncols) {
        this.init(this.layout(nrows, ncols));
    }

    public PlotGrid(PlotPanel ... plots) {
        this.init(this.layout(plots.length));
        for (PlotPanel plot : plots) {
            this.contentPane.add(plot);
        }
    }

    private void init(LayoutManager layout) {
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.contentPane = new JPanel();
        this.contentPane.setLayout(layout);
        this.contentPane.setBackground(Color.WHITE);
        this.add((Component)this.contentPane, "Center");
    }

    private LayoutManager layout(int size) {
        int n = (int)Math.ceil(Math.sqrt(size));
        if (n < 1) {
            n = 1;
        }
        return this.layout(n, n);
    }

    private LayoutManager layout(int nrows, int ncols) {
        return new GridLayout(nrows, ncols, 0, 0);
    }

    public void add(PlotPanel plot) {
        this.contentPane.add(plot);
        this.contentPane.setLayout(this.layout(this.contentPane.getComponentCount()));
    }

    public void remove(PlotPanel plot) {
        this.contentPane.remove(plot);
        this.contentPane.setLayout(this.layout(this.contentPane.getComponentCount()));
    }

    private void initToolBar() {
        this.toolbar = new JToolBar();
        JButton button = this.makeButton(SAVE, SAVE, "Save", "Save");
        this.toolbar.add(button);
        button = this.makeButton(PRINT, PRINT, "Print", "Print");
        this.toolbar.add(button);
    }

    private JButton makeButton(String imageName, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "images/" + imageName + "16.png";
        URL imageURL = PlotGrid.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(this);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            button.setText(altText);
            logger.error("Resource not found: {}", (Object)imgLocation);
        }
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (SAVE.equals(cmd)) {
            try {
                this.save();
            }
            catch (IOException ex) {
                logger.error("Failed to save the screenshot", (Throwable)ex);
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            }
        } else if (PRINT.equals(cmd)) {
            this.print();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        double scaleX = pf.getImageableWidth() / (double)this.contentPane.getWidth();
        double scaleY = pf.getImageableHeight() / (double)this.contentPane.getHeight();
        g2d.scale(scaleX, scaleY);
        RepaintManager currentManager = RepaintManager.currentManager(this);
        currentManager.setDoubleBufferingEnabled(false);
        this.contentPane.printAll(g);
        currentManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    public void save() throws IOException {
        FileChooser fc = FileChooser.getInstance();
        fc.setFileFilter(FileChooser.SimpleFileFilter.getWritableImageFIlter());
        fc.setAcceptAllFileFilterUsed(false);
        fc.setSelectedFiles(new File[0]);
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.save(file);
        }
    }

    public void save(File file) throws IOException {
        BufferedImage bi = new BufferedImage(this.contentPane.getWidth(), this.contentPane.getHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        this.contentPane.printAll(g2d);
        ImageIO.write((RenderedImage)bi, FileChooser.getExtension(file), file);
    }

    public void print() {
        Printer.getPrinter().print(this);
    }

    public JFrame window() throws InterruptedException, InvocationTargetException {
        JFrame frame = new JFrame();
        String title = String.format("Smile Plot %d", PlotPanel.WindowCount.addAndGet(1));
        frame.setTitle(title);
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this, "Center");
        pane.add((Component)this.toolbar, "North");
        frame.getContentPane().add(pane);
        frame.setDefaultCloseOperation(2);
        frame.setSize(new Dimension(1280, 1000));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        SwingUtilities.invokeAndWait(() -> {
            frame.toFront();
            frame.repaint();
        });
        return frame;
    }

    public static PlotGrid splom(DataFrame data, char mark, Color color) {
        String[] columns = data.names();
        int p = columns.length;
        PlotGrid grid = new PlotGrid(p, p);
        int i = p;
        while (i-- > 0) {
            for (int j = 0; j < p; ++j) {
                Canvas canvas = ScatterPlot.of(data, columns[j], columns[i], mark, color).canvas();
                canvas.setAxisLabels(columns[j], columns[i]);
                grid.add(canvas.panel());
            }
        }
        return grid;
    }

    public static PlotGrid splom(DataFrame data, char mark, String category) {
        int clazz = data.columnIndex(category);
        String[] columns = data.names();
        int p = columns.length;
        PlotGrid grid = new PlotGrid(p, p);
        int i = p;
        while (i-- > 0) {
            if (i == clazz) continue;
            for (int j = 0; j < p; ++j) {
                if (j == clazz) continue;
                Canvas canvas = ScatterPlot.of(data, columns[j], columns[i], category, mark).canvas();
                canvas.setLegendVisible(false);
                canvas.setAxisLabels(columns[j], columns[i]);
                grid.add(canvas.panel());
            }
        }
        return grid;
    }
}

