/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Line;
import smile.plot.swing.Plot;

public class LinePlot
extends Plot {
    final Line[] lines;
    final Optional<Legend[]> legends;

    public LinePlot(Line ... lines) {
        this.lines = lines;
        this.legends = Optional.empty();
    }

    public LinePlot(Line[] lines, Legend[] legends) {
        this.lines = lines;
        this.legends = Optional.of(legends);
    }

    @Override
    public Optional<Legend[]> legends() {
        return this.legends;
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound());
        canvas.add(this);
        return canvas;
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = MathEx.colMin((double[][])this.lines[0].points);
        for (int k = 1; k < this.lines.length; ++k) {
            for (double[] x : this.lines[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] > x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = MathEx.colMax((double[][])this.lines[0].points);
        for (int k = 1; k < this.lines.length; ++k) {
            for (double[] x : this.lines[k].points) {
                for (int i = 0; i < x.length; ++i) {
                    if (!(bound[i] < x[i])) continue;
                    bound[i] = x[i];
                }
            }
        }
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        for (Line line : this.lines) {
            line.paint(g);
        }
    }

    public static LinePlot of(double[][] data) {
        return new LinePlot(Line.of(data));
    }

    public static LinePlot of(double[][] data, Line.Style style) {
        return new LinePlot(Line.of(data, style));
    }

    public static LinePlot of(double[][] data, Color color) {
        return new LinePlot(Line.of(data, color));
    }

    public static LinePlot of(double[][] data, Line.Style style, Color color) {
        return new LinePlot(Line.of(data, style, color));
    }

    public static LinePlot of(double[][] data, Line.Style style, Color color, String label) {
        Line[] line = new Line[]{Line.of(data, style, color)};
        Legend[] legend = new Legend[]{new Legend(label, color)};
        return new LinePlot(line, legend);
    }

    public static LinePlot of(double[] y) {
        return LinePlot.of(Line.zipWithIndex(y));
    }

    public static LinePlot of(double[] y, Line.Style style) {
        return new LinePlot(Line.of(Line.zipWithIndex(y), style));
    }

    public static LinePlot of(double[] y, Color color) {
        return new LinePlot(Line.of(Line.zipWithIndex(y), color));
    }

    public static LinePlot of(double[] y, Line.Style style, Color color) {
        return new LinePlot(Line.of(Line.zipWithIndex(y), style, color));
    }

    public static LinePlot of(double[] y, Line.Style style, Color color, String label) {
        Line[] line = new Line[]{Line.of(Line.zipWithIndex(y), style, color)};
        Legend[] legend = new Legend[]{new Legend(label, color)};
        return new LinePlot(line, legend);
    }
}

