/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import smile.plot.swing.Graphics;
import smile.plot.swing.Shape;

public class Line
extends Shape {
    private static final BasicStroke SOLID_STROKE = new BasicStroke(1.0f, 0, 1);
    private static final BasicStroke DOT_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private static final BasicStroke DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{10.0f}, 0.0f);
    private static final BasicStroke DOT_DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{10.0f, 2.0f, 2.0f, 2.0f}, 0.0f);
    private static final BasicStroke LONG_DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{20.0f}, 0.0f);
    private final Stroke stroke;
    final double[][] points;
    final Style style;
    final char mark;

    public Line(double[][] points, Style style, char mark, Color color) {
        super(color);
        this.points = points;
        this.style = style;
        this.mark = mark;
        switch (style) {
            case SOLID: {
                this.stroke = SOLID_STROKE;
                break;
            }
            case DOT: {
                this.stroke = DOT_STROKE;
                break;
            }
            case DASH: {
                this.stroke = DASH_STROKE;
                break;
            }
            case DOT_DASH: {
                this.stroke = DOT_DASH_STROKE;
                break;
            }
            case LONG_DASH: {
                this.stroke = LONG_DASH_STROKE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown style: " + (Object)((Object)style));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        Stroke s = g.getStroke();
        g.setStroke(this.stroke);
        g.drawLine(this.points);
        if (this.mark != ' ') {
            for (double[] point : this.points) {
                g.drawPoint(this.mark, point);
            }
        }
        g.setStroke(s);
    }

    public static double[][] zipWithIndex(double[] y) {
        int n = y.length;
        double[][] data = new double[n][2];
        for (int i = 0; i < n; ++i) {
            data[i][0] = i;
            data[i][1] = y[i];
        }
        return data;
    }

    public static Line of(double[][] points) {
        return new Line(points, Style.SOLID, ' ', Color.BLACK);
    }

    public static Line of(double[][] points, Style style) {
        return new Line(points, style, ' ', Color.BLACK);
    }

    public static Line of(double[][] points, char mark) {
        return new Line(points, Style.SOLID, mark, Color.BLACK);
    }

    public static Line of(double[][] points, Color color) {
        return new Line(points, Style.SOLID, ' ', color);
    }

    public static Line of(double[][] points, Style style, Color color) {
        return new Line(points, style, ' ', color);
    }

    public static enum Style {
        SOLID,
        DOT,
        DASH,
        DOT_DASH,
        LONG_DASH;

    }
}

