/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import smile.math.MathEx;
import smile.plot.swing.Graphics;
import smile.plot.swing.Shape;

public class Label
extends Shape {
    private static Font DefaultFont = new JLabel().getFont();
    final String text;
    final double[] coordinates;
    final double horizontalReference;
    final double verticalReference;
    final double rotation;
    final Font font;

    public Label(String text, double[] coordinates, double horizontalReference, double verticalReference, double rotation, Font font, Color color) {
        super(color);
        this.text = text;
        this.coordinates = coordinates;
        this.horizontalReference = horizontalReference;
        this.verticalReference = verticalReference;
        this.rotation = rotation;
        this.font = font;
    }

    @Override
    public void paint(Graphics g) {
        Font f = g.getFont();
        if (this.font != null) {
            g.setFont(this.font);
        }
        Color c = g.getColor();
        g.setColor(this.color);
        g.drawText(this.text, this.coordinates, this.horizontalReference, this.verticalReference, this.rotation);
        g.setColor(c);
        if (this.font != null) {
            g.setFont(f);
        }
    }

    private static String coordinatesToString(double ... c) {
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < c.length; ++i) {
            builder.append(MathEx.round((double)c[i], (int)2)).append(",");
        }
        if (c.length > 0) {
            builder.setCharAt(builder.length(), ')');
        } else {
            builder.append(")");
        }
        return builder.toString();
    }

    public static Label of(String text, double[] coordinates) {
        return Label.of(text, coordinates, 0.5, 0.5, 0.0);
    }

    public static Label of(double ... coordinates) {
        return Label.of(Label.coordinatesToString(coordinates), coordinates, 0.5, 0.5, 0.0);
    }

    public static Label of(String text, double[] coordinates, double horizontalReference, double verticalReference, double rotation) {
        return new Label(text, coordinates, horizontalReference, verticalReference, rotation, DefaultFont, Color.BLACK);
    }
}

