/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Bar;
import smile.plot.swing.BarPlot;

public class Histogram {
    public static BarPlot of(int[] data) {
        return Histogram.of(data, smile.math.Histogram.bins((int)data.length), true);
    }

    public static BarPlot of(int[] data, int k, boolean prob) {
        return Histogram.of(data, k, prob, Color.BLUE);
    }

    public static BarPlot of(int[] data, int k, boolean prob, Color color) {
        double[][] hist = smile.math.Histogram.of((int[])data, (int)k);
        k = hist[0].length;
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return new BarPlot(new Bar(freq, Histogram.width(freq), color));
    }

    public static BarPlot of(int[] data, double[] breaks, boolean prob) {
        return Histogram.of(data, breaks, prob, Color.BLUE);
    }

    public static BarPlot of(int[] data, double[] breaks, boolean prob, Color color) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] hist = smile.math.Histogram.of((int[])data, (double[])breaks);
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return new BarPlot(new Bar(freq, Histogram.width(freq), color));
    }

    public static BarPlot of(double[] data) {
        return Histogram.of(data, smile.math.Histogram.bins((int)data.length), true, Color.BLUE);
    }

    public static BarPlot of(double[] data, int k, boolean prob) {
        return Histogram.of(data, k, prob, Color.BLUE);
    }

    public static BarPlot of(double[] data, int k, boolean prob, Color color) {
        double[][] hist = smile.math.Histogram.of((double[])data, (int)k);
        k = hist[0].length;
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return new BarPlot(new Bar(freq, Histogram.width(freq), color));
    }

    public static BarPlot of(double[] data, double[] breaks, boolean prob) {
        return Histogram.of(data, breaks, prob, Color.BLUE);
    }

    public static BarPlot of(double[] data, double[] breaks, boolean prob, Color color) {
        int k = breaks.length - 1;
        if (k <= 1) {
            throw new IllegalArgumentException("Invalid number of bins: " + k);
        }
        double[][] hist = smile.math.Histogram.of((double[])data, (double[])breaks);
        double[][] freq = new double[k][2];
        for (int i = 0; i < k; ++i) {
            freq[i][0] = (hist[0][i] + hist[1][i]) / 2.0;
            freq[i][1] = hist[2][i];
        }
        if (prob) {
            double n = data.length;
            for (int i = 0; i < k; ++i) {
                double[] dArray = freq[i];
                dArray[1] = dArray[1] / n;
            }
        }
        return new BarPlot(new Bar(freq, Histogram.width(freq), color));
    }

    private static double width(double[][] freq) {
        double width = Double.MAX_VALUE;
        for (int i = 1; i < freq.length; ++i) {
            double w = Math.abs(freq[i][0] - freq[i - 1][0]);
            if (!(width > w)) continue;
            width = w;
        }
        return width;
    }
}

