/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.util.Arrays;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Palette;
import smile.plot.swing.Plot;

public class Heatmap
extends Plot {
    private double[] x;
    private double[] y;
    private double[][] z;
    private String[] columnLabels;
    private String[] rowLabels;
    private double min;
    private double max;
    private double width;
    private Color[] palette;
    private boolean isLabelVisible;

    public Heatmap(String[] rowLabels, String[] columnLabels, double[][] z, Color[] palette) {
        if (columnLabels.length != z[0].length) {
            throw new IllegalArgumentException("columnLabels.length != z[0].length");
        }
        if (rowLabels.length != z.length) {
            throw new IllegalArgumentException("rowLabels.length != z.length");
        }
        this.z = z;
        this.columnLabels = columnLabels;
        this.rowLabels = rowLabels;
        this.palette = palette;
        this.init();
    }

    public Heatmap(double[] x, double[] y, double[][] z, Color[] palette) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.palette = palette;
        this.init();
    }

    private void init() {
        int i;
        boolean bl = this.isLabelVisible = this.x != null || this.y != null || this.rowLabels != null || this.columnLabels != null;
        if (this.x == null) {
            this.x = new double[this.z[0].length];
            for (i = 0; i < this.x.length; ++i) {
                this.x[i] = (double)i + 0.5;
            }
        }
        if (this.y == null) {
            this.y = new double[this.z.length];
            for (i = 0; i < this.y.length; ++i) {
                this.y[i] = (double)(this.y.length - i) - 0.5;
            }
        }
        if (this.x.length != this.z[0].length) {
            throw new IllegalArgumentException("x.length != z[0].length");
        }
        if (this.y.length != this.z.length) {
            throw new IllegalArgumentException("y.length != z.length");
        }
        int n = this.z.length * this.z[0].length;
        double[] values = new double[n];
        int i2 = 0;
        double[][] dArray = this.z;
        int n2 = dArray.length;
        for (int j = 0; j < n2; ++j) {
            double[] zi;
            for (double zij : zi = dArray[j]) {
                if (Double.isNaN(zij)) continue;
                values[i2++] = zij;
            }
        }
        if (i2 > 0) {
            Arrays.sort(values, 0, i2);
            this.min = values[(int)Math.round(0.01 * (double)i2)];
            this.max = values[(int)Math.round(0.99 * (double)(i2 - 1))];
            this.width = (this.max - this.min) / (double)this.palette.length;
        }
    }

    @Override
    public Optional<String> tooltip(double[] coord) {
        if (this.rowLabels == null || this.columnLabels == null) {
            return Optional.empty();
        }
        if (coord[0] < 0.0 || coord[0] > (double)this.z[0].length || coord[1] < 0.0 || coord[1] > (double)this.z.length) {
            return Optional.empty();
        }
        int i = (int)coord[0];
        int j = (int)((double)this.y.length - coord[1]);
        return Optional.of(String.format("%s, %s", this.rowLabels[j], this.columnLabels[i]));
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{MathEx.min((double[])this.x), MathEx.min((double[])this.y)};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{MathEx.max((double[])this.x), MathEx.max((double[])this.y)};
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        double[] start = new double[2];
        double[] end = new double[2];
        for (int i = 0; i < this.z.length; ++i) {
            for (int j = 0; j < this.z[i].length; ++j) {
                if (Double.isNaN(this.z[i][j])) {
                    g.setColor(Color.WHITE);
                } else {
                    int k = (int)((this.z[i][j] - this.min) / this.width);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= this.palette.length) {
                        k = this.palette.length - 1;
                    }
                    g.setColor(this.palette[k]);
                }
                start[0] = this.x[j];
                start[0] = j == 0 ? start[0] - Math.abs(this.x[j + 1] - this.x[j]) / 2.0 : start[0] - Math.abs(this.x[j] - this.x[j - 1]) / 2.0;
                start[1] = this.y[i];
                start[1] = i == 0 ? start[1] + Math.abs(this.y[i + 1] - this.y[i]) / 2.0 : start[1] + Math.abs(this.y[i] - this.y[i - 1]) / 2.0;
                end[0] = this.x[j];
                end[0] = j == this.x.length - 1 ? end[0] + Math.abs(this.x[j] - this.x[j - 1]) / 2.0 : end[0] + Math.abs(this.x[j + 1] - this.x[j]) / 2.0;
                end[1] = this.y[i];
                end[1] = i == this.y.length - 1 ? end[1] - Math.abs(this.y[i] - this.y[i - 1]) / 2.0 : end[1] - Math.abs(this.y[i + 1] - this.y[i]) / 2.0;
                g.fillRect(start, end);
            }
        }
        g.clearClip();
        double height = 0.7 / (double)this.palette.length;
        start[0] = 1.1;
        start[1] = 0.15;
        end[0] = 1.13;
        end[1] = start[1] - height;
        for (int i = 0; i < this.palette.length; ++i) {
            g.setColor(this.palette[i]);
            g.fillRectBaseRatio(start, end);
            start[1] = start[1] + height;
            end[1] = end[1] + height;
        }
        g.setColor(Color.BLACK);
        start[1] = start[1] - height;
        end[1] = 0.15 - height;
        g.drawRectBaseRatio(start, end);
        start[0] = 1.14;
        double log = Math.log10(Math.abs(this.max));
        int decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.max, (int)decimal)), start, 0.0, 1.0);
        start[1] = 0.15 - height;
        log = Math.log10(Math.abs(this.min));
        decimal = 1;
        if (log < 0.0) {
            decimal = (int)(-log) + 1;
        }
        g.drawTextBaseRatio(String.valueOf(MathEx.round((double)this.min, (int)decimal)), start, 0.0, 0.0);
    }

    @Override
    public Canvas canvas() {
        int i;
        double[] locations;
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.add(this);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(1).setGridVisible(false);
        if (!this.isLabelVisible) {
            canvas.getAxis(0).setTickVisible(false);
            canvas.getAxis(0).setFrameVisible(false);
            canvas.getAxis(1).setTickVisible(false);
            canvas.getAxis(1).setFrameVisible(false);
        }
        if (this.rowLabels != null) {
            locations = new double[this.rowLabels.length];
            for (i = 0; i < this.rowLabels.length; ++i) {
                locations[i] = (double)(this.z.length - i) - 0.5;
            }
            canvas.getAxis(1).setTicks(this.rowLabels, locations);
        }
        if (this.columnLabels != null) {
            canvas.getAxis(0).setRotation(-1.5707963267948966);
            locations = new double[this.columnLabels.length];
            for (i = 0; i < this.columnLabels.length; ++i) {
                locations[i] = (double)i + 0.5;
            }
            canvas.getAxis(0).setTicks(this.columnLabels, locations);
        }
        return canvas;
    }

    public static Heatmap of(double[][] z) {
        return Heatmap.of(z, 16);
    }

    public static Heatmap of(double[][] z, int k) {
        return Heatmap.of(z, Palette.jet(k, 1.0f));
    }

    public static Heatmap of(double[][] z, Color[] palette) {
        return new Heatmap((double[])null, null, z, palette);
    }

    public static Heatmap of(String[] rowLabels, String[] columnLabels, double[][] z) {
        return Heatmap.of(rowLabels, columnLabels, z, 16);
    }

    public static Heatmap of(String[] rowLabels, String[] columnLabels, double[][] z, int k) {
        return new Heatmap(rowLabels, columnLabels, z, Palette.jet(k, 1.0f));
    }

    public static Heatmap of(double[] x, double[] y, double[][] z) {
        return Heatmap.of(x, y, z, 16);
    }

    public static Heatmap of(double[] x, double[] y, double[][] z, int k) {
        return new Heatmap(x, y, z, Palette.jet(k, 1.0f));
    }
}

