/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;

public class Dendrogram
extends Plot {
    private double[][] p1;
    private double[][] p2;
    private double height;

    public Dendrogram(int[][] merge, double[] height) {
        this(merge, height, Color.BLACK);
    }

    public Dendrogram(int[][] merge, double[] height, Color color) {
        super(color);
        int i;
        int n = merge.length + 1;
        int[] order = new int[n];
        this.dfs(merge, n - 2, order, 0);
        double[][] pos = new double[2 * n - 1][2];
        for (i = 0; i < n; ++i) {
            pos[order[i]][0] = i;
            pos[order[i]][1] = 0.0;
        }
        for (i = 0; i < merge.length; ++i) {
            pos[n + i][0] = (pos[merge[i][0]][0] + pos[merge[i][1]][0]) / 2.0;
            pos[n + i][1] = Math.max(pos[merge[i][0]][1], pos[merge[i][1]][1]) + height[i];
        }
        this.p1 = new double[3 * n - 3][2];
        this.p2 = new double[3 * n - 3][2];
        for (i = 0; i < merge.length; ++i) {
            this.p1[3 * i][0] = pos[merge[i][0]][0];
            this.p1[3 * i][1] = pos[merge[i][0]][1];
            this.p2[3 * i][0] = pos[merge[i][0]][0];
            this.p2[3 * i][1] = pos[n + i][1];
            this.p1[3 * i + 1][0] = pos[merge[i][1]][0];
            this.p1[3 * i + 1][1] = pos[merge[i][1]][1];
            this.p2[3 * i + 1][0] = pos[merge[i][1]][0];
            this.p2[3 * i + 1][1] = pos[n + i][1];
            this.p1[3 * i + 2][0] = pos[merge[i][0]][0];
            this.p1[3 * i + 2][1] = pos[n + i][1];
            this.p2[3 * i + 2][0] = pos[merge[i][1]][0];
            this.p2[3 * i + 2][1] = pos[n + i][1];
        }
        this.height = pos[2 * n - 2][1];
    }

    public double getHeight() {
        return this.height;
    }

    private int dfs(int[][] merge, int index, int[] order, int i) {
        int n = merge.length + 1;
        if (merge[index][0] > merge.length) {
            i = this.dfs(merge, merge[index][0] - n, order, i);
        } else {
            order[i++] = merge[index][0];
        }
        if (merge[index][1] > merge.length) {
            i = this.dfs(merge, merge[index][1] - n, order, i);
        } else {
            order[i++] = merge[index][1];
        }
        return i;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.color);
        for (int i = 0; i < this.p1.length; ++i) {
            g.drawLine(this.p1[i], this.p2[i]);
        }
        g.setColor(c);
    }

    @Override
    public double[] getLowerBound() {
        int n = this.p1.length / 3 + 1;
        double[] bound = new double[]{-n / 100, 0.0};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        int n = this.p1.length / 3 + 1;
        double[] bound = new double[]{n + n / 100, 1.01 * this.height};
        return bound;
    }

    @Override
    public Canvas canvas() {
        Canvas canvas = new Canvas(this.getLowerBound(), this.getUpperBound(), false);
        canvas.getAxis(0).setGridVisible(false);
        canvas.getAxis(0).setTickVisible(false);
        canvas.add(this);
        return canvas;
    }
}

