/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.event.SwingPropertyChangeSupport;
import smile.plot.swing.Axis;
import smile.plot.swing.Base;
import smile.plot.swing.Graphics;
import smile.plot.swing.Legend;
import smile.plot.swing.Plot;
import smile.plot.swing.PlotPanel;
import smile.plot.swing.Projection2D;
import smile.plot.swing.Projection3D;
import smile.plot.swing.Shape;

public class Canvas {
    private static final double DEFAULT_MARGIN = 0.15;
    private static final Font DEFAULT_TITLE_FONT = new Font("Arial", 1, 16);
    private static final Color DEFAULT_TITLE_COLOR = Color.BLACK;
    Base base;
    Graphics graphics;
    double margin = 0.15;
    Axis[] axis;
    List<Shape> shapes = new ArrayList<Shape>();
    private boolean isLegendVisible = true;
    private String title;
    private Font titleFont = DEFAULT_TITLE_FONT;
    private Color titleColor = DEFAULT_TITLE_COLOR;
    private SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);

    public Canvas(double[] lowerBound, double[] upperBound) {
        this(lowerBound, upperBound, true);
    }

    public Canvas(double[] lowerBound, double[] upperBound, boolean extendBound) {
        this.initBase(lowerBound, upperBound, extendBound);
        this.initGraphics();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public BufferedImage toBufferedImage(int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2d = bi.createGraphics();
        this.paint(g2d, width, height);
        return bi;
    }

    private void initGraphics() {
        this.graphics = this.base.dimension == 2 ? new Graphics(new Projection2D(this)) : new Graphics(new Projection3D(this));
    }

    private void initBase(double[] lowerBound, double[] upperBound, boolean extendBound) {
        this.base = new Base(lowerBound, upperBound, extendBound);
        this.axis = new Axis[this.base.getDimension()];
        for (int i = 0; i < this.base.getDimension(); ++i) {
            this.axis[i] = new Axis(this.base, i);
        }
    }

    void resetAxis() {
        for (int i = 0; i < this.axis.length; ++i) {
            this.axis[i].reset();
        }
    }

    public boolean isLegendVisible() {
        return this.isLegendVisible;
    }

    public Canvas setLegendVisible(boolean visible) {
        this.isLegendVisible = visible;
        return this;
    }

    public double getMargin() {
        return this.margin;
    }

    public Canvas setMargin(double margin) {
        if (margin < 0.0 || margin >= 0.3) {
            throw new IllegalArgumentException("Invalid margin: " + margin);
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "margin", this.margin, margin);
        this.margin = margin;
        this.pcs.firePropertyChange(event);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public Canvas setTitle(String title) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "title", this.title, title);
        this.title = title;
        this.pcs.firePropertyChange(event);
        return this;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Canvas setTitleFont(Font font) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "titleFont", this.titleFont, font);
        this.titleFont = font;
        this.pcs.firePropertyChange(event);
        return this;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Canvas setTitleColor(Color color) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "titleColor", this.titleColor, color);
        this.titleColor = color;
        this.pcs.firePropertyChange(event);
        return this;
    }

    public Axis getAxis(int i) {
        return this.axis[i];
    }

    public String[] getAxisLabels() {
        String[] labels = new String[this.base.dimension];
        for (int i = 0; i < this.base.dimension; ++i) {
            labels[i] = this.axis[i].getLabel();
        }
        return labels;
    }

    public String getAxisLabel(int i) {
        return this.axis[i].getLabel();
    }

    public Canvas setAxisLabels(String ... labels) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "axisLabels", this.getAxisLabels(), labels);
        for (int i = 0; i < labels.length; ++i) {
            this.axis[i].setLabel(labels[i]);
        }
        this.pcs.firePropertyChange(event);
        return this;
    }

    public Canvas setAxisLabel(int i, String label) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "axisLabel", this.axis[i].getLabel(), label);
        this.axis[i].setLabel(label);
        this.pcs.firePropertyChange(event);
        return this;
    }

    public List<Shape> getShapes() {
        return this.shapes;
    }

    public void add(Shape p) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "addShape", this, p);
        this.shapes.add(p);
        this.pcs.firePropertyChange(event);
    }

    public void remove(Shape p) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "removeShape", this, p);
        this.shapes.remove(p);
        this.pcs.firePropertyChange(event);
    }

    public void add(Plot p) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "addPlot", this, p);
        this.shapes.add(p);
        this.extendBound(p.getLowerBound(), p.getUpperBound());
        this.pcs.firePropertyChange(event);
    }

    public void remove(Plot p) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "removePlot", this, p);
        this.shapes.remove(p);
        this.pcs.firePropertyChange(event);
    }

    public void clear() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "clear", this, null);
        this.shapes.clear();
        this.pcs.firePropertyChange(event);
    }

    public double[] getLowerBounds() {
        return this.base.lowerBound;
    }

    public double[] getUpperBounds() {
        return this.base.upperBound;
    }

    public void extendLowerBound(double[] bound) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "extendLowerBound", this, bound);
        this.base.extendLowerBound(bound);
        this.resetAxis();
        this.pcs.firePropertyChange(event);
    }

    public void extendUpperBound(double[] bound) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "extendUpperBound", this, bound);
        this.base.extendUpperBound(bound);
        this.resetAxis();
        this.pcs.firePropertyChange(event);
    }

    public void extendBound(double[] lowerBound, double[] upperBound) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "extendBound", this, new double[][]{lowerBound, upperBound});
        this.base.extendBound(lowerBound, upperBound);
        this.resetAxis();
        this.pcs.firePropertyChange(event);
    }

    public void setBound(double[] lowerBound, double[] upperBound) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "setBound", this, new double[][]{lowerBound, upperBound});
        this.base.setBound(lowerBound, upperBound);
        this.resetAxis();
        this.pcs.firePropertyChange(event);
    }

    public void paint(Graphics2D g2d, int width, int height) {
        int y;
        int i;
        this.graphics.setGraphics(g2d, width, height);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        for (i = 0; i < this.axis.length; ++i) {
            this.axis[i].paint(this.graphics);
        }
        this.graphics.clip();
        for (i = 0; i < this.shapes.size(); ++i) {
            Shape shape = this.shapes.get(i);
            this.graphics.setColor(shape.color);
            shape.paint(this.graphics);
        }
        this.graphics.clearClip();
        if (this.isLegendVisible) {
            Font font = g2d.getFont();
            int x = (int)((double)width * (1.0 - this.margin) + 20.0);
            y = (int)((double)height * this.margin + 50.0);
            int fontWidth = font.getSize();
            int fontHeight = font.getSize();
            for (int i2 = 0; i2 < this.shapes.size(); ++i2) {
                Plot p;
                Shape s = this.shapes.get(i2);
                if (!(s instanceof Plot) || !(p = (Plot)s).legends().isPresent()) continue;
                for (Legend legend : p.legends().get()) {
                    g2d.setColor(legend.color);
                    g2d.fillRect(x, y, fontWidth, fontHeight);
                    g2d.drawRect(x, y, fontWidth, fontHeight);
                    g2d.drawString(legend.text, x + 2 * fontWidth, y + fontHeight);
                    y += 2 * fontWidth;
                }
            }
        }
        if (this.title != null) {
            g2d.setFont(this.titleFont);
            g2d.setColor(this.titleColor);
            FontMetrics fm = g2d.getFontMetrics();
            int x = (width - fm.stringWidth(this.title)) / 2;
            y = (int)((double)height * this.margin) / 2;
            g2d.drawString(this.title, x, y);
        }
    }

    public PlotPanel panel() {
        final PlotPanel panel = new PlotPanel(this);
        panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                panel.reset();
                panel.repaint();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                panel.reset();
                panel.repaint();
            }
        });
        return panel;
    }

    public JFrame window() throws InterruptedException, InvocationTargetException {
        return this.panel().window();
    }
}

