/*
 * Decompiled with CFR 0.152.
 */
package smile.plot.swing;

import java.util.Arrays;
import java.util.Optional;
import smile.math.MathEx;
import smile.plot.swing.Canvas;
import smile.plot.swing.Graphics;
import smile.plot.swing.Plot;

public class BoxPlot
extends Plot {
    private static String format = "<table border=\"1\"><tr><td>Median</td><td align=\"right\">%g</td></tr><tr><td>Q1</td><td align=\"right\">%g</td></tr><tr><td>Q3</td><td align=\"right\">%g</td></tr></table>";
    private double[][] data;
    private String[] labels;
    private double[][] quantiles;

    public BoxPlot(double[][] data, String[] labels) {
        if (labels != null && labels.length != data.length) {
            throw new IllegalArgumentException("Data size and label size don't match.");
        }
        this.data = data;
        this.labels = labels;
        this.quantiles = new double[data.length][8];
        for (int i = 0; i < data.length; ++i) {
            int n = data[i].length;
            Arrays.sort(data[i]);
            this.quantiles[i][1] = data[i][n / 4];
            this.quantiles[i][2] = data[i][n / 2];
            this.quantiles[i][3] = data[i][3 * n / 4];
            this.quantiles[i][5] = this.quantiles[i][3] - this.quantiles[i][1];
            this.quantiles[i][6] = this.quantiles[i][1] - 1.5 * this.quantiles[i][5];
            this.quantiles[i][7] = this.quantiles[i][3] + 1.5 * this.quantiles[i][5];
            this.quantiles[i][0] = this.quantiles[i][6] < data[i][0] ? data[i][0] : this.quantiles[i][6];
            this.quantiles[i][4] = this.quantiles[i][7] > data[i][data[i].length - 1] ? data[i][data[i].length - 1] : this.quantiles[i][7];
        }
    }

    @Override
    public Optional<String> tooltip(double[] coord) {
        String tooltip = null;
        for (int i = 0; i < this.data.length; ++i) {
            if (!(coord[0] < (double)i + 0.8) || !(coord[0] > (double)i + 0.2) || !(coord[1] < this.quantiles[i][3]) || !(coord[1] > this.quantiles[i][1])) continue;
            tooltip = String.format(format, this.quantiles[i][2], this.quantiles[i][1], this.quantiles[i][3]);
            break;
        }
        return Optional.ofNullable(tooltip);
    }

    @Override
    public double[] getLowerBound() {
        double[] bound = new double[]{0.0, MathEx.min((double[][])this.data)};
        return bound;
    }

    @Override
    public double[] getUpperBound() {
        double[] bound = new double[]{this.data.length, MathEx.max((double[][])this.data)};
        return bound;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        double[] start = new double[2];
        double[] end = new double[2];
        for (int i = 0; i < this.data.length; ++i) {
            start[0] = (double)i + 0.4;
            start[1] = this.quantiles[i][0];
            end[0] = (double)i + 0.6;
            end[1] = this.quantiles[i][0];
            g.drawLine(start, end);
            start[0] = (double)i + 0.4;
            start[1] = this.quantiles[i][4];
            end[0] = (double)i + 0.6;
            end[1] = this.quantiles[i][4];
            g.drawLine(start, end);
            start[0] = (double)i + 0.2;
            start[1] = this.quantiles[i][2];
            end[0] = (double)i + 0.8;
            end[1] = this.quantiles[i][2];
            g.drawLine(start, end);
            start[0] = (double)i + 0.5;
            start[1] = this.quantiles[i][0];
            end[0] = (double)i + 0.5;
            end[1] = this.quantiles[i][1];
            g.drawLine(start, end);
            start[0] = (double)i + 0.5;
            start[1] = this.quantiles[i][4];
            end[0] = (double)i + 0.5;
            end[1] = this.quantiles[i][3];
            g.drawLine(start, end);
            start[0] = (double)i + 0.2;
            start[1] = this.quantiles[i][3];
            end[0] = (double)i + 0.8;
            end[1] = this.quantiles[i][1];
            g.drawRect(start, end);
            start[0] = (double)i + 0.5;
            for (int j = 0; j < this.data[i].length; ++j) {
                if (!(this.data[i][j] < this.quantiles[i][6]) && !(this.data[i][j] > this.quantiles[i][7])) continue;
                start[1] = this.data[i][j];
                g.drawPoint('o', start);
            }
        }
    }

    @Override
    public Canvas canvas() {
        double[] lowerBound = this.getLowerBound();
        double[] upperBound = this.getUpperBound();
        Canvas canvas = new Canvas(lowerBound, upperBound);
        canvas.add(this);
        canvas.getAxis(0).setGridVisible(false);
        if (this.labels != null) {
            int k = this.labels.length;
            double[] locations = new double[k];
            for (int i = 0; i < k; ++i) {
                locations[i] = (double)i + 0.5;
            }
            canvas.getAxis(0).setTicks(this.labels, locations);
            if (k > 10) {
                canvas.getAxis(0).setRotation(-1.5707963267948966);
            }
        } else {
            canvas.getAxis(0).setTickVisible(false);
        }
        return canvas;
    }

    public static BoxPlot of(double[] ... data) {
        return new BoxPlot(data, null);
    }
}

