/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.Color;
import smile.math.Math;
import smile.plot.Graphics;
import smile.plot.Plot;
import smile.plot.PlotCanvas;
import smile.plot.Projection3D;
import smile.sort.QuickSort;

public class Surface
extends Plot {
    private double[][][] data;
    private double[][] zc;
    private double[] az;
    private int[] order;
    private int[][] triangles;
    private double min;
    private double max;
    private double width = 1.0;
    private Color[] palette;

    public Surface(double[][] z) {
        super(Color.GRAY);
        this.init(z);
    }

    private void init(double[][] z) {
        this.max = Math.max((double[][])z);
        this.min = Math.min((double[][])z);
        if (this.palette != null) {
            this.width = (this.max - this.min) / (double)this.palette.length;
        }
        int m = z.length;
        int n = z[0].length;
        this.triangles = new int[2 * m * n][6];
        this.az = new double[2 * m * n];
        this.order = new int[this.az.length];
        this.zc = new double[m][n];
        this.data = new double[m][n][3];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                this.data[i][j][0] = (double)i + 0.5;
                this.data[i][j][1] = (double)j + 0.5;
                this.data[i][j][2] = z[i][j];
                if (i < m - 1 && j < n - 1) {
                    this.triangles[k][0] = i;
                    this.triangles[k][1] = j;
                    this.triangles[k][2] = i + 1;
                    this.triangles[k][3] = j;
                    this.triangles[k][4] = i;
                    this.triangles[k][5] = j + 1;
                    this.triangles[k + 1][0] = i + 1;
                    this.triangles[k + 1][1] = j + 1;
                    this.triangles[k + 1][2] = i + 1;
                    this.triangles[k + 1][3] = j;
                    this.triangles[k + 1][4] = i;
                    this.triangles[k + 1][5] = j + 1;
                }
                ++j;
                k += 2;
            }
        }
    }

    public Surface(double[][] z, Color[] palette) {
        this.palette = palette;
        this.init(z);
    }

    public Surface(double[] x, double[] y, double[][] z) {
        super(Color.GRAY);
        this.init(x, y, z);
    }

    private void init(double[] x, double[] y, double[][] z) {
        this.max = Math.max((double[][])z);
        this.min = Math.min((double[][])z);
        if (this.palette != null) {
            this.width = (this.max - this.min) / (double)this.palette.length;
        }
        int m = z.length;
        int n = z[0].length;
        this.triangles = new int[2 * m * n][6];
        this.az = new double[2 * m * n];
        this.order = new int[this.az.length];
        this.zc = new double[m][n];
        this.data = new double[m][n][3];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                this.data[i][j][0] = x[i];
                this.data[i][j][1] = y[j];
                this.data[i][j][2] = z[i][j];
                if (i < m - 1 && j < n - 1) {
                    this.triangles[k][0] = i;
                    this.triangles[k][1] = j;
                    this.triangles[k][2] = i + 1;
                    this.triangles[k][3] = j;
                    this.triangles[k][4] = i;
                    this.triangles[k][5] = j + 1;
                    this.triangles[k + 1][0] = i + 1;
                    this.triangles[k + 1][1] = j + 1;
                    this.triangles[k + 1][2] = i + 1;
                    this.triangles[k + 1][3] = j;
                    this.triangles[k + 1][4] = i;
                    this.triangles[k + 1][5] = j + 1;
                }
                ++j;
                k += 2;
            }
        }
    }

    public Surface(double[] x, double[] y, double[][] z, Color[] palette) {
        this.palette = palette;
        this.init(x, y, z);
    }

    public Surface(double[][][] data) {
        super(Color.GRAY);
        this.init(data);
    }

    private void init(double[][][] data) {
        this.data = data;
        int m = data.length;
        int n = data[0].length;
        this.zc = new double[m][n];
        this.triangles = new int[2 * m * n][6];
        this.az = new double[2 * m * n];
        this.order = new int[this.az.length];
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        int k = 0;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                double z = data[i][j][2];
                if (z < this.min) {
                    this.min = z;
                }
                if (z > this.max) {
                    this.max = z;
                }
                if (i < m - 1 && j < n - 1) {
                    this.triangles[k][0] = i;
                    this.triangles[k][1] = j;
                    this.triangles[k][2] = i + 1;
                    this.triangles[k][3] = j;
                    this.triangles[k][4] = i;
                    this.triangles[k][5] = j + 1;
                    this.triangles[k + 1][0] = i + 1;
                    this.triangles[k + 1][1] = j + 1;
                    this.triangles[k + 1][2] = i + 1;
                    this.triangles[k + 1][3] = j;
                    this.triangles[k + 1][4] = i;
                    this.triangles[k + 1][5] = j + 1;
                }
                ++j;
                k += 2;
            }
        }
        if (this.palette != null) {
            this.width = (this.max - this.min) / (double)this.palette.length;
        }
    }

    public Surface(double[][][] data, Color[] palette) {
        this.palette = palette;
        this.init(data);
    }

    @Override
    public void paint(Graphics g) {
        int j;
        int i;
        Color c = g.getColor();
        g.setColor(this.getColor());
        for (i = 0; i < this.data.length; ++i) {
            for (j = 0; j < this.data[i].length - 1; ++j) {
                g.drawLine(this.data[i][j], this.data[i][j + 1]);
            }
        }
        for (i = 0; i < this.data.length - 1; ++i) {
            for (j = 0; j < this.data[i].length; ++j) {
                g.drawLine(this.data[i][j], this.data[i + 1][j]);
            }
        }
        if (this.palette != null) {
            int i2;
            int m = this.data.length;
            int n = this.data[0].length;
            Projection3D p3d = (Projection3D)g.projection;
            for (i2 = 0; i2 < m; ++i2) {
                for (int j2 = 0; j2 < n; ++j2) {
                    this.zc[i2][j2] = p3d.z(this.data[i2][j2]);
                }
            }
            for (i2 = 0; i2 < this.triangles.length; ++i2) {
                this.az[i2] = this.zc[this.triangles[i2][0]][this.triangles[i2][1]] + this.zc[this.triangles[i2][2]][this.triangles[i2][3]] + this.zc[this.triangles[i2][4]][this.triangles[i2][5]];
            }
            for (i2 = 0; i2 < this.order.length; ++i2) {
                this.order[i2] = i2;
            }
            QuickSort.sort((double[])this.az, (int[])this.order);
            for (int i3 : this.order) {
                double avg = (this.data[this.triangles[i3][0]][this.triangles[i3][1]][2] + this.data[this.triangles[i3][2]][this.triangles[i3][3]][2] + this.data[this.triangles[i3][4]][this.triangles[i3][5]][2]) / 3.0;
                int k = (int)((avg - this.min) / this.width);
                if (k == this.palette.length) {
                    k = this.palette.length - 1;
                }
                g.setColor(this.palette[k]);
                g.fillPolygon(this.data[this.triangles[i3][0]][this.triangles[i3][1]], this.data[this.triangles[i3][2]][this.triangles[i3][3]], this.data[this.triangles[i3][4]][this.triangles[i3][5]]);
            }
        }
        g.setColor(c);
    }

    public static PlotCanvas plot(double[][] z) {
        double[] lowerBound = new double[]{0.0, 0.0, Math.min((double[][])z)};
        double[] upperBound = new double[]{z.length, z[0].length, Math.max((double[][])z)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(z);
        canvas.add(surface);
        return canvas;
    }

    public static PlotCanvas plot(double[][] z, Color[] palette) {
        double[] lowerBound = new double[]{0.0, 0.0, Math.min((double[][])z)};
        double[] upperBound = new double[]{z.length, z[0].length, Math.max((double[][])z)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(z, palette);
        canvas.add(surface);
        return canvas;
    }

    public static PlotCanvas plot(double[] x, double[] y, double[][] z) {
        double[] lowerBound = new double[]{Math.min((double[])x), Math.min((double[])y), Math.min((double[][])z)};
        double[] upperBound = new double[]{Math.max((double[])x), Math.max((double[])y), Math.max((double[][])z)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(x, y, z);
        canvas.add(surface);
        return canvas;
    }

    public static PlotCanvas plot(double[] x, double[] y, double[][] z, Color[] palette) {
        double[] lowerBound = new double[]{Math.min((double[])x), Math.min((double[])y), Math.min((double[][])z)};
        double[] upperBound = new double[]{Math.max((double[])x), Math.max((double[])y), Math.max((double[][])z)};
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(x, y, z, palette);
        canvas.add(surface);
        return canvas;
    }

    public static PlotCanvas plot(double[][][] data) {
        double[] lowerBound = new double[]{data[0][0][0], data[0][0][1], data[0][0][2]};
        double[] upperBound = new double[]{data[0][0][0], data[0][0][1], data[0][0][2]};
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j][0] < lowerBound[0]) {
                    lowerBound[0] = data[i][j][0];
                }
                if (data[i][j][0] > upperBound[0]) {
                    upperBound[0] = data[i][j][0];
                }
                if (data[i][j][1] < lowerBound[1]) {
                    lowerBound[1] = data[i][j][1];
                }
                if (data[i][j][1] > upperBound[1]) {
                    upperBound[1] = data[i][j][1];
                }
                if (data[i][j][2] < lowerBound[2]) {
                    lowerBound[2] = data[i][j][2];
                }
                if (!(data[i][j][2] > upperBound[2])) continue;
                upperBound[2] = data[i][j][2];
            }
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(data);
        canvas.add(surface);
        return canvas;
    }

    public static PlotCanvas plot(double[][][] data, Color[] palette) {
        double[] lowerBound = new double[]{data[0][0][0], data[0][0][1], data[0][0][2]};
        double[] upperBound = new double[]{data[0][0][0], data[0][0][1], data[0][0][2]};
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                if (data[i][j][0] < lowerBound[0]) {
                    lowerBound[0] = data[i][j][0];
                }
                if (data[i][j][0] > upperBound[0]) {
                    upperBound[0] = data[i][j][0];
                }
                if (data[i][j][1] < lowerBound[1]) {
                    lowerBound[1] = data[i][j][1];
                }
                if (data[i][j][1] > upperBound[1]) {
                    upperBound[1] = data[i][j][1];
                }
                if (data[i][j][2] < lowerBound[2]) {
                    lowerBound[2] = data[i][j][2];
                }
                if (!(data[i][j][2] > upperBound[2])) continue;
                upperBound[2] = data[i][j][2];
            }
        }
        PlotCanvas canvas = new PlotCanvas(lowerBound, upperBound);
        Surface surface = new Surface(data, palette);
        canvas.add(surface);
        return canvas;
    }
}

