/*
 * Decompiled with CFR 0.152.
 */
package smile.math.blas.mkl;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.bytedeco.mkl.global.mkl_rt;
import smile.math.blas.BLAS;
import smile.math.blas.Diag;
import smile.math.blas.EVDJob;
import smile.math.blas.EigenRange;
import smile.math.blas.LAPACK;
import smile.math.blas.Layout;
import smile.math.blas.SVDJob;
import smile.math.blas.Side;
import smile.math.blas.Transpose;
import smile.math.blas.UPLO;

public class MKL
implements BLAS,
LAPACK {
    public double asum(int n, double[] x, int incx) {
        return mkl_rt.cblas_dasum((int)n, (double[])x, (int)incx);
    }

    public float asum(int n, float[] x, int incx) {
        return mkl_rt.cblas_sasum((int)n, (float[])x, (int)incx);
    }

    public void axpy(int n, double alpha, double[] x, int incx, double[] y, int incy) {
        mkl_rt.cblas_daxpy((int)n, (double)alpha, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    public void axpy(int n, float alpha, float[] x, int incx, float[] y, int incy) {
        mkl_rt.cblas_saxpy((int)n, (float)alpha, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    public double dot(int n, double[] x, int incx, double[] y, int incy) {
        return mkl_rt.cblas_ddot((int)n, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    public float dot(int n, float[] x, int incx, float[] y, int incy) {
        return mkl_rt.cblas_sdot((int)n, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    public double nrm2(int n, double[] x, int incx) {
        return mkl_rt.cblas_dnrm2((int)n, (double[])x, (int)incx);
    }

    public float nrm2(int n, float[] x, int incx) {
        return mkl_rt.cblas_snrm2((int)n, (float[])x, (int)incx);
    }

    public void scal(int n, double alpha, double[] x, int incx) {
        mkl_rt.cblas_dscal((int)n, (double)alpha, (double[])x, (int)incx);
    }

    public void scal(int n, float alpha, float[] x, int incx) {
        mkl_rt.cblas_sscal((int)n, (float)alpha, (float[])x, (int)incx);
    }

    public void swap(int n, double[] x, int incx, double[] y, int incy) {
        mkl_rt.cblas_dswap((int)n, (double[])x, (int)incx, (double[])y, (int)incy);
    }

    public void swap(int n, float[] x, int incx, float[] y, int incy) {
        mkl_rt.cblas_sswap((int)n, (float[])x, (int)incx, (float[])y, (int)incy);
    }

    public long iamax(int n, double[] x, int incx) {
        return mkl_rt.cblas_idamax((int)n, (double[])x, (int)incx);
    }

    public long iamax(int n, float[] x, int incx) {
        return mkl_rt.cblas_isamax((int)n, (float[])x, (int)incx);
    }

    public void gemv(Layout layout, Transpose trans, int m, int n, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        mkl_rt.cblas_dgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    public void gemv(Layout layout, Transpose trans, int m, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        mkl_rt.cblas_dgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    public void gemv(Layout layout, Transpose trans, int m, int n, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        mkl_rt.cblas_sgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    public void gemv(Layout layout, Transpose trans, int m, int n, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        mkl_rt.cblas_sgemv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    public void symv(Layout layout, UPLO uplo, int n, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        mkl_rt.cblas_dsymv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    public void symv(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        mkl_rt.cblas_dsymv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    public void symv(Layout layout, UPLO uplo, int n, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        mkl_rt.cblas_ssymv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    public void symv(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        mkl_rt.cblas_ssymv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    public void spmv(Layout layout, UPLO uplo, int n, double alpha, double[] A, double[] x, int incx, double beta, double[] y, int incy) {
        mkl_rt.cblas_dspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])A, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    public void spmv(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer A, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        mkl_rt.cblas_dspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)A, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    public void spmv(Layout layout, UPLO uplo, int n, float alpha, float[] A, float[] x, int incx, float beta, float[] y, int incy) {
        mkl_rt.cblas_sspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])A, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    public void spmv(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer A, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        mkl_rt.cblas_sspmv((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)A, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, double[] A, int lda, double[] x, int incx) {
        mkl_rt.cblas_dtrmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (double[])A, (int)lda, (double[])x, (int)incx);
    }

    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, DoubleBuffer A, int lda, DoubleBuffer x, int incx) {
        mkl_rt.cblas_dtrmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx);
    }

    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, float[] A, int lda, float[] x, int incx) {
        mkl_rt.cblas_strmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (float[])A, (int)lda, (float[])x, (int)incx);
    }

    public void trmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, FloatBuffer A, int lda, FloatBuffer x, int incx) {
        mkl_rt.cblas_strmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx);
    }

    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, double[] A, double[] x, int incx) {
        mkl_rt.cblas_dtpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (double[])A, (double[])x, (int)incx);
    }

    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, DoubleBuffer A, DoubleBuffer x, int incx) {
        mkl_rt.cblas_dtpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (DoubleBuffer)A, (DoubleBuffer)x, (int)incx);
    }

    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, float[] A, float[] x, int incx) {
        mkl_rt.cblas_stpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (float[])A, (float[])x, (int)incx);
    }

    public void tpmv(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, FloatBuffer A, FloatBuffer x, int incx) {
        mkl_rt.cblas_stpmv((int)layout.blas(), (int)uplo.blas(), (int)trans.blas(), (int)diag.blas(), (int)n, (FloatBuffer)A, (FloatBuffer)x, (int)incx);
    }

    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        mkl_rt.cblas_dgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        mkl_rt.cblas_dgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        mkl_rt.cblas_sgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    public void gbmv(Layout layout, Transpose trans, int m, int n, int kl, int ku, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        mkl_rt.cblas_sgbmv((int)layout.blas(), (int)trans.blas(), (int)m, (int)n, (int)kl, (int)ku, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    public void sbmv(Layout layout, UPLO uplo, int n, int k, double alpha, double[] A, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        mkl_rt.cblas_dsbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (double)alpha, (double[])A, (int)lda, (double[])x, (int)incx, (double)beta, (double[])y, (int)incy);
    }

    public void sbmv(Layout layout, UPLO uplo, int n, int k, double alpha, DoubleBuffer A, int lda, DoubleBuffer x, int incx, double beta, DoubleBuffer y, int incy) {
        mkl_rt.cblas_dsbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)x, (int)incx, (double)beta, (DoubleBuffer)y, (int)incy);
    }

    public void sbmv(Layout layout, UPLO uplo, int n, int k, float alpha, float[] A, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        mkl_rt.cblas_ssbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (float)alpha, (float[])A, (int)lda, (float[])x, (int)incx, (float)beta, (float[])y, (int)incy);
    }

    public void sbmv(Layout layout, UPLO uplo, int n, int k, float alpha, FloatBuffer A, int lda, FloatBuffer x, int incx, float beta, FloatBuffer y, int incy) {
        mkl_rt.cblas_ssbmv((int)layout.blas(), (int)uplo.blas(), (int)n, (int)k, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)x, (int)incx, (float)beta, (FloatBuffer)y, (int)incy);
    }

    public void ger(Layout layout, int m, int n, double alpha, double[] x, int incx, double[] y, int incy, double[] A, int lda) {
        mkl_rt.cblas_dger((int)layout.blas(), (int)m, (int)n, (double)alpha, (double[])x, (int)incx, (double[])y, (int)incy, (double[])A, (int)lda);
    }

    public void ger(Layout layout, int m, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer y, int incy, DoubleBuffer A, int lda) {
        mkl_rt.cblas_dger((int)layout.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)y, (int)incy, (DoubleBuffer)A, (int)lda);
    }

    public void ger(Layout layout, int m, int n, float alpha, float[] x, int incx, float[] y, int incy, float[] A, int lda) {
        mkl_rt.cblas_sger((int)layout.blas(), (int)m, (int)n, (float)alpha, (float[])x, (int)incx, (float[])y, (int)incy, (float[])A, (int)lda);
    }

    public void ger(Layout layout, int m, int n, float alpha, FloatBuffer x, int incx, FloatBuffer y, int incy, FloatBuffer A, int lda) {
        mkl_rt.cblas_sger((int)layout.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)y, (int)incy, (FloatBuffer)A, (int)lda);
    }

    public void syr(Layout layout, UPLO uplo, int n, double alpha, double[] x, int incx, double[] A, int lda) {
        mkl_rt.cblas_dsyr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])x, (int)incx, (double[])A, (int)lda);
    }

    public void syr(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer A, int lda) {
        mkl_rt.cblas_dsyr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)A, (int)lda);
    }

    public void syr(Layout layout, UPLO uplo, int n, float alpha, float[] x, int incx, float[] A, int lda) {
        mkl_rt.cblas_ssyr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])x, (int)incx, (float[])A, (int)lda);
    }

    public void syr(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer x, int incx, FloatBuffer A, int lda) {
        mkl_rt.cblas_ssyr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)A, (int)lda);
    }

    public void spr(Layout layout, UPLO uplo, int n, double alpha, double[] x, int incx, double[] A) {
        mkl_rt.cblas_dspr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (double[])x, (int)incx, (double[])A);
    }

    public void spr(Layout layout, UPLO uplo, int n, double alpha, DoubleBuffer x, int incx, DoubleBuffer A) {
        mkl_rt.cblas_dspr((int)layout.blas(), (int)uplo.blas(), (int)n, (double)alpha, (DoubleBuffer)x, (int)incx, (DoubleBuffer)A);
    }

    public void spr(Layout layout, UPLO uplo, int n, float alpha, float[] x, int incx, float[] A) {
        mkl_rt.cblas_sspr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (float[])x, (int)incx, (float[])A);
    }

    public void spr(Layout layout, UPLO uplo, int n, float alpha, FloatBuffer x, int incx, FloatBuffer A) {
        mkl_rt.cblas_sspr((int)layout.blas(), (int)uplo.blas(), (int)n, (float)alpha, (FloatBuffer)x, (int)incx, (FloatBuffer)A);
    }

    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        mkl_rt.cblas_dgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (double)alpha, (double[])A, (int)lda, (double[])B, (int)ldb, (double)beta, (double[])C, (int)ldc);
    }

    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, double alpha, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, double beta, DoubleBuffer C, int ldc) {
        mkl_rt.cblas_dgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (double)beta, (DoubleBuffer)C, (int)ldc);
    }

    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, float alpha, float[] A, int lda, float[] B, int ldb, float beta, float[] C, int ldc) {
        mkl_rt.cblas_sgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (float)alpha, (float[])A, (int)lda, (float[])B, (int)ldb, (float)beta, (float[])C, (int)ldc);
    }

    public void gemm(Layout layout, Transpose transA, Transpose transB, int m, int n, int k, float alpha, FloatBuffer A, int lda, FloatBuffer B, int ldb, float beta, FloatBuffer C, int ldc) {
        mkl_rt.cblas_sgemm((int)layout.blas(), (int)transA.blas(), (int)transB.blas(), (int)m, (int)n, (int)k, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (float)beta, (FloatBuffer)C, (int)ldc);
    }

    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, double alpha, double[] A, int lda, double[] B, int ldb, double beta, double[] C, int ldc) {
        mkl_rt.cblas_dsymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (double)alpha, (double[])A, (int)lda, (double[])B, (int)ldb, (double)beta, (double[])C, (int)ldc);
    }

    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, double alpha, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, double beta, DoubleBuffer C, int ldc) {
        mkl_rt.cblas_dsymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (double)alpha, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (double)beta, (DoubleBuffer)C, (int)ldc);
    }

    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, float alpha, float[] A, int lda, float[] B, int ldb, float beta, float[] C, int ldc) {
        mkl_rt.cblas_ssymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (float)alpha, (float[])A, (int)lda, (float[])B, (int)ldb, (float)beta, (float[])C, (int)ldc);
    }

    public void symm(Layout layout, Side side, UPLO uplo, int m, int n, float alpha, FloatBuffer A, int lda, FloatBuffer B, int ldb, float beta, FloatBuffer C, int ldc) {
        mkl_rt.cblas_ssymm((int)layout.blas(), (int)side.blas(), (int)uplo.blas(), (int)m, (int)n, (float)alpha, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (float)beta, (FloatBuffer)C, (int)ldc);
    }

    public int gesv(Layout layout, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dgesv((int)layout.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int gesv(Layout layout, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dgesv((int)layout.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int gesv(Layout layout, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sgesv((int)layout.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int gesv(Layout layout, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sgesv((int)layout.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dsysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dsysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_ssysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int sysv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_ssysv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int spsv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sspsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int posv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    public int posv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    public int posv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    public int posv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sposv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, double[] A, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (double[])B, (int)ldb);
    }

    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (DoubleBuffer)B, (int)ldb);
    }

    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, float[] A, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (float[])B, (int)ldb);
    }

    public int ppsv(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sppsv((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (FloatBuffer)B, (int)ldb);
    }

    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int gbsv(Layout layout, int n, int kl, int ku, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sgbsv((int)layout.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    public int gels(Layout layout, Transpose trans, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sgels((int)layout.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    public int gelsy(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, int[] jpvt, double rcond, int[] rank) {
        return mkl_rt.LAPACKE_dgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (int[])jpvt, (double)rcond, (int[])rank);
    }

    public int gelsy(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, IntBuffer jpvt, double rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_dgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (IntBuffer)jpvt, (double)rcond, (IntBuffer)rank);
    }

    public int gelsy(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, int[] jpvt, float rcond, int[] rank) {
        return mkl_rt.LAPACKE_sgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (int[])jpvt, (float)rcond, (int[])rank);
    }

    public int gelsy(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, IntBuffer jpvt, float rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_sgelsy((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (IntBuffer)jpvt, (float)rcond, (IntBuffer)rank);
    }

    public int gelss(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, double[] s, double rcond, int[] rank) {
        return mkl_rt.LAPACKE_dgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])s, (double)rcond, (int[])rank);
    }

    public int gelss(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer s, double rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_dgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)s, (double)rcond, (IntBuffer)rank);
    }

    public int gelss(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, float[] s, float rcond, int[] rank) {
        return mkl_rt.LAPACKE_sgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])s, (float)rcond, (int[])rank);
    }

    public int gelss(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer s, float rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_sgelss((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)s, (float)rcond, (IntBuffer)rank);
    }

    public int gelsd(Layout layout, int m, int n, int nrhs, double[] A, int lda, double[] B, int ldb, double[] s, double rcond, int[] rank) {
        return mkl_rt.LAPACKE_dgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])s, (double)rcond, (int[])rank);
    }

    public int gelsd(Layout layout, int m, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer s, double rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_dgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)s, (double)rcond, (IntBuffer)rank);
    }

    public int gelsd(Layout layout, int m, int n, int nrhs, float[] A, int lda, float[] B, int ldb, float[] s, float rcond, int[] rank) {
        return mkl_rt.LAPACKE_sgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])s, (float)rcond, (int[])rank);
    }

    public int gelsd(Layout layout, int m, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer s, float rcond, IntBuffer rank) {
        return mkl_rt.LAPACKE_sgelsd((int)layout.lapack(), (int)m, (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)s, (float)rcond, (IntBuffer)rank);
    }

    public int gglse(Layout layout, int m, int n, int p, double[] A, int lda, double[] B, int ldb, double[] c, double[] d, double[] x) {
        return mkl_rt.LAPACKE_dgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])c, (double[])d, (double[])x);
    }

    public int gglse(Layout layout, int m, int n, int p, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer c, DoubleBuffer d, DoubleBuffer x) {
        return mkl_rt.LAPACKE_dgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)c, (DoubleBuffer)d, (DoubleBuffer)x);
    }

    public int gglse(Layout layout, int m, int n, int p, float[] A, int lda, float[] B, int ldb, float[] c, float[] d, float[] x) {
        return mkl_rt.LAPACKE_sgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])c, (float[])d, (float[])x);
    }

    public int gglse(Layout layout, int m, int n, int p, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer c, FloatBuffer d, FloatBuffer x) {
        return mkl_rt.LAPACKE_sgglse((int)layout.lapack(), (int)m, (int)n, (int)p, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)c, (FloatBuffer)d, (FloatBuffer)x);
    }

    public int ggglm(Layout layout, int n, int m, int p, double[] A, int lda, double[] B, int ldb, double[] d, double[] x, double[] y) {
        return mkl_rt.LAPACKE_dggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (double[])A, (int)lda, (double[])B, (int)ldb, (double[])d, (double[])x, (double[])y);
    }

    public int ggglm(Layout layout, int n, int m, int p, DoubleBuffer A, int lda, DoubleBuffer B, int ldb, DoubleBuffer d, DoubleBuffer x, DoubleBuffer y) {
        return mkl_rt.LAPACKE_dggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb, (DoubleBuffer)d, (DoubleBuffer)x, (DoubleBuffer)y);
    }

    public int ggglm(Layout layout, int n, int m, int p, float[] A, int lda, float[] B, int ldb, float[] d, float[] x, float[] y) {
        return mkl_rt.LAPACKE_sggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (float[])A, (int)lda, (float[])B, (int)ldb, (float[])d, (float[])x, (float[])y);
    }

    public int ggglm(Layout layout, int n, int m, int p, FloatBuffer A, int lda, FloatBuffer B, int ldb, FloatBuffer d, FloatBuffer x, FloatBuffer y) {
        return mkl_rt.LAPACKE_sggglm((int)layout.lapack(), (int)n, (int)m, (int)p, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb, (FloatBuffer)d, (FloatBuffer)x, (FloatBuffer)y);
    }

    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, double[] A, int lda, double[] wr, double[] wi, double[] Vl, int ldvl, double[] Vr, int ldvr) {
        return mkl_rt.LAPACKE_dgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (double[])A, (int)lda, (double[])wr, (double[])wi, (double[])Vl, (int)ldvl, (double[])Vr, (int)ldvr);
    }

    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, DoubleBuffer A, int lda, DoubleBuffer wr, DoubleBuffer wi, DoubleBuffer Vl, int ldvl, DoubleBuffer Vr, int ldvr) {
        return mkl_rt.LAPACKE_dgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)wr, (DoubleBuffer)wi, (DoubleBuffer)Vl, (int)ldvl, (DoubleBuffer)Vr, (int)ldvr);
    }

    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, float[] A, int lda, float[] wr, float[] wi, float[] Vl, int ldvl, float[] Vr, int ldvr) {
        return mkl_rt.LAPACKE_sgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (float[])A, (int)lda, (float[])wr, (float[])wi, (float[])Vl, (int)ldvl, (float[])Vr, (int)ldvr);
    }

    public int geev(Layout layout, EVDJob jobvl, EVDJob jobvr, int n, FloatBuffer A, int lda, FloatBuffer wr, FloatBuffer wi, FloatBuffer Vl, int ldvl, FloatBuffer Vr, int ldvr) {
        return mkl_rt.LAPACKE_sgeev((int)layout.lapack(), (byte)jobvl.lapack(), (byte)jobvr.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)wr, (FloatBuffer)wi, (FloatBuffer)Vl, (int)ldvl, (FloatBuffer)Vr, (int)ldvr);
    }

    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, double[] A, int lda, double[] w) {
        return mkl_rt.LAPACKE_dsyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double[])w);
    }

    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, DoubleBuffer A, int lda, DoubleBuffer w) {
        return mkl_rt.LAPACKE_dsyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)w);
    }

    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, float[] A, int lda, float[] w) {
        return mkl_rt.LAPACKE_ssyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float[])w);
    }

    public int syev(Layout layout, EVDJob jobz, UPLO uplo, int n, FloatBuffer A, int lda, FloatBuffer w) {
        return mkl_rt.LAPACKE_ssyev((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)w);
    }

    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, double[] A, int lda, double[] w) {
        return mkl_rt.LAPACKE_dsyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double[])w);
    }

    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, DoubleBuffer A, int lda, DoubleBuffer w) {
        return mkl_rt.LAPACKE_dsyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)w);
    }

    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, float[] A, int lda, float[] w) {
        return mkl_rt.LAPACKE_ssyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float[])w);
    }

    public int syevd(Layout layout, EVDJob jobz, UPLO uplo, int n, FloatBuffer A, int lda, FloatBuffer w) {
        return mkl_rt.LAPACKE_ssyevd((int)layout.lapack(), (byte)jobz.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)w);
    }

    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, double[] A, int lda, double vl, double vu, int il, int iu, double abstol, int[] m, double[] w, double[] Z, int ldz, int[] isuppz) {
        return mkl_rt.LAPACKE_dsyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (int[])m, (double[])w, (double[])Z, (int)ldz, (int[])isuppz);
    }

    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, DoubleBuffer A, int lda, double vl, double vu, int il, int iu, double abstol, IntBuffer m, DoubleBuffer w, DoubleBuffer Z, int ldz, IntBuffer isuppz) {
        return mkl_rt.LAPACKE_dsyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda, (double)vl, (double)vu, (int)il, (int)iu, (double)abstol, (IntBuffer)m, (DoubleBuffer)w, (DoubleBuffer)Z, (int)ldz, (IntBuffer)isuppz);
    }

    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, float[] A, int lda, float vl, float vu, int il, int iu, float abstol, int[] m, float[] w, float[] Z, int ldz, int[] isuppz) {
        return mkl_rt.LAPACKE_ssyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda, (float)vl, (float)vu, (int)il, (int)iu, (float)abstol, (int[])m, (float[])w, (float[])Z, (int)ldz, (int[])isuppz);
    }

    public int syevr(Layout layout, EVDJob jobz, EigenRange range, UPLO uplo, int n, FloatBuffer A, int lda, float vl, float vu, int il, int iu, float abstol, IntBuffer m, FloatBuffer w, FloatBuffer Z, int ldz, IntBuffer isuppz) {
        return mkl_rt.LAPACKE_ssyevr((int)layout.lapack(), (byte)jobz.lapack(), (byte)range.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda, (float)vl, (float)vu, (int)il, (int)iu, (float)abstol, (IntBuffer)m, (FloatBuffer)w, (FloatBuffer)Z, (int)ldz, (IntBuffer)isuppz);
    }

    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, double[] A, int lda, double[] s, double[] U, int ldu, double[] VT, int ldvt, double[] superb) {
        return mkl_rt.LAPACKE_dgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])s, (double[])U, (int)ldu, (double[])VT, (int)ldvt, (double[])superb);
    }

    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, DoubleBuffer A, int lda, DoubleBuffer s, DoubleBuffer U, int ldu, DoubleBuffer VT, int ldvt, DoubleBuffer superb) {
        return mkl_rt.LAPACKE_dgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)s, (DoubleBuffer)U, (int)ldu, (DoubleBuffer)VT, (int)ldvt, (DoubleBuffer)superb);
    }

    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, float[] A, int lda, float[] s, float[] U, int ldu, float[] VT, int ldvt, float[] superb) {
        return mkl_rt.LAPACKE_sgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])s, (float[])U, (int)ldu, (float[])VT, (int)ldvt, (float[])superb);
    }

    public int gesvd(Layout layout, SVDJob jobu, SVDJob jobvt, int m, int n, FloatBuffer A, int lda, FloatBuffer s, FloatBuffer U, int ldu, FloatBuffer VT, int ldvt, FloatBuffer superb) {
        return mkl_rt.LAPACKE_sgesvd((int)layout.lapack(), (byte)jobu.lapack(), (byte)jobvt.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)s, (FloatBuffer)U, (int)ldu, (FloatBuffer)VT, (int)ldvt, (FloatBuffer)superb);
    }

    public int gesdd(Layout layout, SVDJob jobz, int m, int n, double[] A, int lda, double[] s, double[] U, int ldu, double[] VT, int ldvt) {
        return mkl_rt.LAPACKE_dgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])s, (double[])U, (int)ldu, (double[])VT, (int)ldvt);
    }

    public int gesdd(Layout layout, SVDJob jobz, int m, int n, DoubleBuffer A, int lda, DoubleBuffer s, DoubleBuffer U, int ldu, DoubleBuffer VT, int ldvt) {
        return mkl_rt.LAPACKE_dgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)s, (DoubleBuffer)U, (int)ldu, (DoubleBuffer)VT, (int)ldvt);
    }

    public int gesdd(Layout layout, SVDJob jobz, int m, int n, float[] A, int lda, float[] s, float[] U, int ldu, float[] VT, int ldvt) {
        return mkl_rt.LAPACKE_sgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])s, (float[])U, (int)ldu, (float[])VT, (int)ldvt);
    }

    public int gesdd(Layout layout, SVDJob jobz, int m, int n, FloatBuffer A, int lda, FloatBuffer s, FloatBuffer U, int ldu, FloatBuffer VT, int ldvt) {
        return mkl_rt.LAPACKE_sgesdd((int)layout.lapack(), (byte)jobz.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)s, (FloatBuffer)U, (int)ldu, (FloatBuffer)VT, (int)ldvt);
    }

    public int getrf(Layout layout, int m, int n, DoubleBuffer A, int lda, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_dgetrf((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    public int getrf(Layout layout, int m, int n, double[] A, int lda, int[] ipiv) {
        return mkl_rt.LAPACKE_dgetrf((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (int[])ipiv);
    }

    public int getrf(Layout layout, int m, int n, float[] A, int lda, int[] ipiv) {
        return mkl_rt.LAPACKE_sgetrf((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (int[])ipiv);
    }

    public int getrf(Layout layout, int m, int n, FloatBuffer A, int lda, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_sgetrf((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    public int getrf2(Layout layout, int m, int n, double[] A, int lda, int[] ipiv) {
        return mkl_rt.LAPACKE_dgetrf2((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (int[])ipiv);
    }

    public int getrf2(Layout layout, int m, int n, DoubleBuffer A, int lda, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_dgetrf2((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    public int getrf2(Layout layout, int m, int n, float[] A, int lda, int[] ipiv) {
        return mkl_rt.LAPACKE_sgetrf2((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (int[])ipiv);
    }

    public int getrf2(Layout layout, int m, int n, FloatBuffer A, int lda, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_sgetrf2((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv);
    }

    public int gbtrf(Layout layout, int m, int n, int kl, int ku, double[] AB, int ldab, int[] ipiv) {
        return mkl_rt.LAPACKE_dgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (double[])AB, (int)ldab, (int[])ipiv);
    }

    public int gbtrf(Layout layout, int m, int n, int kl, int ku, DoubleBuffer AB, int ldab, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_dgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (DoubleBuffer)AB, (int)ldab, (IntBuffer)ipiv);
    }

    public int gbtrf(Layout layout, int m, int n, int kl, int ku, float[] AB, int ldab, int[] ipiv) {
        return mkl_rt.LAPACKE_sgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (float[])AB, (int)ldab, (int[])ipiv);
    }

    public int gbtrf(Layout layout, int m, int n, int kl, int ku, FloatBuffer AB, int ldab, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_sgbtrf((int)layout.lapack(), (int)m, (int)n, (int)kl, (int)ku, (FloatBuffer)AB, (int)ldab, (IntBuffer)ipiv);
    }

    public int sptrf(Layout layout, UPLO uplo, int n, double[] AP, int[] ipiv) {
        return mkl_rt.LAPACKE_dsptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])AP, (int[])ipiv);
    }

    public int sptrf(Layout layout, UPLO uplo, int n, DoubleBuffer AP, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_dsptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)AP, (IntBuffer)ipiv);
    }

    public int sptrf(Layout layout, UPLO uplo, int n, float[] AP, int[] ipiv) {
        return mkl_rt.LAPACKE_ssptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])AP, (int[])ipiv);
    }

    public int sptrf(Layout layout, UPLO uplo, int n, FloatBuffer AP, IntBuffer ipiv) {
        return mkl_rt.LAPACKE_ssptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)AP, (IntBuffer)ipiv);
    }

    public int getrs(Layout layout, Transpose trans, int n, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int getrs(Layout layout, Transpose trans, int n, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int getrs(Layout layout, Transpose trans, int n, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int getrs(Layout layout, Transpose trans, int n, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sgetrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, double[] A, int lda, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (double[])A, (int)lda, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, DoubleBuffer A, int lda, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (DoubleBuffer)A, (int)lda, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, float[] A, int lda, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_sgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (float[])A, (int)lda, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int gbtrs(Layout layout, Transpose trans, int n, int kl, int ku, int nrhs, FloatBuffer A, int lda, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_sgbtrs((int)layout.lapack(), (byte)trans.lapack(), (int)n, (int)kl, (int)ku, (int)nrhs, (FloatBuffer)A, (int)lda, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, double[] AP, int[] ipiv, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dsptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])AP, (int[])ipiv, (double[])B, (int)ldb);
    }

    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer AP, IntBuffer ipiv, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dsptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)AP, (IntBuffer)ipiv, (DoubleBuffer)B, (int)ldb);
    }

    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, float[] AP, int[] ipiv, float[] B, int ldb) {
        return mkl_rt.LAPACKE_ssptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])AP, (int[])ipiv, (float[])B, (int)ldb);
    }

    public int sptrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer AP, IntBuffer ipiv, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_ssptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)AP, (IntBuffer)ipiv, (FloatBuffer)B, (int)ldb);
    }

    public int potrf(Layout layout, UPLO uplo, int n, double[] A, int lda) {
        return mkl_rt.LAPACKE_dpotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda);
    }

    public int potrf(Layout layout, UPLO uplo, int n, DoubleBuffer A, int lda) {
        return mkl_rt.LAPACKE_dpotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda);
    }

    public int potrf(Layout layout, UPLO uplo, int n, float[] A, int lda) {
        return mkl_rt.LAPACKE_spotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda);
    }

    public int potrf(Layout layout, UPLO uplo, int n, FloatBuffer A, int lda) {
        return mkl_rt.LAPACKE_spotrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda);
    }

    public int potrf2(Layout layout, UPLO uplo, int n, double[] A, int lda) {
        return mkl_rt.LAPACKE_dpotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])A, (int)lda);
    }

    public int potrf2(Layout layout, UPLO uplo, int n, DoubleBuffer A, int lda) {
        return mkl_rt.LAPACKE_dpotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)A, (int)lda);
    }

    public int potrf2(Layout layout, UPLO uplo, int n, float[] A, int lda) {
        return mkl_rt.LAPACKE_spotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])A, (int)lda);
    }

    public int potrf2(Layout layout, UPLO uplo, int n, FloatBuffer A, int lda) {
        return mkl_rt.LAPACKE_spotrf2((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)A, (int)lda);
    }

    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, double[] AB, int ldab) {
        return mkl_rt.LAPACKE_dpbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (double[])AB, (int)ldab);
    }

    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, DoubleBuffer AB, int ldab) {
        return mkl_rt.LAPACKE_dpbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (DoubleBuffer)AB, (int)ldab);
    }

    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, float[] AB, int ldab) {
        return mkl_rt.LAPACKE_spbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (float[])AB, (int)ldab);
    }

    public int pbtrf(Layout layout, UPLO uplo, int n, int kd, FloatBuffer AB, int ldab) {
        return mkl_rt.LAPACKE_spbtrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (FloatBuffer)AB, (int)ldab);
    }

    public int pptrf(Layout layout, UPLO uplo, int n, double[] AP) {
        return mkl_rt.LAPACKE_dpptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (double[])AP);
    }

    public int pptrf(Layout layout, UPLO uplo, int n, DoubleBuffer AP) {
        return mkl_rt.LAPACKE_dpptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (DoubleBuffer)AP);
    }

    public int pptrf(Layout layout, UPLO uplo, int n, float[] AP) {
        return mkl_rt.LAPACKE_spptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (float[])AP);
    }

    public int pptrf(Layout layout, UPLO uplo, int n, FloatBuffer AP) {
        return mkl_rt.LAPACKE_spptrf((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (FloatBuffer)AP);
    }

    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dpotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dpotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return mkl_rt.LAPACKE_spotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    public int potrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_spotrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }

    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, double[] AB, int ldab, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dpbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (double[])AB, (int)ldab, (double[])B, (int)ldb);
    }

    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, DoubleBuffer AB, int ldab, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dpbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (DoubleBuffer)AB, (int)ldab, (DoubleBuffer)B, (int)ldb);
    }

    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, float[] AB, int ldab, float[] B, int ldb) {
        return mkl_rt.LAPACKE_spbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (float[])AB, (int)ldab, (float[])B, (int)ldb);
    }

    public int pbtrs(Layout layout, UPLO uplo, int n, int kd, int nrhs, FloatBuffer AB, int ldab, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_spbtrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)kd, (int)nrhs, (FloatBuffer)AB, (int)ldab, (FloatBuffer)B, (int)ldb);
    }

    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, double[] AP, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dpptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (double[])AP, (double[])B, (int)ldb);
    }

    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, DoubleBuffer AP, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dpptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (DoubleBuffer)AP, (DoubleBuffer)B, (int)ldb);
    }

    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, float[] AP, float[] B, int ldb) {
        return mkl_rt.LAPACKE_spptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (float[])AP, (float[])B, (int)ldb);
    }

    public int pptrs(Layout layout, UPLO uplo, int n, int nrhs, FloatBuffer AP, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_spptrs((int)layout.lapack(), (byte)uplo.lapack(), (int)n, (int)nrhs, (FloatBuffer)AP, (FloatBuffer)B, (int)ldb);
    }

    public int geqrf(Layout layout, int m, int n, double[] A, int lda, double[] tau) {
        return mkl_rt.LAPACKE_dgeqrf((int)layout.lapack(), (int)m, (int)n, (double[])A, (int)lda, (double[])tau);
    }

    public int geqrf(Layout layout, int m, int n, DoubleBuffer A, int lda, DoubleBuffer tau) {
        return mkl_rt.LAPACKE_dgeqrf((int)layout.lapack(), (int)m, (int)n, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau);
    }

    public int geqrf(Layout layout, int m, int n, float[] A, int lda, float[] tau) {
        return mkl_rt.LAPACKE_sgeqrf((int)layout.lapack(), (int)m, (int)n, (float[])A, (int)lda, (float[])tau);
    }

    public int geqrf(Layout layout, int m, int n, FloatBuffer A, int lda, FloatBuffer tau) {
        return mkl_rt.LAPACKE_sgeqrf((int)layout.lapack(), (int)m, (int)n, (FloatBuffer)A, (int)lda, (FloatBuffer)tau);
    }

    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, double[] A, int lda, double[] tau, double[] C, int ldc) {
        return mkl_rt.LAPACKE_dormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (double[])A, (int)lda, (double[])tau, (double[])C, (int)ldc);
    }

    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, DoubleBuffer A, int lda, DoubleBuffer tau, DoubleBuffer C, int ldc) {
        return mkl_rt.LAPACKE_dormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (DoubleBuffer)A, (int)lda, (DoubleBuffer)tau, (DoubleBuffer)C, (int)ldc);
    }

    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, float[] A, int lda, float[] tau, float[] C, int ldc) {
        return mkl_rt.LAPACKE_sormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (float[])A, (int)lda, (float[])tau, (float[])C, (int)ldc);
    }

    public int ormqr(Layout layout, Side side, Transpose trans, int m, int n, int k, FloatBuffer A, int lda, FloatBuffer tau, FloatBuffer C, int ldc) {
        return mkl_rt.LAPACKE_sormqr((int)layout.lapack(), (byte)side.lapack(), (byte)trans.lapack(), (int)m, (int)n, (int)k, (FloatBuffer)A, (int)lda, (FloatBuffer)tau, (FloatBuffer)C, (int)ldc);
    }

    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, double[] A, int lda, double[] B, int ldb) {
        return mkl_rt.LAPACKE_dtrtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (double[])A, (int)lda, (double[])B, (int)ldb);
    }

    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, DoubleBuffer A, int lda, DoubleBuffer B, int ldb) {
        return mkl_rt.LAPACKE_dtrtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (DoubleBuffer)A, (int)lda, (DoubleBuffer)B, (int)ldb);
    }

    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, float[] A, int lda, float[] B, int ldb) {
        return mkl_rt.LAPACKE_strtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (float[])A, (int)lda, (float[])B, (int)ldb);
    }

    public int trtrs(Layout layout, UPLO uplo, Transpose trans, Diag diag, int n, int nrhs, FloatBuffer A, int lda, FloatBuffer B, int ldb) {
        return mkl_rt.LAPACKE_strtrs((int)layout.lapack(), (byte)uplo.lapack(), (byte)trans.lapack(), (byte)diag.lapack(), (int)n, (int)nrhs, (FloatBuffer)A, (int)lda, (FloatBuffer)B, (int)ldb);
    }
}

