/*
 * Decompiled with CFR 0.152.
 */
package smile.math.distance;

import java.util.BitSet;
import smile.math.distance.Distance;

public class HammingDistance
implements Distance<BitSet> {
    public String toString() {
        return "Hamming Distance";
    }

    @Override
    public double d(BitSet x, BitSet y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException(String.format("BitSets have different length: x[%d], y[%d]", x.size(), y.size()));
        }
        int dist = 0;
        for (int i = 0; i < x.size(); ++i) {
            if (x.get(i) == y.get(i)) continue;
            ++dist;
        }
        return dist;
    }

    public static int d(byte x, byte y) {
        return HammingDistance.d((int)x, (int)y);
    }

    public static int d(short x, short y) {
        return HammingDistance.d((int)x, (int)y);
    }

    public static int d(int x, int y) {
        int dist = 0;
        for (int val = x ^ y; val != 0; val &= val - 1) {
            ++dist;
        }
        return dist;
    }

    public static int d(long x, long y) {
        int dist = 0;
        for (long val = x ^ y; val != 0L; val &= val - 1L) {
            ++dist;
        }
        return dist;
    }

    public static int d(byte[] x, byte[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int dist = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            ++dist;
        }
        return dist;
    }

    public static int d(short[] x, short[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int dist = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            ++dist;
        }
        return dist;
    }

    public static int d(int[] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("Arrays have different length: x[%d], y[%d]", x.length, y.length));
        }
        int dist = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            ++dist;
        }
        return dist;
    }
}

