/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation2D;
import smile.math.blas.UPLO;
import smile.math.matrix.Matrix;
import smile.math.rbf.GaussianRadialBasis;
import smile.math.rbf.RadialBasisFunction;

public class RBFInterpolation2D
implements Interpolation2D {
    private double[] x1;
    private double[] x2;
    private double[] w;
    private RadialBasisFunction rbf;
    private boolean normalized;

    public RBFInterpolation2D(double[] x1, double[] x2, double[] y, RadialBasisFunction rbf) {
        this(x1, x2, y, rbf, false);
    }

    public RBFInterpolation2D(double[] x1, double[] x2, double[] y, RadialBasisFunction rbf, boolean normalized) {
        if (x1.length != x2.length) {
            throw new IllegalArgumentException("x1.length != x2.length");
        }
        if (x1.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        this.x1 = x1;
        this.x2 = x2;
        this.rbf = rbf;
        this.normalized = normalized;
        int n = y.length;
        Matrix G = new Matrix(n, n);
        double[] rhs = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = 0; j <= i; ++j) {
                double d1 = x1[i] - x1[j];
                double d2 = x2[i] - x2[j];
                double d = Math.sqrt(d1 * d1 + d2 * d2);
                double r = rbf.f(d);
                G.set(i, j, r);
                G.set(j, i, r);
                sum += 2.0 * r;
            }
            rhs[i] = normalized ? sum * y[i] : y[i];
        }
        if (rbf instanceof GaussianRadialBasis) {
            G.uplo(UPLO.LOWER);
            Matrix.Cholesky cholesky = G.cholesky(true);
            this.w = cholesky.solve(rhs);
        } else {
            Matrix.LU lu = G.lu(true);
            this.w = lu.solve(rhs);
        }
    }

    @Override
    public double interpolate(double x1, double x2) {
        int n = this.x1.length;
        double sum = 0.0;
        double sumw = 0.0;
        for (int i = 0; i < n; ++i) {
            double d1 = x1 - this.x1[i];
            double d2 = x2 - this.x2[i];
            double d = Math.sqrt(d1 * d1 + d2 * d2);
            double r = this.rbf.f(d);
            sumw += this.w[i] * r;
            sum += r;
        }
        return this.normalized ? sumw / sum : sumw;
    }

    public String toString() {
        return String.format("RBF Interpolation(%s)", this.rbf);
    }
}

