/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.AbstractInterpolation;

public class CubicSplineInterpolation1D
extends AbstractInterpolation {
    private double[] y2;

    public CubicSplineInterpolation1D(double[] x, double[] y) {
        super(x, y);
        this.y2 = new double[x.length];
        this.sety2(x, y);
    }

    @Override
    public double rawinterp(int j, double x) {
        int khi = j + 1;
        int klo = j;
        double h = this.xx[khi] - this.xx[klo];
        if (h == 0.0) {
            throw new IllegalArgumentException("Nearby control points take same x value: " + this.xx[khi]);
        }
        double a = (this.xx[khi] - x) / h;
        double b = (x - this.xx[klo]) / h;
        double y = a * this.yy[klo] + b * this.yy[khi] + ((a * a * a - a) * this.y2[klo] + (b * b * b - b) * this.y2[khi]) * (h * h) / 6.0;
        return y;
    }

    private void sety2(double[] x, double[] y) {
        double[] u = new double[this.n - 1];
        u[0] = 0.0;
        this.y2[0] = 0.0;
        for (int i = 1; i < this.n - 1; ++i) {
            double sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
            double p = sig * this.y2[i - 1] + 2.0;
            this.y2[i] = (sig - 1.0) / p;
            u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
        }
        double un = 0.0;
        double qn = 0.0;
        this.y2[this.n - 1] = (un - qn * u[this.n - 2]) / (qn * this.y2[this.n - 2] + 1.0);
        for (int k = this.n - 2; k >= 0; --k) {
            this.y2[k] = this.y2[k] * this.y2[k + 1] + u[k];
        }
    }

    public String toString() {
        return "Cubic Spline Interpolation";
    }
}

