/*******************************************************************************
 * Copyright (c) 2010-2020 Haifeng Li. All rights reserved.
 *
 * Smile is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * Smile is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Smile.  If not, see <https://www.gnu.org/licenses/>.
 ******************************************************************************/

/**
 * Interpolation is the process of constructing a function that takes on
 * specified values at specified points. In engineering and science, one often
 * has a number of data points, obtained by sampling or experimentation, which
 * represent the values of a function for a limited number of values of the
 * independent variable. It is often required to interpolate (i.e. estimate)
 * the value of that function for an intermediate value of the independent
 * variable. A different problem which is closely related to interpolation is
 * the approximation of a complicated function by a simple function. 
 * 
 * @author Haifeng Li
 */
package smile.interpolation;