/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.math.matrix.Matrix;
import smile.math.special.Beta;
import smile.regression.LinearModel;

public class OLS {
    private static final Logger logger = LoggerFactory.getLogger(OLS.class);

    public static LinearModel fit(Formula formula, DataFrame data) {
        return OLS.fit(formula, data, new Properties());
    }

    public static LinearModel fit(Formula formula, DataFrame data, Properties params) {
        String method = params.getProperty("smile.ols.method", "qr");
        boolean stderr = Boolean.parseBoolean(params.getProperty("smile.ols.standard_error", "true"));
        boolean recursive = Boolean.parseBoolean(params.getProperty("smile.ols.recursive", "true"));
        return OLS.fit(formula, data, method, stderr, recursive);
    }

    public static LinearModel fit(Formula formula, DataFrame data, String method, boolean stderr, boolean recursive) {
        double[] w;
        Matrix.SVD svd;
        int p;
        formula = formula.expand(data.schema());
        StructType schema = formula.bind(data.schema());
        Matrix X = formula.matrix(data);
        double[] y = formula.y(data).toDoubleArray();
        int n = X.nrow();
        if (n <= (p = X.ncol())) {
            throw new IllegalArgumentException(String.format("The input matrix is not over determined: %d rows, %d columns", n, p));
        }
        Matrix.QR qr = null;
        if (method.equalsIgnoreCase("svd")) {
            svd = X.svd();
            w = svd.solve(y);
        } else {
            try {
                qr = X.qr();
                w = qr.solve(y);
            }
            catch (RuntimeException e) {
                logger.warn("Matrix is not of full rank, try SVD instead");
                method = "svd";
                svd = X.svd();
                w = svd.solve(y);
            }
        }
        LinearModel model = new LinearModel(formula, schema, X, y, w, 0.0);
        Matrix inv = null;
        if (stderr || recursive) {
            Matrix.Cholesky cholesky = method.equalsIgnoreCase("svd") ? X.ata().cholesky(true) : qr.CholeskyOfAtA();
            model.V = inv = cholesky.inverse();
        }
        if (stderr) {
            double[][] ttest = new double[p][4];
            model.ttest = ttest;
            for (int i = 0; i < p; ++i) {
                double t;
                double se;
                ttest[i][0] = w[i];
                ttest[i][1] = se = model.error * Math.sqrt(inv.get(i, i));
                ttest[i][2] = t = w[i] / se;
                ttest[i][3] = Beta.regularizedIncompleteBetaFunction((double)(0.5 * (double)model.df), (double)0.5, (double)((double)model.df / ((double)model.df + t * t)));
            }
        }
        return model;
    }
}

